/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.BlockingIncomingHandshaker;
import com.limegroup.gnutella.handshaking.BlockingOutgoingHandshaker;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.CompressionStat;
import com.limegroup.gnutella.statistics.ConnectionStat;
import com.limegroup.gnutella.util.CompressingOutputStream;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.util.UncompressingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connection
implements IpPort {
    private static final Log LOG = LogFactory.getLog(Connection.class);
    private final Object PING_LOCK = new Object();
    private final Object PONG_LOCK = new Object();
    private final String _host;
    private int _port;
    protected volatile Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private final boolean OUTGOING;
    protected Inflater _inflater;
    protected Deflater _deflater;
    private volatile long _bytesSent;
    private volatile long _bytesReceived;
    private volatile long _compressedBytesSent;
    private volatile long _compressedBytesReceived;
    protected MessagesSupportedVendorMessage _messagesSupported = null;
    protected CapabilitiesVM _capabilities = null;
    protected volatile boolean _closed = false;
    private HandshakeResponse _headersRead = HandshakeResponse.createEmptyResponse();
    private HandshakeResponse _headersWritten = HandshakeResponse.createEmptyResponse();
    private long _connectionTime = Long.MAX_VALUE;
    private byte _softMax;
    private volatile long _nextPingTime = Long.MIN_VALUE;
    private volatile long _nextPongTime = Long.MIN_VALUE;
    protected static final IOException CONNECTION_CLOSED = new IOException("connection closed");
    private final byte[] HEADER_BUF = new byte[23];
    private final byte[] OUT_HEADER_BUF = new byte[23];

    public Connection(String host, int port) {
        if (host == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("illegal port: " + port);
        }
        this._host = host;
        this._port = port;
        this.OUTGOING = true;
        ConnectionStat.OUTGOING_CONNECTION_ATTEMPTS.incrementStat();
    }

    public Connection(Socket socket) {
        if (socket == null) {
            throw new NullPointerException("null socket");
        }
        this._host = socket.getInetAddress().getHostAddress();
        this._port = socket.getPort();
        this._socket = socket;
        this.OUTGOING = false;
        ConnectionStat.INCOMING_CONNECTION_ATTEMPTS.incrementStat();
    }

    protected void postInit() {
        try {
            if (this._headersRead.supportsVendorMessages() > 0.0f) {
                this.send(MessagesSupportedVendorMessage.instance());
                this.send(CapabilitiesVM.instance());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendUpdatedCapabilities() {
        try {
            if (this._headersRead.supportsVendorMessages() > 0.0f) {
                this.send(CapabilitiesVM.instance());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleVendorMessage(VendorMessage vm) {
        if (vm instanceof MessagesSupportedVendorMessage) {
            this._messagesSupported = (MessagesSupportedVendorMessage)vm;
        }
        if (vm instanceof CapabilitiesVM) {
            this._capabilities = (CapabilitiesVM)vm;
        }
        if (vm instanceof HeaderUpdateVendorMessage) {
            HeaderUpdateVendorMessage huvm = (HeaderUpdateVendorMessage)vm;
            Properties props = this._headersRead.props();
            props.putAll((Map<?, ?>)huvm.getProperties());
            this._headersRead = HandshakeResponse.createResponse(props);
        }
    }

    public void initialize(Properties requestHeaders, HandshakeResponder responder) throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(requestHeaders, responder, 0, null);
    }

    public void initialize(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(requestHeaders, responder, 0, observer);
    }

    protected void initialize(Properties requestHeaders, HandshakeResponder responder, int timeout, GnetConnectObserver observer) throws IOException, NoGnutellaOkException, BadHandshakeException {
        if (this.isOutgoing()) {
            if (observer != null) {
                this._socket = this.connect(this._host, this._port, timeout, this.createAsyncConnectObserver(requestHeaders, responder, observer));
            } else {
                this._socket = this.connect(this._host, this._port, timeout);
                this.preHandshakeInitialize(requestHeaders, responder, observer);
            }
        } else {
            this.preHandshakeInitialize(requestHeaders, responder, observer);
        }
    }

    protected Socket connect(String addr, int port, int timeout) throws IOException {
        return Sockets.connect(addr, port, timeout);
    }

    protected Socket connect(String addr, int port, int timeout, ConnectObserver observer) throws IOException {
        return Sockets.connect(addr, port, timeout, observer);
    }

    protected ConnectObserver createAsyncConnectObserver(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) {
        return new Connector(requestHeaders, responder, observer);
    }

    protected void preHandshakeInitialize(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) throws IOException, NoGnutellaOkException, BadHandshakeException {
        if (this._closed) {
            this._socket.close();
            throw CONNECTION_CLOSED;
        }
        InetAddress localAddress = this._socket.getLocalAddress();
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && this._socket.getInetAddress().equals(localAddress) && this._port == ConnectionSettings.PORT.getValue()) {
            throw new IOException("Connection to self");
        }
        RouterService.getAcceptor().setAddress(localAddress);
        this.performHandshake(requestHeaders, responder, observer);
    }

    protected void performHandshake(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) throws IOException, BadHandshakeException, NoGnutellaOkException {
        Handshaker shaker = this.createHandshaker(requestHeaders, responder);
        try {
            shaker.shake();
        }
        catch (NoGnutellaOkException e) {
            this.setHeaders(shaker);
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.setHeaders(shaker);
            this.close();
            throw new BadHandshakeException(e);
        }
        this.postHandshakeInitialize(shaker);
    }

    protected Handshaker createHandshaker(Properties requestHeaders, HandshakeResponder responder) throws IOException {
        try {
            this._in = this.getInputStream();
            this._out = this.getOutputStream();
            if (this._in == null) {
                throw new IOException("null input stream");
            }
            if (this._out == null) {
                throw new IOException("null output stream");
            }
        }
        catch (Exception e) {
            this.close();
            throw new IOException("could not establish connection");
        }
        if (this.isOutgoing()) {
            return new BlockingOutgoingHandshaker(requestHeaders, responder, this._socket, this._in, this._out);
        }
        return new BlockingIncomingHandshaker(responder, this._socket, this._in, this._out);
    }

    protected void setHeaders(Handshaker shaker) {
        this._headersWritten = shaker.getWrittenHeaders();
        this._headersRead = shaker.getReadHeaders();
    }

    protected void postHandshakeInitialize(Handshaker shaker) {
        this.setHeaders(shaker);
        this._connectionTime = System.currentTimeMillis();
        this._softMax = ConnectionSettings.SOFT_MAX.getValue();
        if (this.isGoodUltrapeer() || this.isGoodLeaf()) {
            this._softMax = (byte)(this._softMax + 1);
        }
        if (this.isWriteDeflated()) {
            this._deflater = new Deflater();
            this._out = this.createDeflatedOutputStream(this._out);
        }
        if (this.isReadDeflated()) {
            this._inflater = new Inflater();
            this._in = this.createInflatedInputStream(this._in);
        }
    }

    protected OutputStream createDeflatedOutputStream(OutputStream out) {
        return new CompressingOutputStream(out, this._deflater);
    }

    protected InputStream createInflatedInputStream(InputStream in) {
        return new UncompressingInputStream(in, this._inflater);
    }

    public boolean isAsynchronous() {
        return this._socket.getChannel() != null;
    }

    public boolean isInitialized() {
        return this._socket != null;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.isAsynchronous()) {
            return this._socket.getOutputStream();
        }
        return new BufferedOutputStream(this._socket.getOutputStream());
    }

    protected InputStream getInputStream() throws IOException {
        if (this.isAsynchronous()) {
            return this._socket.getInputStream();
        }
        return new BufferedInputStream(this._socket.getInputStream());
    }

    public boolean isOutgoing() {
        return this.OUTGOING;
    }

    protected Message receive() throws IOException, BadPacketException {
        if (this.isAsynchronous() && this.isReadDeflated() && !(this._in instanceof UncompressingInputStream)) {
            this._in = new UncompressingInputStream(this._in, this._inflater);
        }
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        Message m = null;
        while (m == null) {
            m = this.readAndUpdateStatistics();
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(int timeout) throws IOException, BadPacketException, InterruptedIOException {
        if (this.isAsynchronous() && this.isReadDeflated() && !(this._in instanceof UncompressingInputStream)) {
            this._in = new UncompressingInputStream(this._in, this._inflater);
        }
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        int oldTimeout = this._socket.getSoTimeout();
        this._socket.setSoTimeout(timeout);
        try {
            Message m = this.readAndUpdateStatistics();
            if (m == null) {
                throw new InterruptedIOException("null message read");
            }
            Message message = m;
            return message;
        }
        finally {
            this._socket.setSoTimeout(oldTimeout);
        }
    }

    private Message readAndUpdateStatistics() throws IOException, BadPacketException {
        Message msg = MessageFactory.read(this._in, this.HEADER_BUF, 1, this._softMax);
        this.updateReadStatistics(msg);
        return msg;
    }

    protected void updateReadStatistics(Message msg) throws IOException {
        if (this.isReadDeflated()) {
            try {
                long newIn = this._inflater.getTotalIn();
                long newOut = this._inflater.getTotalOut();
                CompressionStat.GNUTELLA_UNCOMPRESSED_DOWNSTREAM.addData((int)(newOut - this._bytesReceived));
                CompressionStat.GNUTELLA_COMPRESSED_DOWNSTREAM.addData((int)(newIn - this._compressedBytesReceived));
                this._compressedBytesReceived = newIn;
                this._bytesReceived = newOut;
            }
            catch (NullPointerException npe) {
                throw CONNECTION_CLOSED;
            }
        } else if (msg != null) {
            this._bytesReceived += (long)msg.getTotalLength();
        }
    }

    public void send(Message m) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Connection (" + this.toString() + ") is sending message: " + m);
        }
        try {
            m.write(this._out, this.OUT_HEADER_BUF);
            this.updateWriteStatistics(m);
        }
        catch (NullPointerException e) {
            throw CONNECTION_CLOSED;
        }
    }

    public void flush() throws IOException {
        try {
            this._out.flush();
            this.updateWriteStatistics(null);
        }
        catch (NullPointerException npe) {
            throw CONNECTION_CLOSED;
        }
    }

    protected void updateWriteStatistics(Message m) {
        if (this.isWriteDeflated()) {
            long newIn = this._deflater.getTotalIn();
            long newOut = this._deflater.getTotalOut();
            CompressionStat.GNUTELLA_UNCOMPRESSED_UPSTREAM.addData((int)(newIn - this._bytesSent));
            CompressionStat.GNUTELLA_COMPRESSED_UPSTREAM.addData((int)(newOut - this._compressedBytesSent));
            this._bytesSent = newIn;
            this._compressedBytesSent = newOut;
        } else if (m != null) {
            this._bytesSent += (long)m.getTotalLength();
        }
    }

    public long getBytesSent() {
        if (this.isWriteDeflated()) {
            return this._compressedBytesSent;
        }
        return this._bytesSent;
    }

    public long getUncompressedBytesSent() {
        return this._bytesSent;
    }

    public long getBytesReceived() {
        if (this.isReadDeflated()) {
            return this._compressedBytesReceived;
        }
        return this._bytesReceived;
    }

    public long getUncompressedBytesReceived() {
        return this._bytesReceived;
    }

    public float getSentSavedFromCompression() {
        if (!this.isWriteDeflated() || this._bytesSent == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesSent / (float)this._bytesSent;
    }

    public float getReadSavedFromCompression() {
        if (!this.isReadDeflated() || this._bytesReceived == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesReceived / (float)this._bytesReceived;
    }

    public String getAddress() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public int getListeningPort() {
        if (this.isOutgoing()) {
            if (this._socket == null) {
                return -1;
            }
            return this._socket.getPort();
        }
        return this._headersRead.getListeningPort();
    }

    void setListeningPort(int port) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this._port = port;
    }

    public InetAddress getInetAddress() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket.getInetAddress();
    }

    public Socket getSocket() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket;
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public byte getSoftMax() {
        return this._softMax;
    }

    public boolean isStable() {
        return this.isStable(System.currentTimeMillis());
    }

    public boolean isStable(long millis) {
        return (millis - this.getConnectionTime()) / 1000L > 5L;
    }

    public int supportsVendorMessage(byte[] vendorID, int selector) {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsMessage(vendorID, selector);
        }
        return -1;
    }

    public boolean supportsVMRouting() {
        if (this._headersRead != null) {
            return (double)this._headersRead.supportsVendorMessages() >= 0.2;
        }
        return false;
    }

    public int remoteHostSupportsUDPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsTCPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsTCPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsUDPRedirect() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsTCPRedirect() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsTCPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsUDPCrawling() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPCrawling();
        }
        return -1;
    }

    public int remoteHostSupportsHopsFlow() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsHopsFlow();
        }
        return -1;
    }

    public int remoteHostSupportsPushProxy() {
        if (this._messagesSupported != null && this.isClientSupernodeConnection()) {
            return this._messagesSupported.supportsPushProxy();
        }
        return -1;
    }

    public int remoteHostSupportsLeafGuidance() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsLeafGuidance();
        }
        return -1;
    }

    public int remoteHostSupportsHeaderUpdate() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsHeaderUpdate();
        }
        return -1;
    }

    public boolean getRemoteHostSupportsFeatureQueries() {
        if (this._capabilities != null) {
            return this._capabilities.supportsFeatureQueries() > 0;
        }
        return false;
    }

    public int getRemoteHostFeatureQuerySelector() {
        if (this._capabilities != null) {
            return this._capabilities.supportsFeatureQueries();
        }
        return -1;
    }

    public boolean remoteHostSupportsWhatIsNew() {
        if (this._capabilities != null) {
            return this._capabilities.supportsWhatIsNew();
        }
        return false;
    }

    public int getRemoteHostUpdateVersion() {
        if (this._capabilities != null) {
            return this._capabilities.supportsUpdate();
        }
        return -1;
    }

    protected boolean isLocal() {
        return NetworkUtils.isLocalAddress(this._socket.getInetAddress());
    }

    public String getPropertyWritten(String name) {
        return this._headersWritten.props().getProperty(name);
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._deflater != null) {
            this._deflater.end();
        }
        if (this._inflater != null) {
            this._inflater.end();
        }
        IOUtils.close(this._in);
        IOUtils.close(this._out);
    }

    public String getUserAgent() {
        return this._headersRead.getUserAgent();
    }

    public boolean isLimeWire() {
        return this._headersRead.isLimeWire();
    }

    public boolean isOldLimeWire() {
        return this._headersRead.isOldLimeWire();
    }

    public boolean isWriteDeflated() {
        return this._headersWritten.isDeflateEnabled();
    }

    public boolean isReadDeflated() {
        return this._headersRead.isDeflateEnabled();
    }

    public boolean isGoodUltrapeer() {
        return this._headersRead.isGoodUltrapeer();
    }

    public boolean isGoodLeaf() {
        return this._headersRead.isGoodLeaf();
    }

    public boolean supportsPongCaching() {
        return this._headersRead.supportsPongCaching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPings() {
        Object object = this.PING_LOCK;
        synchronized (object) {
            long curTime = System.currentTimeMillis();
            if (!this.isStable(curTime)) {
                return false;
            }
            if (curTime < this._nextPingTime) {
                return false;
            }
            this._nextPingTime = System.currentTimeMillis() + 2500L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPongs() {
        Object object = this.PONG_LOCK;
        synchronized (object) {
            long curTime = System.currentTimeMillis();
            if (!this.isStable(curTime)) {
                return false;
            }
            if (curTime < this._nextPongTime) {
                return false;
            }
            int interval = curTime - this.getConnectionTime() < 10000L ? 300 : 12000;
            this._nextPongTime = curTime + (long)interval;
            return true;
        }
    }

    public int getNumIntraUltrapeerConnections() {
        return this._headersRead.getNumIntraUltrapeerConnections();
    }

    public boolean isHighDegreeConnection() {
        return this._headersRead.isHighDegreeConnection();
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this._headersRead.isUltrapeerQueryRoutingConnection();
    }

    public boolean supportsProbeQueries() {
        return this._headersRead.supportsProbeQueries();
    }

    public boolean receivedHeaders() {
        return this._headersRead != HandshakeResponse.createEmptyResponse();
    }

    public HandshakeResponse headers() {
        return this._headersRead;
    }

    public String getVersion() {
        return this._headersRead.getVersion();
    }

    public boolean isLeafConnection() {
        return this._headersRead.isLeaf();
    }

    public boolean isSupernodeConnection() {
        return this._headersRead.isUltrapeer();
    }

    public boolean isClientSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String value = this.getPropertyWritten("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value) == false;
    }

    public boolean isSupernodeSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String value = this.getPropertyWritten("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean isGUESSCapable() {
        return this._headersRead.isGUESSCapable();
    }

    public boolean isGUESSUltrapeer() {
        return this._headersRead.isGUESSUltrapeer();
    }

    public boolean isTempConnection() {
        return this._headersRead.isTempConnection();
    }

    public boolean isSupernodeClientConnection() {
        if (!this.isLeafConnection()) {
            return false;
        }
        String value = this.getPropertyWritten("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        if (!Boolean.valueOf(value).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    public boolean supportsGGEP() {
        return this._headersRead.supportsGGEP();
    }

    public void handleStatisticVM(StatisticVendorMessage svm) throws IOException {
        this.send(svm);
    }

    public void handleSimppVM(SimppVM simppVM) throws IOException {
        this.send(simppVM);
    }

    boolean isQueryRoutingEnabled() {
        return this._headersRead.isQueryRoutingEnabled();
    }

    public String toString() {
        return "CONNECTION: host=" + this._host + " port=" + this._port;
    }

    public String getLocalePref() {
        return this._headersRead.getLocalePref();
    }

    private class Connector
    implements ConnectObserver,
    Runnable {
        private final Properties requestHeaders;
        private final HandshakeResponder responder;
        private final GnetConnectObserver observer;

        Connector(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) {
            this.requestHeaders = requestHeaders;
            this.responder = responder;
            this.observer = observer;
        }

        public void handleIOException(IOException iox) {
        }

        public void shutdown() {
            this.observer.shutdown();
        }

        public void handleConnect(Socket socket) {
            Connection.this._socket = socket;
            ThreadFactory.startThread(this, "Handshaking");
        }

        public void run() {
            try {
                Connection.this.preHandshakeInitialize(this.requestHeaders, this.responder, this.observer);
                this.observer.handleConnect();
            }
            catch (NoGnutellaOkException ex) {
                this.observer.handleNoGnutellaOk(ex.getCode(), ex.getMessage());
            }
            catch (BadHandshakeException ex) {
                this.observer.handleBadHandshake();
            }
            catch (IOException iox) {
                this.observer.shutdown();
            }
        }
    }
}

