/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.tigertree.HashTree;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;

public class IncompleteFileDesc
extends FileDesc
implements HTTPHeaderValue {
    private static final int MIN_CHUNK_SIZE = 102400;
    private VerifyingFile _verifyingFile;
    private final String _name;
    private final int _size;

    public IncompleteFileDesc(File file, Set urns, int index, String completedName, int completedSize, VerifyingFile vf) {
        super(file, urns, index);
        this._name = completedName;
        this._size = completedSize;
        this._verifyingFile = vf;
    }

    public long getFileSize() {
        return this._size;
    }

    public String getFileName() {
        return this._name;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        if (this.getFile().length() == 0L) {
            throw new FileNotFoundException("nothing downloaded");
        }
        return new BufferedInputStream(new FileInputStream(this.getFile()));
    }

    public HashTree getHashTree() {
        return null;
    }

    private ManagedDownloader getMyDownloader() {
        return RouterService.getDownloadManager().getDownloaderForURN(this.getSHA1Urn());
    }

    public boolean isActivelyDownloading() {
        ManagedDownloader md = this.getMyDownloader();
        if (md == null) {
            return false;
        }
        switch (md.getState()) {
            case 0: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                return false;
            }
        }
        return true;
    }

    public byte[] getRangesAsByte() {
        return this._verifyingFile.toBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAvailableRanges() {
        StringBuffer ret = new StringBuffer("bytes");
        boolean added = false;
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iter = this._verifyingFile.getVerifiedBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.high - interval.low + 1 < 102400) continue;
                added = true;
                ret.append(" ").append(interval.low).append("-").append(interval.high - 1).append(",");
            }
        }
        if (added) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeSatisfiable(int low, int high) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iter = this._verifyingFile.getVerifiedBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (low < interval.low || high > interval.high) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interval getAvailableSubRange(int low, int high) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iter = this._verifyingFile.getVerifiedBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.low <= high && low <= interval.high) {
                    return new Interval(Math.max(interval.low, low), Math.min(interval.high, high));
                }
                if (interval.low <= high) continue;
                break;
            }
            return null;
        }
    }

    public boolean isRangeSatisfiable(Interval range) {
        return this.isRangeSatisfiable(range.low, range.high);
    }

    public String httpStringValue() {
        return this.getAvailableRanges();
    }

    public String toString() {
        return "IncompleteFileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this.getIndex() + "\r\n";
    }
}

