/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapFactory;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.UpdateResponse;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.statistics.RouteErrorStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.util.FixedsizeHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.NoMoreStorageException;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.version.UpdateHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessageRouter {
    private static final Log LOG = LogFactory.getLog(MessageRouter.class);
    protected static ConnectionManager _manager;
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private final ReplyHandler FOR_ME_REPLY_HANDLER = ForMeReplyHandler.instance();
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    private final int MAX_BYPASSED_RESULTS = 150;
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _headPongRouteTable = new RouteTable(10, this.MAX_ROUTE_TABLE_SIZE);
    private static final long CLEAR_TIME = 30000L;
    private static final long HOPS_FLOW_INTERVAL = 15000L;
    static int MAX_BUFFERED_REPLIES;
    private final Map _outOfBandReplies = new Hashtable();
    private final Map _bypassedResults = new HashMap();
    private static final FixedsizeHashMap _udpConnectBacks;
    private static final int MAX_UDP_CONNECTBACK_FORWARDS = 5;
    private static final FixedsizeHashMap _tcpConnectBacks;
    private static final int MAX_TCP_CONNECTBACK_FORWARDS = 5;
    private static final ProcessingQueue TCP_CONNECT_BACKER;
    protected final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    private final QueryDispatcher DYNAMIC_QUERIER = QueryDispatcher.instance();
    private ActivityCallback _callback;
    private static FileManager _fileManager;
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private volatile Map _messageListeners = Collections.EMPTY_MAP;
    private final Object MESSAGE_LISTENER_LOCK = new Object();
    private PromotionManager _promotionManager;
    private long _lastQueryKeyTime;
    private volatile Map messageHandlers = new IdentityHashMap();
    private volatile Map udpMessageHandlers = new IdentityHashMap();
    private volatile Map multicastMessageHandlers = new IdentityHashMap();
    private GuidMap _multicastGuidMap = GuidMapFactory.getMap();
    private static final long MULTICAST_GUID_EXPIRE_TIME = 60000L;

    protected MessageRouter() {
        this._clientGUID = RouterService.getMyGUID();
        this.setMessageHandler(PingRequest.class, new PingRequestHandler());
        this.setMessageHandler(PingReply.class, new PingReplyHandler());
        this.setMessageHandler(QueryRequest.class, new QueryRequestHandler());
        this.setMessageHandler(QueryReply.class, new QueryReplyHandler());
        this.setMessageHandler(PushRequest.class, new PushRequestHandler());
        this.setMessageHandler(ResetTableMessage.class, new ResetTableHandler());
        this.setMessageHandler(PatchTableMessage.class, new PatchTableHandler());
        this.setMessageHandler(TCPConnectBackVendorMessage.class, new TCPConnectBackHandler());
        this.setMessageHandler(UDPConnectBackVendorMessage.class, new UDPConnectBackHandler());
        this.setMessageHandler(TCPConnectBackRedirect.class, new TCPConnectBackRedirectHandler());
        this.setMessageHandler(UDPConnectBackRedirect.class, new UDPConnectBackRedirectHandler());
        this.setMessageHandler(PushProxyRequest.class, new PushProxyRequestHandler());
        this.setMessageHandler(QueryStatusResponse.class, new QueryStatusResponseHandler());
        this.setMessageHandler(GiveStatsVendorMessage.class, new GiveStatsHandler());
        this.setMessageHandler(StatisticVendorMessage.class, new StatisticsHandler());
        this.setMessageHandler(HeadPing.class, new HeadPingHandler());
        this.setMessageHandler(SimppRequestVM.class, new SimppRequestVMHandler());
        this.setMessageHandler(SimppVM.class, new SimppVMHandler());
        this.setMessageHandler(UpdateRequest.class, new UpdateRequestHandler());
        this.setMessageHandler(UpdateResponse.class, new UpdateResponseHandler());
        this.setMessageHandler(HeadPong.class, new HeadPongHandler());
        this.setMessageHandler(VendorMessage.class, new VendorMessageHandler());
        this.setUDPMessageHandler(QueryRequest.class, new UDPQueryRequestHandler());
        this.setUDPMessageHandler(QueryReply.class, new UDPQueryReplyHandler());
        this.setUDPMessageHandler(PingRequest.class, new UDPPingRequestHandler());
        this.setUDPMessageHandler(PingReply.class, new UDPPingReplyHandler());
        this.setUDPMessageHandler(PushRequest.class, new UDPPushRequestHandler());
        this.setUDPMessageHandler(LimeACKVendorMessage.class, new UDPLimeACKVendorMessageHandler());
        this.setUDPMessageHandler(ReplyNumberVendorMessage.class, new UDPReplyNumberMessageHandler());
        this.setUDPMessageHandler(GiveStatsVendorMessage.class, new UDPGiveStatsHandler());
        this.setUDPMessageHandler(StatisticVendorMessage.class, new UDPStatisticsMessageHandler());
        this.setUDPMessageHandler(UDPCrawlerPing.class, new UDPUDPCrawlerPingHandler());
        this.setUDPMessageHandler(HeadPing.class, new UDPHeadPingHandler());
        this.setUDPMessageHandler(UpdateRequest.class, new UDPUpdateRequestHandler());
        this.setUDPMessageHandler(ContentResponse.class, new UDPContentResponseHandler());
        this.setMulticastMessageHandler(QueryRequest.class, new MulticastQueryRequestHandler());
        this.setMulticastMessageHandler(PingRequest.class, new MulticastPingRequestHandler());
        this.setMulticastMessageHandler(PushRequest.class, new MulticastPushRequestHandler());
    }

    private static Map setHandler(Map handlerMap, Class clazz, MessageHandler handler) {
        if (clazz == null) {
            throw new NullPointerException("Class is null");
        }
        if (handler == null) {
            throw new NullPointerException("MessageHandler is null");
        }
        IdentityHashMap<Class, MessageHandler> copy = new IdentityHashMap<Class, MessageHandler>(handlerMap);
        MessageHandler o = copy.put(clazz, handler);
        if (o != null && LOG.isErrorEnabled()) {
            LOG.error("There was already a MessageHandler of type " + o.getClass() + " registered for " + clazz);
        }
        return copy;
    }

    private static MessageHandler getHandler(Map messageHandlers, Class clazz) {
        return (MessageHandler)messageHandlers.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageHandler(Class clazz, MessageHandler handler) {
        Map map = this.messageHandlers;
        synchronized (map) {
            this.messageHandlers = MessageRouter.setHandler(this.messageHandlers, clazz, handler);
        }
    }

    public MessageHandler getMessageHandler(Class clazz) {
        return MessageRouter.getHandler(this.messageHandlers, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUDPMessageHandler(Class clazz, MessageHandler handler) {
        Map map = this.udpMessageHandlers;
        synchronized (map) {
            this.udpMessageHandlers = MessageRouter.setHandler(this.udpMessageHandlers, clazz, handler);
        }
    }

    public MessageHandler getUDPMessageHandler(Class clazz) {
        return MessageRouter.getHandler(this.udpMessageHandlers, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMulticastMessageHandler(Class clazz, MessageHandler handler) {
        Map map = this.multicastMessageHandlers;
        synchronized (map) {
            this.multicastMessageHandlers = MessageRouter.setHandler(this.multicastMessageHandlers, clazz, handler);
        }
    }

    public MessageHandler getMulticastMessageHandler(Class clazz) {
        return MessageRouter.getHandler(this.multicastMessageHandlers, clazz);
    }

    public void initialize() {
        _manager = RouterService.getConnectionManager();
        this._callback = RouterService.getCallback();
        _fileManager = RouterService.getFileManager();
        this._promotionManager = RouterService.getPromotionManager();
        this.QRP_PROPAGATOR.start();
        RouterService.schedule(new Expirer(), 30000L, 30000L);
        RouterService.schedule(new ConnectBackExpirer(), 300000L, 300000L);
        RouterService.schedule(new HopsFlowManager(), 150000L, 15000L);
    }

    public void originateQueryGUID(byte[] guid) {
        this._queryRouteTable.routeReply(guid, this.FOR_ME_REPLY_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKilled(GUID guid) throws IllegalArgumentException {
        if (guid == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!RouterService.getDownloadManager().isGuidForQueryDownloading(guid)) {
                this._bypassedResults.remove(guid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFinished(GUID guid) throws IllegalArgumentException {
        if (guid == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!this._callback.isQueryAlive(guid) && !RouterService.getDownloadManager().isGuidForQueryDownloading(guid)) {
                this._bypassedResults.remove(guid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGuessLocs(GUID guid) {
        HashSet clone = new HashSet();
        Map map = this._bypassedResults;
        synchronized (map) {
            Set eps = (Set)this._bypassedResults.get(guid);
            if (eps != null) {
                clone.addAll(eps);
            }
        }
        return clone;
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ReplyHandler rh) {
        this.DYNAMIC_QUERIER.removeReplyHandler(rh);
        this._pingRouteTable.removeReplyHandler(rh);
        this._queryRouteTable.removeReplyHandler(rh);
        this._pushRouteTable.removeReplyHandler(rh);
        this._headPongRouteTable.removeReplyHandler(rh);
    }

    public void handleMessage(Message msg, ManagedConnection receivingConnection) {
        msg.hop();
        MessageHandler msgHandler = this.getMessageHandler(msg.getClass());
        if (msgHandler != null) {
            msgHandler.handleMessage(msg, null, receivingConnection);
        } else if (msg instanceof VendorMessage && (msgHandler = this.getMessageHandler(VendorMessage.class)) != null) {
            msgHandler.handleMessage(msg, null, receivingConnection);
        }
        this.notifyMessageListener(msg, receivingConnection);
    }

    private final void notifyMessageListener(Message msg, ReplyHandler handler) {
        List all = (List)this._messageListeners.get(msg.getGUID());
        if (all != null) {
            Iterator i = all.iterator();
            while (i.hasNext()) {
                MessageListener next = (MessageListener)i.next();
                next.processMessage(msg, handler);
            }
        }
    }

    public void handleUDPMessage(Message msg, InetSocketAddress addr) {
        byte[] origGUID;
        msg.hop();
        if (msg instanceof UDPConnectionMessage) {
            RouterService.getUDPMultiplexor().routeMessage((UDPConnectionMessage)msg, addr);
            return;
        }
        if (msg instanceof QueryReply && (origGUID = this._multicastGuidMap.getOriginalGUID(msg.getGUID())) != null) {
            msg = new QueryReply(origGUID, (QueryReply)msg);
            ((QueryReply)msg).setMulticastAllowed(true);
        }
        InetAddress address = addr.getAddress();
        int port = addr.getPort();
        UDPReplyHandler replyHandler = new UDPReplyHandler(address, port);
        MessageHandler msgHandler = this.getUDPMessageHandler(msg.getClass());
        if (msgHandler != null) {
            msgHandler.handleMessage(msg, addr, replyHandler);
        }
        this.notifyMessageListener(msg, replyHandler);
    }

    public void handleMulticastMessage(Message msg, InetSocketAddress addr) {
        if (msg.getTTL() > 1) {
            return;
        }
        msg.hop();
        InetAddress address = addr.getAddress();
        int port = addr.getPort();
        if (NetworkUtils.isLocalAddress(address) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        UDPReplyHandler replyHandler = new UDPReplyHandler(address, port);
        MessageHandler msgHandler = this.getMulticastMessageHandler(msg.getClass());
        if (msgHandler != null) {
            msgHandler.handleMessage(msg, addr, replyHandler);
        }
        this.notifyMessageListener(msg, replyHandler);
    }

    protected boolean hasValidQueryKey(InetAddress ip, int port, QueryRequest qr) {
        QueryKey qk = qr.getQueryKey();
        if (qk == null) {
            return false;
        }
        return qk.isFor(ip, port);
    }

    protected void sendAcknowledgement(InetSocketAddress addr, byte[] guid) {
        PingReply reply;
        ConnectionManager manager = RouterService.getConnectionManager();
        Endpoint host = manager.getConnectedGUESSUltrapeer();
        if (host != null) {
            try {
                reply = PingReply.createGUESSReply(guid, (byte)1, host);
            }
            catch (UnknownHostException e) {
                reply = this.createPingReply(guid);
            }
        } else {
            reply = this.createPingReply(guid);
        }
        if (reply == null) {
            return;
        }
        UDPService.instance().send(reply, addr.getAddress(), addr.getPort());
        SentMessageStatHandler.UDP_PING_REPLIES.addMessage(reply);
    }

    private PingReply createPingReply(byte[] guid) {
        GUESSEndpoint endpoint = this.UNICASTER.getUnicastEndpoint();
        if (endpoint == null) {
            if (RouterService.isIpPortValid()) {
                return PingReply.create(guid, (byte)1);
            }
            return null;
        }
        return PingReply.createGUESSReply(guid, (byte)1, endpoint.getPort(), endpoint.getAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handlePingRequest(request, handler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler, InetSocketAddress addr) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handleUDPPingRequest(request, handler, addr);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest request, ManagedConnection receivingConnection) {
        boolean isProbeQuery = request.getTTL() == 0 && (request.getHops() == 1 || request.getHops() == 2);
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), receivingConnection);
        if (counter != null) {
            if (isProbeQuery) {
                this._queryRouteTable.setTTL(counter, (byte)1);
            }
            this.handleQueryRequest(request, receivingConnection, counter, true);
        } else if (counter == null && !isProbeQuery) {
            if (this.wasProbeQuery(request)) {
                this.handleQueryRequest(request, receivingConnection, counter, false);
            } else {
                this.tallyDupQuery(request);
            }
        } else if (counter == null && isProbeQuery) {
            this.tallyDupQuery(request);
        } else {
            this.tallyDupQuery(request);
        }
    }

    private boolean wasProbeQuery(QueryRequest request) {
        return request.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(request.getGUID(), (byte)1, (byte)(request.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest request) {
        ReceivedMessageStatHandler.TCP_DUPLICATE_QUERIES.addMessage(request);
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest request, ReplyHandler handler) {
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), handler);
        if (counter != null) {
            this.handleQueryRequest(request, handler, counter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest ping, ReplyHandler handler) {
        if (ping.isHeartbeat() || handler.allowNewPings()) {
            this.respondToPingRequest(ping, handler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler handler, InetSocketAddress addr) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, addr);
        } else {
            this.respondToUDPPingRequest(pingRequest, addr, handler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pr, InetSocketAddress addr) {
        long now = System.currentTimeMillis();
        if (now - this._lastQueryKeyTime < (long)SearchSettings.QUERY_KEY_DELAY.getValue()) {
            return;
        }
        this._lastQueryKeyTime = now;
        InetAddress address = addr.getAddress();
        int port = addr.getPort();
        QueryKey key = QueryKey.getQueryKey(address, port);
        PingReply reply = PingReply.createQueryKeyReply(pr.getGUID(), (byte)1, key);
        UDPService.instance().send(reply, addr.getAddress(), addr.getPort());
    }

    protected void handleUDPPingReply(PingReply reply, ReplyHandler handler, InetAddress address, int port) {
        if (reply.getQueryKey() != null) {
            OnDemandUnicaster.handleQueryKeyPong(reply);
            return;
        }
        if (reply.getPort() != port || !reply.getInetAddress().equals(address)) {
            this.UNICASTER.addUnicastEndpoint(address, port);
        }
        this.handlePingReply(reply, handler);
    }

    protected void handleQueryRequest(QueryRequest request, ReplyHandler handler, ResultCounter counter, boolean locallyEvaluate) {
        if (!handler.isPersonalSpam(request)) {
            this._callback.handleQueryString(request.getQuery());
        }
        this.updateMessage(request, handler);
        if (handler.isSupernodeClientConnection() && counter != null) {
            if (request.desiresOutOfBandReplies()) {
                String remoteAddr = handler.getInetAddress().getHostAddress();
                String myAddress = NetworkUtils.ip2string(RouterService.getAddress());
                if (!(request.getReplyAddress().equals(remoteAddr) || request.getReplyAddress().equals(myAddress) && RouterService.isOOBCapable())) {
                    return;
                }
            }
            locallyEvaluate = false;
            this.respondToQueryRequest(request, this._clientGUID, handler);
            this.multicastQueryRequest(request);
            if (handler.isGoodLeaf()) {
                this.sendDynamicQuery(QueryHandler.createHandlerForNewLeaf(request, handler, counter), handler);
            } else {
                this.sendDynamicQuery(QueryHandler.createHandlerForOldLeaf(request, handler, counter), handler);
            }
        } else if (request.getTTL() > 0 && RouterService.isSupernode()) {
            if (handler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(request, handler);
            } else {
                this.forwardLimitedQueryToUltrapeers(request, handler);
            }
        }
        if (locallyEvaluate) {
            this.forwardQueryRequestToLeaves(request, handler);
            if (!(!request.isFirewalledSource() || RouterService.acceptedIncomingConnection() || request.canDoFirewalledTransfer() && UDPService.instance().canDoFWT())) {
                return;
            }
            this.respondToQueryRequest(request, this._clientGUID, handler);
        }
    }

    protected void handleLimeACKMessage(LimeACKVendorMessage ack, InetSocketAddress addr) {
        GUID.TimedGUID refGUID = new GUID.TimedGUID(new GUID(ack.getGUID()), 25000L);
        QueryResponseBundle bundle = (QueryResponseBundle)this._outOfBandReplies.remove(refGUID);
        if (bundle != null && ack.getNumResults() > 0) {
            InetAddress iaddr = addr.getAddress();
            int port = addr.getPort();
            Iterator iterator = null;
            if (ack.getNumResults() < bundle._responses.length) {
                Response[] desired = new Response[ack.getNumResults()];
                for (int i = 0; i < desired.length; ++i) {
                    desired[i] = bundle._responses[i];
                }
                iterator = this.responsesToQueryReplies(desired, bundle._query, 1);
            } else {
                iterator = this.responsesToQueryReplies(bundle._responses, bundle._query, 1);
            }
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                UDPService.instance().send(queryReply, iaddr, port);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReplyNumberMessage(ReplyNumberVendorMessage reply, InetSocketAddress addr) {
        GUID qGUID = new GUID(reply.getGUID());
        int numResults = RouterService.getSearchResultHandler().getNumResultsForQuery(qGUID);
        if (numResults < 0) {
            numResults = this.DYNAMIC_QUERIER.getLeafResultsForQuery(qGUID);
        }
        if (numResults < 0 || numResults > 150) {
            OutOfBandThroughputStat.RESPONSES_BYPASSED.addData(reply.getNumResults());
            if (!reply.canReceiveUnsolicited()) {
                return;
            }
            DownloadManager dManager = RouterService.getDownloadManager();
            if (!this._callback.isQueryAlive(qGUID) && !dManager.isGuidForQueryDownloading(qGUID)) {
                return;
            }
            GUESSEndpoint ep = new GUESSEndpoint(addr.getAddress(), addr.getPort());
            Map map = this._bypassedResults;
            synchronized (map) {
                HashSet<GUESSEndpoint> eps = (HashSet<GUESSEndpoint>)this._bypassedResults.get(qGUID);
                if (eps == null) {
                    eps = new HashSet<GUESSEndpoint>();
                    this._bypassedResults.put(qGUID, eps);
                }
                if (this._bypassedResults.size() <= 150) {
                    eps.add(ep);
                }
            }
            return;
        }
        LimeACKVendorMessage ack = new LimeACKVendorMessage(qGUID, reply.getNumResults());
        UDPService.instance().send(ack, addr.getAddress(), addr.getPort());
        OutOfBandThroughputStat.RESPONSES_REQUESTED.addData(reply.getNumResults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bufferResponsesForLaterDelivery(QueryRequest query, Response[] resps) {
        Map map = this._outOfBandReplies;
        synchronized (map) {
            if (this._outOfBandReplies.size() < MAX_BUFFERED_REPLIES) {
                GUID.TimedGUID tGUID = new GUID.TimedGUID(new GUID(query.getGUID()), 25000L);
                this._outOfBandReplies.put(tGUID, new QueryResponseBundle(query, resps));
                return true;
            }
            return false;
        }
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage udp, Connection source) {
        GUID guidToUse = udp.getConnectBackGUID();
        int portToContact = udp.getConnectBackPort();
        InetAddress sourceAddr = source.getInetAddress();
        UDPConnectBackRedirect msg = new UDPConnectBackRedirect(guidToUse, sourceAddr, portToContact);
        int sentTo = 0;
        ArrayList peers = new ArrayList(_manager.getInitializedConnections());
        Collections.shuffle(peers);
        Iterator i = peers.iterator();
        while (i.hasNext() && sentTo < 5) {
            ManagedConnection currMC = (ManagedConnection)i.next();
            if (currMC == source || currMC.remoteHostSupportsUDPRedirect() < 0) continue;
            currMC.send(msg);
            ++sentTo;
        }
    }

    protected void handleUDPConnectBackRedirect(UDPConnectBackRedirect udp, Connection source) {
        if (!source.isSupernodeSupernodeConnection()) {
            return;
        }
        GUID guidToUse = udp.getConnectBackGUID();
        int portToContact = udp.getConnectBackPort();
        InetAddress addrToContact = udp.getConnectBackAddress();
        Endpoint endPoint = new Endpoint(addrToContact.getAddress(), portToContact);
        if (_manager.isConnectedTo(endPoint.getAddress())) {
            return;
        }
        String addrString = addrToContact.getHostAddress();
        if (!this.shouldServiceRedirect(_udpConnectBacks, addrString)) {
            return;
        }
        PingRequest pr = new PingRequest(guidToUse.bytes(), 1, 0);
        UDPService.instance().send(pr, addrToContact, portToContact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldServiceRedirect(FixedsizeHashMap map, Object key) {
        FixedsizeHashMap fixedsizeHashMap = map;
        synchronized (fixedsizeHashMap) {
            Object placeHolder = map.get(key);
            if (placeHolder == null) {
                try {
                    map.put(key, map);
                    return true;
                }
                catch (NoMoreStorageException nomo) {
                    return false;
                }
            }
            return false;
        }
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tcp, Connection source) {
        int portToContact = tcp.getConnectBackPort();
        InetAddress sourceAddr = source.getInetAddress();
        TCPConnectBackRedirect msg = new TCPConnectBackRedirect(sourceAddr, portToContact);
        int sentTo = 0;
        ArrayList peers = new ArrayList(_manager.getInitializedConnections());
        Collections.shuffle(peers);
        Iterator i = peers.iterator();
        while (i.hasNext() && sentTo < 5) {
            ManagedConnection currMC = (ManagedConnection)i.next();
            if (currMC == source || currMC.remoteHostSupportsTCPRedirect() < 0) continue;
            currMC.send(msg);
            ++sentTo;
        }
    }

    protected void handleTCPConnectBackRedirect(TCPConnectBackRedirect tcp, Connection source) {
        if (!source.isSupernodeSupernodeConnection()) {
            return;
        }
        final int portToContact = tcp.getConnectBackPort();
        final String addrToContact = tcp.getConnectBackAddress().getHostAddress();
        Endpoint endPoint = new Endpoint(addrToContact, portToContact);
        if (_manager.isConnectedTo(endPoint.getAddress())) {
            return;
        }
        if (!this.shouldServiceRedirect(_tcpConnectBacks, addrToContact)) {
            return;
        }
        TCP_CONNECT_BACKER.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Socket sock = null;
                try {
                    sock = Sockets.connect(addrToContact, portToContact, 12000);
                    OutputStream os = sock.getOutputStream();
                    os.write("CONNECT BACK\r\n\r\n".getBytes());
                    os.flush();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Succesful connectback to: " + addrToContact);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ignored) {
                        LOG.warn("Interrupted connectback", ignored);
                    }
                }
                catch (IOException ignored) {
                    try {
                        LOG.warn("IOX during connectback", ignored);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(sock);
                        throw throwable;
                    }
                    IOUtils.close(sock);
                }
                IOUtils.close(sock);
            }
        });
    }

    protected void handlePushProxyRequest(PushProxyRequest ppReq, ManagedConnection source) {
        if (source.isSupernodeClientConnection() && RouterService.isIpPortValid()) {
            String stringAddr = NetworkUtils.ip2string(RouterService.getAddress());
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(stringAddr);
            }
            catch (UnknownHostException uhe) {
                ErrorService.error(uhe);
            }
            PushProxyAcknowledgement ack = new PushProxyAcknowledgement(addr, RouterService.getPort(), ppReq.getClientGUID());
            source.send(ack);
            this._pushRouteTable.routeReply(ppReq.getClientGUID().bytes(), source);
        }
    }

    protected void handleQueryStatus(QueryStatusResponse resp, ManagedConnection leaf) {
        if (!leaf.isSupernodeClientConnection()) {
            return;
        }
        GUID queryGUID = resp.getQueryGUID();
        int numResults = resp.getNumResults();
        this.DYNAMIC_QUERIER.updateLeafResultsForQuery(queryGUID, numResults);
    }

    public void sendPingRequest(PingRequest request, ManagedConnection connection) {
        if (request == null) {
            throw new NullPointerException("null ping");
        }
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        this._pingRouteTable.routeReply(request.getGUID(), this.FOR_ME_REPLY_HANDLER);
        connection.send(request);
    }

    public void sendQueryRequest(QueryRequest request, ManagedConnection connection) {
        if (request == null) {
            throw new NullPointerException("null query");
        }
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        this._queryRouteTable.routeReply(request.getGUID(), this.FOR_ME_REPLY_HANDLER);
        connection.send(request);
    }

    public void broadcastPingRequest(PingRequest ping) {
        if (ping == null) {
            throw new NullPointerException("null ping");
        }
        this._pingRouteTable.routeReply(ping.getGUID(), this.FOR_ME_REPLY_HANDLER);
        this.broadcastPingRequest(ping, this.FOR_ME_REPLY_HANDLER, _manager);
    }

    public void sendDynamicQuery(QueryRequest query) {
        if (query == null) {
            throw new NullPointerException("null QueryHandler");
        }
        ResultCounter counter = this._queryRouteTable.routeReply(query.getGUID(), this.FOR_ME_REPLY_HANDLER);
        if (RouterService.isSupernode()) {
            this.sendDynamicQuery(QueryHandler.createHandlerForMe(query, counter), this.FOR_ME_REPLY_HANDLER);
        } else {
            this.originateLeafQuery(query);
        }
        byte[] newGUID = GUID.makeGuid();
        QueryRequest mquery = QueryRequest.createMulticastQuery(newGUID, query);
        this._multicastGuidMap.addMapping(query.getGUID(), newGUID, 60000L);
        this.multicastQueryRequest(mquery);
    }

    private void sendDynamicQuery(QueryHandler qh, ReplyHandler handler) {
        if (qh == null) {
            throw new NullPointerException("null QueryHandler");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        this.DYNAMIC_QUERIER.addQuery(qh);
    }

    private void broadcastPingRequest(PingRequest request, ReplyHandler receivingConnection, ConnectionManager manager) {
        List list = manager.getInitializedConnections();
        int size = list.size();
        boolean randomlyForward = false;
        if (size > 3) {
            randomlyForward = true;
        }
        for (int i = 0; i < size; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (!mc.isStable() || receivingConnection != this.FOR_ME_REPLY_HANDLER && (mc == receivingConnection || mc.isClientSupernodeConnection())) continue;
            double percentToIgnore = mc.supportsPongCaching() ? 0.7 : 0.9;
            if (randomlyForward && Math.random() < percentToIgnore) continue;
            mc.send(request);
        }
    }

    public final void forwardQueryRequestToLeaves(QueryRequest query, ReplyHandler handler) {
        if (!RouterService.isSupernode()) {
            return;
        }
        List list = _manager.getInitializedClientConnections();
        List<ManagedConnection> hitConnections = new ArrayList<ManagedConnection>();
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (mc == handler || !mc.shouldForwardQuery(query)) continue;
            hitConnections.add(mc);
        }
        if (list.size() > 8 && (double)hitConnections.size() / (double)list.size() > 0.8) {
            int startIndex = (int)Math.floor(Math.random() * (double)hitConnections.size() * 0.75);
            hitConnections = hitConnections.subList(startIndex, startIndex + hitConnections.size() / 4);
        }
        int notSent = list.size() - hitConnections.size();
        RoutedQueryStat.LEAF_DROP.addData(notSent);
        for (int i = 0; i < hitConnections.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)hitConnections.get(i);
            mc.send(query);
            RoutedQueryStat.LEAF_SEND.incrementStat();
        }
    }

    private boolean sendRoutedQueryToHost(QueryRequest query, ManagedConnection mc, ReplyHandler handler) {
        if (mc.shouldForwardQuery(query)) {
            mc.send(query);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest query, ReplyHandler conn) {
        query.setTTL((byte)1);
        this.UNICASTER.addQuery(query, conn);
    }

    protected void multicastQueryRequest(QueryRequest query) {
        query.setTTL((byte)1);
        SentMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(query);
        MulticastService.instance().send(query);
    }

    private void forwardQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List list = _manager.getInitializedConnections();
        int limit = list.size();
        for (int i = 0; i < limit; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            this.forwardQueryToUltrapeer(query, handler, mc);
        }
    }

    private void forwardLimitedQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List list = _manager.getInitializedConnections();
        int limit = list.size();
        int connectionsNeededForOld = 15;
        for (int i = 0; i < limit && connectionsNeededForOld != 0; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (mc.isGoodUltrapeer() && limit - i > connectionsNeededForOld) continue;
            this.forwardQueryToUltrapeer(query, handler, mc);
            --connectionsNeededForOld;
        }
    }

    private void forwardQueryToUltrapeer(QueryRequest query, ReplyHandler handler, ManagedConnection ultrapeer) {
        boolean lastHop;
        if (ultrapeer == handler) {
            return;
        }
        if (ultrapeer.isClientSupernodeConnection()) {
            return;
        }
        if (query.isFeatureQuery() && !ultrapeer.getRemoteHostSupportsFeatureQueries()) {
            return;
        }
        boolean bl = lastHop = query.getTTL() == 1;
        if (lastHop && ultrapeer.isUltrapeerQueryRoutingConnection()) {
            boolean sent = this.sendRoutedQueryToHost(query, ultrapeer, handler);
            if (sent) {
                RoutedQueryStat.ULTRAPEER_SEND.incrementStat();
            } else {
                RoutedQueryStat.ULTRAPEER_DROP.incrementStat();
            }
        } else {
            ultrapeer.send(query);
        }
    }

    private void originateLeafQuery(QueryRequest qr) {
        List list = _manager.getInitializedConnections();
        int max = qr.isWhatIsNewRequest() ? 2 : 3;
        int start = !qr.isWhatIsNewRequest() ? 0 : (int)Math.floor(Math.random() * (double)(list.size() - 1));
        int limit = Math.min(max, list.size());
        boolean wantsOOB = qr.desiresOutOfBandReplies();
        for (int i = start; i < start + limit; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            QueryRequest qrToSend = qr;
            if (wantsOOB && mc.remoteHostSupportsLeafGuidance() < 0) {
                qrToSend = QueryRequest.unmarkOOBQuery(qr);
            }
            mc.send(qrToSend);
        }
    }

    public boolean originateQuery(QueryRequest query, ManagedConnection mc) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (mc == null) {
            throw new NullPointerException("null connection");
        }
        if (query.isFeatureQuery() && !mc.getRemoteHostSupportsFeatureQueries()) {
            return false;
        }
        mc.originateQuery(query);
        return true;
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, InetSocketAddress var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2, ReplyHandler var3);

    protected void handlePingReply(PingReply reply, ReplyHandler handler) {
        ReplyHandler replyHandler;
        boolean newAddress = RouterService.getHostCatcher().add(reply);
        if (newAddress && !reply.isUDPHostCache()) {
            PongCacher.instance().addPong(reply);
        }
        if ((replyHandler = this._pingRouteTable.getReplyHandler(reply.getGUID())) != null) {
            replyHandler.handlePingReply(reply, handler);
        } else {
            RouteErrorStat.PING_REPLY_ROUTE_ERRORS.incrementStat();
            handler.countDroppedMessage();
        }
        boolean supportsUnicast = reply.supportsUnicast();
        if (newAddress && (reply.isUltrapeer() || supportsUnicast)) {
            List list = _manager.getInitializedClientConnections();
            for (int i = 0; i < list.size(); ++i) {
                ManagedConnection c = (ManagedConnection)list.get(i);
                Assert.that(c != null, "null c.");
                if (c == handler || c == replyHandler || !c.allowNewPongs()) continue;
                c.handlePingReply(reply, handler);
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler handler) {
        if (queryReply == null) {
            throw new NullPointerException("null query reply");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getUniqueResultCount());
        if (rrp != null) {
            queryReply.setPriority(rrp.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), handler);
            ReplyHandler rh = rrp.getReplyHandler();
            if (!this.shouldDropReply(rrp, rh, queryReply)) {
                rh.handleQueryReply(queryReply, handler);
                this.UNICASTER.handleQueryReply(queryReply);
            } else {
                RouteErrorStat.HARD_LIMIT_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
                byte ttl = queryReply.getTTL();
                if (ttl < RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length) {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[ttl].incrementStat();
                } else {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length - 1].incrementStat();
                }
                handler.countDroppedMessage();
            }
        } else {
            RouteErrorStat.NO_ROUTE_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
            handler.countDroppedMessage();
        }
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair rrp, ReplyHandler rh, QueryReply qr) {
        byte ttl = qr.getTTL();
        if (rh == this.FOR_ME_REPLY_HANDLER) {
            return false;
        }
        if (ttl == 0) {
            return true;
        }
        int resultsRouted = rrp.getResultsRouted();
        if (resultsRouted > 100) {
            return true;
        }
        int bytesRouted = rrp.getBytesRouted();
        if (ttl > 2 && bytesRouted < 51200) {
            return false;
        }
        if (ttl == 1 && bytesRouted < 204800) {
            return false;
        }
        return ttl != 2 || bytesRouted >= 102400;
    }

    private void handleGiveStats(GiveStatsVendorMessage gsm, ReplyHandler replyHandler) {
        StatisticVendorMessage statVM = null;
        try {
            if (StatisticVendorMessage.isSupported(gsm)) {
                statVM = new StatisticVendorMessage(gsm);
                replyHandler.handleStatisticVM(statVM);
            }
        }
        catch (IOException iox) {
            return;
        }
    }

    private void handleStatisticsMessage(StatisticVendorMessage svm, ReplyHandler handler) {
    }

    private void handleSimppRequest(SimppRequestVM simppReq, ReplyHandler handler) {
        if (simppReq.getVersion() > 1) {
            return;
        }
        byte[] simppBytes = SimppManager.instance().getSimppBytes();
        if (simppBytes != null) {
            SimppVM simppVM = new SimppVM(simppBytes);
            try {
                handler.handleSimppVM(simppVM);
            }
            catch (IOException iox) {
                return;
            }
        }
    }

    private void handleSimppVM(SimppVM simppVM) {
        SimppManager.instance().checkAndUpdate(simppVM.getPayload());
    }

    private void handleUpdateRequest(UpdateRequest req, ReplyHandler handler) {
        byte[] data = UpdateHandler.instance().getLatestBytes();
        if (data != null) {
            UpdateResponse msg = UpdateResponse.createUpdateResponse(data, req);
            handler.reply(msg);
        }
    }

    private void handleContentResponse(ContentResponse msg, ReplyHandler handler) {
        RouterService.getContentManager().handleContentResponse(msg);
    }

    private void handleUpdateResponse(UpdateResponse resp, ReplyHandler handler) {
        UpdateHandler.instance().handleNewData(resp.getUpdate());
    }

    protected void handlePushRequest(PushRequest request, ReplyHandler handler) {
        if (request == null) {
            throw new NullPointerException("null request");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        ReplyHandler replyHandler = this.getPushHandler(request.getClientGUID());
        if (replyHandler != null) {
            replyHandler.handlePushRequest(request, handler);
        } else {
            RouteErrorStat.PUSH_REQUEST_ROUTE_ERRORS.incrementStat();
            handler.countDroppedMessage();
        }
    }

    protected ReplyHandler getPushHandler(byte[] guid) {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(guid);
        if (replyHandler != null) {
            return replyHandler;
        }
        if (Arrays.equals(this._clientGUID, guid)) {
            return this.FOR_ME_REPLY_HANDLER;
        }
        return null;
    }

    protected void sendPingReply(PingReply pong, ReplyHandler handler) {
        if (pong == null) {
            throw new NullPointerException("null pong");
        }
        if (handler == null) {
            throw new NullPointerException("null reply handler");
        }
        handler.handlePingReply(pong, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        if (queryReply == null) {
            throw new NullPointerException("null reply");
        }
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (rrp == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(rrp.getBytesRouted());
        rrp.getReplyHandler().handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest push) throws IOException {
        if (push == null) {
            throw new NullPointerException("null push");
        }
        ReplyHandler replyHandler = this.getPushHandler(push.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(push, this.FOR_ME_REPLY_HANDLER);
    }

    protected void sendMulticastPushRequest(PushRequest push) {
        if (push == null) {
            throw new NullPointerException("null push");
        }
        Assert.that(push.getTTL() == 1, "multicast push ttl not 1");
        MulticastService.instance().send(push);
        SentMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(push);
    }

    public Iterator responsesToQueryReplies(Response[] responses, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responses, queryRequest, 10);
    }

    private Iterator responsesToQueryReplies(Response[] responses, QueryRequest queryRequest, int REPLY_LIMIT) {
        int i;
        LinkedList queryReplies = new LinkedList();
        byte[] guid = queryRequest.getGUID();
        byte ttl = (byte)(queryRequest.getHops() + 1);
        UploadManager um = RouterService.getUploadManager();
        long speed = um.measuredUploadSpeed();
        boolean measuredSpeed = true;
        if (speed == -1L) {
            speed = ConnectionSettings.CONNECTION_SPEED.getValue();
            measuredSpeed = false;
        }
        int numResponses = responses.length;
        int index = 0;
        byte numHops = queryRequest.getHops();
        if (REPLY_LIMIT > 1 && numHops > 2 && numResponses > 10) {
            int j = (int)(Math.random() * (double)numResponses) % (numResponses - 10);
            Response[] newResponses = new Response[10];
            i = 0;
            while (i < 10) {
                newResponses[i] = responses[j];
                ++i;
                ++j;
            }
            responses = newResponses;
            numResponses = responses.length;
        }
        while (numResponses > 0) {
            boolean fwTransfer;
            Response[] res;
            int arraySize = numResponses < REPLY_LIMIT ? numResponses : REPLY_LIMIT;
            if (index == 0 && arraySize < REPLY_LIMIT) {
                res = responses;
            } else {
                res = new Response[arraySize];
                for (i = 0; i < arraySize; ++i) {
                    res[i] = responses[index];
                    ++index;
                }
            }
            numResponses -= arraySize;
            boolean busy = !um.isServiceable();
            boolean uploaded = um.hadSuccesfulUpload();
            boolean mcast = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
            boolean bl = fwTransfer = queryRequest.canDoFirewalledTransfer() && UDPService.instance().canDoFWT() && !RouterService.acceptedIncomingConnection();
            if (mcast) {
                ttl = 1;
            }
            List replies = this.createQueryReply(guid, ttl, speed, res, this._clientGUID, busy, uploaded, measuredSpeed, mcast, fwTransfer);
            queryReplies.addAll(replies);
        }
        return queryReplies.iterator();
    }

    protected abstract List createQueryReply(byte[] var1, byte var2, long var3, Response[] var5, byte[] var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage rtm, ManagedConnection mc) {
        if (!MessageRouter.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.resetQueryRouteTable(rtm);
        }
        if (mc.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage ptm, ManagedConnection mc) {
        if (!MessageRouter.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.patchQueryRouteTable(ptm);
        }
        if (mc.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    private void updateMessage(QueryRequest request, ReplyHandler handler) {
        if (!(handler instanceof Connection)) {
            return;
        }
        Connection c = (Connection)((Object)handler);
        QueryReply update = StaticMessages.getUpdateReply();
        if (request.getHops() == 1 && c.isOldLimeWire() && update != null) {
            QueryReply qr = new QueryReply(request.getGUID(), update);
            try {
                this.sendQueryReply(qr);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    private static boolean isQRPConnection(Connection c) {
        if (c.isSupernodeClientConnection()) {
            return true;
        }
        return c.isUltrapeerQueryRoutingConnection();
    }

    private void forwardQueryRouteTables() {
        long time = System.currentTimeMillis();
        List list = _manager.getInitializedConnections();
        QueryRouteTable table = null;
        List patches = null;
        QueryRouteTable lastSent = null;
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection c = (ManagedConnection)list.get(i);
            if (!RouterService.isSupernode() ? !c.isClientSupernodeConnection() || !c.isQueryRoutingEnabled() : !c.isUltrapeerQueryRoutingConnection()) continue;
            if (time < c.getNextQRPForwardTime()) continue;
            c.incrementNextQRPForwardTime(time);
            if (table == null) {
                this._lastQueryRouteTable = table = MessageRouter.createRouteTable();
            }
            if (lastSent == c.getQueryRouteTableSent()) {
                if (patches == null) {
                    patches = table.encode(lastSent, true);
                }
            } else {
                lastSent = c.getQueryRouteTableSent();
                patches = table.encode(lastSent, true);
            }
            if (!ConnectionSettings.SEND_QRP.getValue()) {
                return;
            }
            Iterator iter = patches.iterator();
            while (iter.hasNext()) {
                c.send((RouteTableMessage)iter.next());
            }
            c.setQueryRouteTableSent(table);
        }
    }

    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    private static QueryRouteTable createRouteTable() {
        QueryRouteTable ret = _fileManager.getQRT();
        if (RouterService.isSupernode()) {
            MessageRouter.addQueryRoutingEntriesForLeaves(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addQueryRoutingEntriesForLeaves(QueryRouteTable qrt) {
        List leaves = _manager.getInitializedClientConnections();
        for (int i = 0; i < leaves.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)leaves.get(i);
            Object object = mc.getQRPLock();
            synchronized (object) {
                QueryRouteTable qrtr;
                if (!mc.isBusyLeaf() && (qrtr = mc.getQueryRouteTableReceived()) != null) {
                    qrt.addAll(qrtr);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageListener(byte[] guid, MessageListener ml) {
        ml.registered(guid);
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            TreeMap listeners = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
            listeners.putAll(this._messageListeners);
            ArrayList<MessageListener> all = (ArrayList<MessageListener>)listeners.get(guid);
            if (all == null) {
                all = new ArrayList<MessageListener>(1);
                all.add(ml);
            } else {
                ArrayList<MessageListener> temp = new ArrayList<MessageListener>(all.size() + 1);
                temp.addAll(all);
                all = temp;
                all.add(ml);
            }
            listeners.put(guid, Collections.unmodifiableList(all));
            this._messageListeners = Collections.unmodifiableMap(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMessageListener(byte[] guid, MessageListener ml) {
        boolean removed = false;
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            ArrayList all = (ArrayList)this._messageListeners.get(guid);
            if (all != null && (all = new ArrayList(all)).remove(ml)) {
                removed = true;
                TreeMap listeners = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
                listeners.putAll(this._messageListeners);
                if (all.isEmpty()) {
                    listeners.remove(guid);
                } else {
                    listeners.put(guid, Collections.unmodifiableList(all));
                }
                this._messageListeners = Collections.unmodifiableMap(listeners);
            }
        }
        if (removed) {
            ml.unregistered(guid);
        }
    }

    private void handleUDPCrawlerPing(UDPCrawlerPing msg, ReplyHandler handler) {
        if (!this._promotionManager.allowUDPPing(handler)) {
            return;
        }
        UDPCrawlerPong newMsg = new UDPCrawlerPong(msg);
        handler.reply(newMsg);
    }

    private void handleHeadPing(HeadPing ping, ReplyHandler handler) {
        if (DownloadSettings.DROP_HEADPINGS.getValue()) {
            return;
        }
        GUID clientGUID = ping.getClientGuid();
        ReplyHandler pingee = clientGUID != null ? this.getPushHandler(clientGUID.bytes()) : this.FOR_ME_REPLY_HANDLER;
        if (pingee == null) {
            return;
        }
        if (pingee instanceof ForMeReplyHandler) {
            HeadPong pong = new HeadPong(ping);
            handler.reply(pong);
        } else {
            this._headPongRouteTable.routeReply(ping.getGUID(), handler);
            if (!(handler instanceof Connection) || ((Connection)((Object)handler)).supportsVMRouting()) {
                pingee.reply(ping);
            } else {
                pingee.reply(new HeadPing(ping));
            }
        }
    }

    private void handleHeadPong(HeadPong pong, ReplyHandler handler) {
        ReplyHandler forwardTo = this._headPongRouteTable.getReplyHandler(pong.getGUID());
        if (forwardTo != null && !(forwardTo instanceof ForMeReplyHandler)) {
            forwardTo.reply(pong);
            this._headPongRouteTable.removeReplyHandler(forwardTo);
        }
    }

    static {
        MAX_BUFFERED_REPLIES = 250;
        _udpConnectBacks = new FixedsizeHashMap(200);
        _tcpConnectBacks = new FixedsizeHashMap(200);
        TCP_CONNECT_BACKER = new ProcessingQueue("TCPConnectBack");
    }

    public class MulticastPushRequestHandler
    implements MessageHandler {
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(msg);
            MessageRouter.this.handlePushRequest((PushRequest)msg, handler);
        }
    }

    public class MulticastPingReplyHandler
    implements MessageHandler {
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(msg);
            MessageRouter.this.handleUDPPingReply((PingReply)msg, handler, addr.getAddress(), addr.getPort());
        }
    }

    public class MulticastPingRequestHandler
    implements MessageHandler {
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.MULTICAST_PING_REQUESTS.addMessage(msg);
            MessageRouter.this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, addr);
        }
    }

    public class MulticastQueryReplyHandler
    implements MessageHandler {
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(msg);
            MessageRouter.this.handleQueryReply((QueryReply)msg, handler);
        }
    }

    public class MulticastQueryRequestHandler
    implements MessageHandler {
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            if (!MessageRouter.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler)) {
                ReceivedMessageStatHandler.MULTICAST_DUPLICATE_QUERIES.addMessage(msg);
            }
            ReceivedMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(msg);
        }
    }

    private class UDPContentResponseHandler
    implements MessageHandler {
        private UDPContentResponseHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleContentResponse((ContentResponse)msg, handler);
        }
    }

    private class UDPUpdateRequestHandler
    implements MessageHandler {
        private UDPUpdateRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleUpdateRequest((UpdateRequest)msg, handler);
        }
    }

    private class UDPHeadPingHandler
    implements MessageHandler {
        private UDPHeadPingHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleHeadPing((HeadPing)msg, handler);
        }
    }

    private class UDPUDPCrawlerPingHandler
    implements MessageHandler {
        private UDPUDPCrawlerPingHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleUDPCrawlerPing((UDPCrawlerPing)msg, handler);
        }
    }

    private class UDPStatisticsMessageHandler
    implements MessageHandler {
        private UDPStatisticsMessageHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleStatisticsMessage((StatisticVendorMessage)msg, handler);
        }
    }

    private class UDPGiveStatsHandler
    implements MessageHandler {
        private UDPGiveStatsHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleGiveStats((GiveStatsVendorMessage)msg, handler);
        }
    }

    private class UDPReplyNumberMessageHandler
    implements MessageHandler {
        private UDPReplyNumberMessageHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleReplyNumberMessage((ReplyNumberVendorMessage)msg, addr);
        }
    }

    private class UDPLimeACKVendorMessageHandler
    implements MessageHandler {
        private UDPLimeACKVendorMessageHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.UDP_LIME_ACK.addMessage(msg);
            MessageRouter.this.handleLimeACKMessage((LimeACKVendorMessage)msg, addr);
        }
    }

    private class UDPPushRequestHandler
    implements MessageHandler {
        private UDPPushRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(msg);
            MessageRouter.this.handlePushRequest((PushRequest)msg, handler);
        }
    }

    private class UDPPingReplyHandler
    implements MessageHandler {
        private UDPPingReplyHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(msg);
            MessageRouter.this.handleUDPPingReply((PingReply)msg, handler, addr.getAddress(), addr.getPort());
        }
    }

    private class UDPPingRequestHandler
    implements MessageHandler {
        private UDPPingRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.UDP_PING_REQUESTS.addMessage(msg);
            MessageRouter.this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, addr);
        }
    }

    private class UDPQueryReplyHandler
    implements MessageHandler {
        private UDPQueryReplyHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            QueryReply qr = (QueryReply)msg;
            ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(msg);
            short numResps = qr.getResultCount();
            if (!qr.isReplyToMulticastQuery()) {
                OutOfBandThroughputStat.RESPONSES_RECEIVED.addData(numResps);
            }
            MessageRouter.this.handleQueryReply(qr, handler);
        }
    }

    private class UDPQueryRequestHandler
    implements MessageHandler {
        private UDPQueryRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            int port;
            InetAddress address = addr.getAddress();
            if (MessageRouter.this.hasValidQueryKey(address, port = addr.getPort(), (QueryRequest)msg)) {
                MessageRouter.this.sendAcknowledgement(addr, msg.getGUID());
                if (!MessageRouter.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler)) {
                    ReceivedMessageStatHandler.UDP_DUPLICATE_QUERIES.addMessage(msg);
                }
            }
            ReceivedMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(msg);
        }
    }

    public class VendorMessageHandler
    implements MessageHandler {
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ((ManagedConnection)handler).handleVendorMessage((VendorMessage)msg);
        }
    }

    private class HeadPongHandler
    implements MessageHandler {
        private HeadPongHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleHeadPong((HeadPong)msg, handler);
        }
    }

    private class UpdateResponseHandler
    implements MessageHandler {
        private UpdateResponseHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleUpdateResponse((UpdateResponse)msg, handler);
        }
    }

    private class UpdateRequestHandler
    implements MessageHandler {
        private UpdateRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleUpdateRequest((UpdateRequest)msg, handler);
        }
    }

    private class SimppVMHandler
    implements MessageHandler {
        private SimppVMHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleSimppVM((SimppVM)msg);
        }
    }

    private class SimppRequestVMHandler
    implements MessageHandler {
        private SimppRequestVMHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleSimppRequest((SimppRequestVM)msg, handler);
        }
    }

    private class HeadPingHandler
    implements MessageHandler {
        private HeadPingHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleHeadPing((HeadPing)msg, handler);
        }
    }

    private class StatisticsHandler
    implements MessageHandler {
        private StatisticsHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleStatisticsMessage((StatisticVendorMessage)msg, handler);
        }
    }

    private class GiveStatsHandler
    implements MessageHandler {
        private GiveStatsHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleGiveStats((GiveStatsVendorMessage)msg, handler);
        }
    }

    private class QueryStatusResponseHandler
    implements MessageHandler {
        private QueryStatusResponseHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleQueryStatus((QueryStatusResponse)msg, (ManagedConnection)handler);
        }
    }

    private class PushProxyRequestHandler
    implements MessageHandler {
        private PushProxyRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handlePushProxyRequest((PushProxyRequest)msg, (ManagedConnection)handler);
        }
    }

    private class UDPConnectBackRedirectHandler
    implements MessageHandler {
        private UDPConnectBackRedirectHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleUDPConnectBackRedirect((UDPConnectBackRedirect)msg, (ManagedConnection)handler);
        }
    }

    private class TCPConnectBackRedirectHandler
    implements MessageHandler {
        private TCPConnectBackRedirectHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouter.this.handleTCPConnectBackRedirect((TCPConnectBackRedirect)msg, (ManagedConnection)handler);
        }
    }

    private class UDPConnectBackHandler
    implements MessageHandler {
        private UDPConnectBackHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(msg);
            MessageRouter.this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)msg, (ManagedConnection)handler);
        }
    }

    private class TCPConnectBackHandler
    implements MessageHandler {
        private TCPConnectBackHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_TCP_CONNECTBACK.addMessage(msg);
            MessageRouter.this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)msg, (ManagedConnection)handler);
        }
    }

    private class PatchTableHandler
    implements MessageHandler {
        private PatchTableHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(msg);
            MessageRouter.this.handlePatchTableMessage((PatchTableMessage)msg, (ManagedConnection)handler);
        }
    }

    private class ResetTableHandler
    implements MessageHandler {
        private ResetTableHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(msg);
            MessageRouter.this.handleResetTableMessage((ResetTableMessage)msg, (ManagedConnection)handler);
        }
    }

    private class PushRequestHandler
    implements MessageHandler {
        private PushRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(msg);
            MessageRouter.this.handlePushRequest((PushRequest)msg, handler);
        }
    }

    private class QueryReplyHandler
    implements MessageHandler {
        private QueryReplyHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_QUERY_REPLIES.addMessage(msg);
            QueryReply qmsg = (QueryReply)msg;
            MessageRouter.this.handleQueryReply(qmsg, handler);
        }
    }

    private class QueryRequestHandler
    implements MessageHandler {
        private QueryRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(msg);
            MessageRouter.this.handleQueryRequestPossibleDuplicate((QueryRequest)msg, (ManagedConnection)handler);
        }
    }

    private class PingReplyHandler
    implements MessageHandler {
        private PingReplyHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_PING_REPLIES.addMessage(msg);
            MessageRouter.this.handlePingReply((PingReply)msg, handler);
        }
    }

    private class PingRequestHandler
    implements MessageHandler {
        private PingRequestHandler() {
        }

        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            ReceivedMessageStatHandler.TCP_PING_REQUESTS.addMessage(msg);
            MessageRouter.this.handlePingRequestPossibleDuplicate((PingRequest)msg, handler);
        }
    }

    public static interface MessageHandler {
        public void handleMessage(Message var1, InetSocketAddress var2, ReplyHandler var3);
    }

    static class HopsFlowManager
    implements Runnable {
        private static final byte BUSY_HOPS_FLOW = 0;
        private static final byte FREE_HOPS_FLOW = 5;
        private static boolean _oldBusyState = false;

        HopsFlowManager() {
        }

        public void run() {
            if (RouterService.isSupernode()) {
                return;
            }
            boolean isBusy = !RouterService.getUploadManager().isServiceable();
            List connections = _manager.getInitializedConnections();
            HopsFlowVendorMessage hops = new HopsFlowVendorMessage(isBusy ? (byte)0 : 5);
            if (isBusy == _oldBusyState) {
                for (int i = 0; i < connections.size(); ++i) {
                    ManagedConnection c = (ManagedConnection)connections.get(i);
                    if (c == null || !((double)c.getConnectionTime() + 18750.0 > (double)System.currentTimeMillis()) || !c.isClientSupernodeConnection()) continue;
                    c.send(hops);
                }
            } else {
                _oldBusyState = isBusy;
                for (int i = 0; i < connections.size(); ++i) {
                    ManagedConnection c = (ManagedConnection)connections.get(i);
                    if (c == null || !c.isClientSupernodeConnection()) continue;
                    c.send(hops);
                }
            }
        }
    }

    static class ConnectBackExpirer
    implements Runnable {
        ConnectBackExpirer() {
        }

        public void run() {
            try {
                _tcpConnectBacks.clear();
                _udpConnectBacks.clear();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet<GUID.TimedGUID> toRemove = new HashSet<GUID.TimedGUID>();
                Map map = MessageRouter.this._outOfBandReplies;
                synchronized (map) {
                    Iterator<Object> keys = MessageRouter.this._outOfBandReplies.keySet().iterator();
                    while (keys.hasNext()) {
                        GUID.TimedGUID currQB = (GUID.TimedGUID)keys.next();
                        if (currQB == null || !currQB.shouldExpire()) continue;
                        toRemove.add(currQB);
                    }
                    keys = toRemove.iterator();
                    while (keys.hasNext()) {
                        MessageRouter.this._outOfBandReplies.remove(keys.next());
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest query, Response[] responses) {
            this._query = query;
            this._responses = responses;
        }
    }

    private class QRPPropagator
    extends ManagedThread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        public void managedRun() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouter.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
                return;
            }
        }
    }
}

