/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.HUGEExtension;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Response {
    private static final Log LOG = LogFactory.getLog(Response.class);
    private static final byte EXT_SEPARATOR = 28;
    private static final int MAX_LOCATIONS = 10;
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private LimeXMLDocument document;
    private final Set urns;
    private final byte[] extBytes;
    private volatile RemoteFileDesc cachedRFD;
    private final GGEPContainer ggepData;
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";

    public Response(long index, long size, String name) {
        this(index, size, name, null, null, null, null);
    }

    public Response(long index, long size, String name, LimeXMLDocument doc) {
        this(index, size, name, null, doc, null, null);
    }

    public Response(FileDesc fd) {
        this(fd.getIndex(), fd.getFileSize(), fd.getFileName(), fd.getUrns(), null, new GGEPContainer(Response.getAsEndpoints(RouterService.getAltlocManager().getDirect(fd.getSHA1Urn())), CreationTimeCache.instance().getCreationTimeAsLong(fd.getSHA1Urn())), null);
    }

    private Response(long index, long size, String name, Set urns, LimeXMLDocument doc, GGEPContainer ggepData, byte[] extensions) {
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.index = index;
        this.size = size;
        this.name = name == null ? "" : name;
        byte[] temp = null;
        try {
            temp = this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException namex) {
            ErrorService.error(namex);
        }
        this.nameBytes = temp;
        this.urns = urns == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(urns);
        this.ggepData = ggepData == null ? GGEPContainer.EMPTY : ggepData;
        this.extBytes = extensions != null ? extensions : Response.createExtBytes(this.urns, this.ggepData);
        this.document = doc;
    }

    public static Response createFromStream(InputStream is) throws IOException {
        int c;
        long index = ByteOrder.uint2long(ByteOrder.leb2int(is));
        long size = ByteOrder.uint2long(ByteOrder.leb2int(is));
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IOException("invalid size: " + size);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        String name = new String(baos.toByteArray(), "UTF-8");
        if (name.length() == 0) {
            throw new IOException("empty name in response");
        }
        baos.reset();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        byte[] rawMeta = baos.toByteArray();
        if (rawMeta == null || rawMeta.length == 0) {
            if (is.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return new Response(index, size, name);
        }
        HUGEExtension huge = new HUGEExtension(rawMeta);
        Set urns = huge.getURNS();
        LimeXMLDocument doc = null;
        Iterator iter = huge.getMiscBlocks().iterator();
        while (iter.hasNext() && doc == null) {
            doc = Response.createXmlDocument(name, (String)iter.next());
        }
        GGEPContainer ggep = GGEPUtil.getGGEP(huge.getGGEP());
        return new Response(index, size, name, urns, doc, ggep, rawMeta);
    }

    private static LimeXMLDocument createXmlDocument(String name, String ext) {
        StringTokenizer tok = new StringTokenizer(ext);
        if (tok.countTokens() < 2) {
            return null;
        }
        String first = tok.nextToken();
        String second = tok.nextToken();
        if (first != null) {
            first = first.toLowerCase();
        }
        if (second != null) {
            second = second.toLowerCase();
        }
        String length = "";
        String bitrate = "";
        boolean bearShare1 = false;
        boolean bearShare2 = false;
        boolean gnotella = false;
        if (second.startsWith(KBPS)) {
            bearShare1 = true;
        } else if (first.endsWith(KBPS)) {
            bearShare2 = true;
        }
        if (bearShare1) {
            bitrate = first;
        } else if (bearShare2) {
            int j = first.indexOf(KBPS);
            bitrate = first.substring(0, j);
        }
        if (bearShare1 || bearShare2) {
            while (tok.hasMoreTokens()) {
                length = tok.nextToken();
            }
        } else if (ext.endsWith(KHZ)) {
            gnotella = true;
            length = first;
            int i = second.indexOf(KBPS);
            if (i > -1) {
                bitrate = second.substring(0, i);
            } else {
                gnotella = false;
            }
        }
        try {
            Integer.parseInt(bitrate);
            Integer.parseInt(length);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (bearShare1 || bearShare2 || gnotella) {
            ArrayList<NameValue> values = new ArrayList<NameValue>(3);
            values.add(new NameValue("audios__audio__title__", name));
            values.add(new NameValue("audios__audio__bitrate__", bitrate));
            values.add(new NameValue("audios__audio__seconds__", length));
            return new LimeXMLDocument(values, AudioMetaData.schemaURI);
        }
        return null;
    }

    private static byte[] createExtBytes(Set urns, GGEPContainer ggep) {
        try {
            if (Response.isEmpty(urns) && ggep.isEmpty()) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!Response.isEmpty(urns)) {
                Iterator iter = urns.iterator();
                while (iter.hasNext()) {
                    URN urn = (URN)iter.next();
                    Assert.that(urn != null, "Null URN");
                    baos.write(urn.toString().getBytes());
                    if (!iter.hasNext()) continue;
                    baos.write(28);
                }
                if (!ggep.isEmpty()) {
                    baos.write(28);
                }
            }
            if (!ggep.isEmpty()) {
                GGEPUtil.addGGEP(baos, ggep);
            }
            return baos.toByteArray();
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private static boolean isEmpty(Set set) {
        return set == null || set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getAsEndpoints(AlternateLocationCollection col) {
        if (col == null || !col.hasAlternateLocations()) {
            return Collections.EMPTY_SET;
        }
        long now = System.currentTimeMillis();
        AlternateLocationCollection alternateLocationCollection = col;
        synchronized (alternateLocationCollection) {
            HashSet<IpPort> endpoints = null;
            int i = 0;
            Iterator iter = col.iterator();
            while (iter.hasNext() && i < 10) {
                Object o = iter.next();
                if (!(o instanceof DirectAltLoc)) continue;
                DirectAltLoc al = (DirectAltLoc)o;
                if (al.canBeSent(2)) {
                    IpPort host = al.getHost();
                    if (NetworkUtils.isMe(host)) continue;
                    if (endpoints == null) {
                        endpoints = new HashSet<IpPort>();
                    }
                    if (!(host instanceof Endpoint)) {
                        host = new Endpoint(host.getAddress(), host.getPort());
                    }
                    endpoints.add(host);
                    ++i;
                    al.send(now, 2);
                    continue;
                }
                if (al.canBeSentAny()) continue;
                iter.remove();
            }
            return endpoints == null ? Collections.EMPTY_SET : endpoints;
        }
    }

    public void writeToStream(OutputStream os) throws IOException {
        int i;
        ByteOrder.int2leb((int)this.index, os);
        ByteOrder.int2leb((int)this.size, os);
        for (i = 0; i < this.nameBytes.length; ++i) {
            os.write(this.nameBytes[i]);
        }
        os.write(0);
        for (i = 0; i < this.extBytes.length; ++i) {
            os.write(this.extBytes[i]);
        }
        os.write(0);
    }

    public void setDocument(LimeXMLDocument doc) {
        this.document = doc;
    }

    public int getLength() {
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public Set getUrns() {
        return this.urns;
    }

    public Set getLocations() {
        return this.ggepData.locations;
    }

    public long getCreateTime() {
        return this.ggepData.createTime;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    public RemoteFileDesc toRemoteFileDesc(HostData data) {
        RemoteFileDesc rfd;
        if (this.cachedRFD != null && this.cachedRFD.getPort() == data.getPort() && this.cachedRFD.getHost().equals(data.getIP())) {
            return this.cachedRFD;
        }
        this.cachedRFD = rfd = new RemoteFileDesc(data.getIP(), data.getPort(), this.getIndex(), this.getName(), (int)this.getSize(), data.getClientGUID(), data.getSpeed(), data.isChatEnabled(), data.getQuality(), data.isBrowseHostEnabled(), this.getDocument(), this.getUrns(), data.isReplyToMulticastQuery(), data.isFirewalled(), data.getVendorCode(), System.currentTimeMillis(), data.getPushProxies(), this.getCreateTime(), data.getFWTVersionSupported());
        return rfd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response r = (Response)o;
        return this.getIndex() == r.getIndex() && this.getSize() == r.getSize() && this.getName().equals(r.getName()) && (this.getDocument() == null ? r.getDocument() == null : this.getDocument().equals(r.getDocument())) && ((Object)this.getUrns()).equals(r.getUrns());
    }

    public int hashCode() {
        return this.getName().hashCode() + (int)this.getSize() + (int)this.getIndex();
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }

    static final class GGEPContainer {
        final Set locations;
        final long createTime;
        private static final GGEPContainer EMPTY = new GGEPContainer();

        private GGEPContainer() {
            this(null, -1L);
        }

        GGEPContainer(Set locs, long create) {
            this.locations = locs == null ? Collections.EMPTY_SET : locs;
            this.createTime = create;
        }

        boolean isEmpty() {
            return this.locations.isEmpty() && this.createTime <= 0L;
        }
    }

    private static class GGEPUtil {
        private GGEPUtil() {
        }

        static void addGGEP(OutputStream out, GGEPContainer ggep) throws IOException {
            if (ggep == null || ggep.locations.size() == 0 && ggep.createTime <= 0L) {
                throw new NullPointerException("null or empty locations");
            }
            GGEP info = new GGEP();
            if (ggep.locations.size() > 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    Iterator i = ggep.locations.iterator();
                    while (i.hasNext()) {
                        try {
                            Endpoint ep = (Endpoint)i.next();
                            baos.write(ep.getHostBytes());
                            ByteOrder.short2leb((short)ep.getPort(), baos);
                        }
                        catch (UnknownHostException uhe) {}
                    }
                }
                catch (IOException impossible) {
                    ErrorService.error(impossible);
                }
                info.put("ALT", baos.toByteArray());
            }
            if (ggep.createTime > 0L) {
                info.put("CT", ggep.createTime / 1000L);
            }
            info.write(out);
        }

        static GGEPContainer getGGEP(GGEP ggep) {
            if (ggep == null) {
                return GGEPContainer.EMPTY;
            }
            Set locations = null;
            long createTime = -1L;
            if (ggep.hasKey("ALT")) {
                try {
                    locations = GGEPUtil.parseLocations(ggep.getBytes("ALT"));
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
            if (ggep.hasKey("CT")) {
                try {
                    createTime = ggep.getLong("CT") * 1000L;
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
            return locations == null && createTime == -1L ? GGEPContainer.EMPTY : new GGEPContainer(locations, createTime);
        }

        private static Set parseLocations(byte[] locBytes) {
            HashSet<Endpoint> locations = null;
            IPFilter ipFilter = IPFilter.instance();
            if (locBytes.length % 6 == 0) {
                for (int j = 0; j < locBytes.length; j += 6) {
                    int port = ByteOrder.ushort2int(ByteOrder.leb2short(locBytes, j + 4));
                    if (!NetworkUtils.isValidPort(port)) continue;
                    byte[] ip = new byte[]{locBytes[j], locBytes[j + 1], locBytes[j + 2], locBytes[j + 3]};
                    if (!NetworkUtils.isValidAddress(ip) || !ipFilter.allow(ip) || NetworkUtils.isMe(ip, port)) continue;
                    if (locations == null) {
                        locations = new HashSet<Endpoint>();
                    }
                    locations.add(new Endpoint(ip, port));
                }
            }
            return locations;
        }
    }
}

