/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;

public final class UDPReplyHandler
implements ReplyHandler {
    private final InetAddress IP;
    private final int PORT;
    private static final UDPService UDP_SERVICE = UDPService.instance();
    private static volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();

    public UDPReplyHandler(InetAddress ip, int port) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new IllegalArgumentException("invalid ip: " + ip);
        }
        this.IP = ip;
        this.PORT = port;
    }

    public static void setPersonalFilter(SpamFilter filter) {
        _personalFilter = filter;
    }

    public void handlePingReply(PingReply pong, ReplyHandler handler) {
        UDP_SERVICE.send(pong, this.IP, this.PORT);
        SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pong);
    }

    public void handleQueryReply(QueryReply hit, ReplyHandler handler) {
        UDP_SERVICE.send(hit, this.IP, this.PORT);
        SentMessageStatHandler.UDP_QUERY_REPLIES.addMessage(hit);
    }

    public void handlePushRequest(PushRequest request, ReplyHandler handler) {
        UDP_SERVICE.send(request, this.IP, this.PORT);
        SentMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(request);
    }

    public void countDroppedMessage() {
    }

    public boolean isPersonalSpam(Message m) {
        return !_personalFilter.allow(m);
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public boolean isLeafConnection() {
        return false;
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return false;
    }

    public boolean allowNewPings() {
        return true;
    }

    public void handleStatisticVM(StatisticVendorMessage m) throws IOException {
        UDPService.instance().send(m, this.IP, this.PORT);
    }

    public void handleSimppVM(SimppVM simppVM) {
    }

    public InetAddress getInetAddress() {
        return this.IP;
    }

    public String getAddress() {
        return this.IP.getHostAddress();
    }

    public boolean isStable() {
        return false;
    }

    public String getLocalePref() {
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    public String toString() {
        return this.IP.toString() + ":" + this.PORT;
    }

    public void handleUDPCrawlerPong(UDPCrawlerPong m) {
        UDPService.instance().send(m, this.IP, this.PORT);
    }

    public void reply(Message m) {
        UDPService.instance().send(m, this.IP, this.PORT);
    }

    public int getPort() {
        return this.PORT;
    }

    public byte[] getClientGUID() {
        return DataUtils.EMPTY_GUID;
    }
}

