/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AltLocManager {
    private static final AltLocManager INSTANCE = new AltLocManager();
    private final Map urnMap = Collections.synchronizedMap(new HashMap());

    public static AltLocManager instance() {
        return INSTANCE;
    }

    private AltLocManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation al, Object source) {
        URNData data;
        URN sha1 = al.getSHA1Urn();
        AlternateLocationCollection col = null;
        Object object = this.urnMap;
        synchronized (object) {
            data = (URNData)this.urnMap.get(sha1);
            if (data == null) {
                data = new URNData();
                this.urnMap.put(sha1, data);
            }
        }
        object = data;
        synchronized (object) {
            if (al instanceof DirectAltLoc) {
                if (data.direct == AlternateLocationCollection.EMPTY) {
                    data.direct = AlternateLocationCollection.create(sha1);
                }
                col = data.direct;
            } else {
                PushAltLoc push = (PushAltLoc)al;
                if (push.supportsFWTVersion() < 1) {
                    if (data.push == AlternateLocationCollection.EMPTY) {
                        data.push = AlternateLocationCollection.create(sha1);
                    }
                    col = data.push;
                } else {
                    if (data.fwt == AlternateLocationCollection.EMPTY) {
                        data.fwt = AlternateLocationCollection.create(sha1);
                    }
                    col = data.fwt;
                }
            }
        }
        boolean ret = col.add(al);
        Iterator iter = data.getListeners().iterator();
        while (iter.hasNext()) {
            AltLocListener listener = (AltLocListener)iter.next();
            if (listener == source) continue;
            listener.locationAdded(al);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation al, Object source) {
        AlternateLocationCollection col;
        URN sha1 = al.getSHA1Urn();
        URNData data = (URNData)this.urnMap.get(sha1);
        if (data == null) {
            return false;
        }
        URNData uRNData = data;
        synchronized (uRNData) {
            PushAltLoc push;
            col = al instanceof DirectAltLoc ? data.direct : ((push = (PushAltLoc)al).supportsFWTVersion() < 1 ? data.push : data.fwt);
        }
        if (col == null) {
            return false;
        }
        boolean ret = col.remove(al);
        if (!col.hasAlternateLocations()) {
            this.removeIfEmpty(sha1, data);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIfEmpty(URN sha1, URNData data) {
        boolean empty = false;
        URNData uRNData = data;
        synchronized (uRNData) {
            if (!data.direct.hasAlternateLocations() && !data.push.hasAlternateLocations() && !data.fwt.hasAlternateLocations() && data.getListeners().isEmpty()) {
                empty = true;
            }
        }
        if (empty) {
            this.urnMap.remove(sha1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection getDirect(URN sha1) {
        URNData data = (URNData)this.urnMap.get(sha1);
        if (data == null) {
            return AlternateLocationCollection.EMPTY;
        }
        URNData uRNData = data;
        synchronized (uRNData) {
            return data.direct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection getPush(URN sha1, boolean FWTOnly) {
        URNData data = (URNData)this.urnMap.get(sha1);
        if (data == null) {
            return AlternateLocationCollection.EMPTY;
        }
        URNData uRNData = data;
        synchronized (uRNData) {
            return FWTOnly ? data.fwt : data.push;
        }
    }

    public void purge() {
        this.urnMap.clear();
    }

    public void purge(URN sha1) {
        this.urnMap.remove(sha1);
    }

    public boolean hasAltlocs(URN sha1) {
        URNData data = (URNData)this.urnMap.get(sha1);
        if (data == null) {
            return false;
        }
        return data.hasAltLocs();
    }

    public int getNumLocs(URN sha1) {
        URNData data = (URNData)this.urnMap.get(sha1);
        if (data == null) {
            return 0;
        }
        return data.getNumLocs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(URN sha1, AltLocListener listener) {
        URNData data;
        Map map = this.urnMap;
        synchronized (map) {
            data = (URNData)this.urnMap.get(sha1);
            if (data == null) {
                data = new URNData();
                this.urnMap.put(sha1, data);
            }
        }
        data.addListener(listener);
    }

    public void removeListener(URN sha1, AltLocListener listener) {
        URNData data = (URNData)this.urnMap.get(sha1);
        if (data == null) {
            return;
        }
        data.removeListener(listener);
        this.removeIfEmpty(sha1, data);
    }

    private static class URNData {
        public AlternateLocationCollection direct = AlternateLocationCollection.EMPTY;
        public AlternateLocationCollection push = AlternateLocationCollection.EMPTY;
        public AlternateLocationCollection fwt = AlternateLocationCollection.EMPTY;
        private volatile List listeners = Collections.EMPTY_LIST;

        private URNData() {
        }

        public synchronized boolean hasAltLocs() {
            return this.direct.hasAlternateLocations() || this.push.hasAlternateLocations() || this.fwt.hasAlternateLocations();
        }

        public synchronized int getNumLocs() {
            return this.direct.getAltLocsSize() + this.push.getAltLocsSize() + this.fwt.getAltLocsSize();
        }

        public synchronized void addListener(AltLocListener listener) {
            ArrayList<AltLocListener> updated = new ArrayList<AltLocListener>(this.listeners);
            updated.add(listener);
            this.listeners = updated;
        }

        public synchronized void removeListener(AltLocListener listener) {
            ArrayList updated = new ArrayList(this.listeners);
            updated.remove(listener);
            this.listeners = updated;
        }

        public List getListeners() {
            return this.listeners;
        }
    }
}

