/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.archive.AbstractContribution;
import com.limegroup.gnutella.archive.Archives;
import com.limegroup.gnutella.archive.DescriptionTooShortException;
import com.limegroup.gnutella.archive.DirectoryChangeFailedException;
import com.limegroup.gnutella.archive.File;
import com.limegroup.gnutella.archive.LoginFailedException;
import com.limegroup.gnutella.archive.RefusedConnectionException;
import com.limegroup.gnutella.archive.UploadMonitorInputStream;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamException;
import org.apache.xerces.dom3.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

abstract class ArchiveContribution
extends AbstractContribution {
    public ArchiveContribution(String username, String password, String title, String description, int media) throws DescriptionTooShortException {
        this(username, password, title, description, media, Archives.defaultCollectionForMedia(media), Archives.defaultTypesForMedia(media));
    }

    public ArchiveContribution(String username, String password, String title, String description, int media, int collection, int type) throws DescriptionTooShortException {
        this.setUsername(username);
        this.setPassword(password);
        this.setTitle(title);
        this.setDescription(description);
        this.setMedia(media);
        this.setCollection(collection);
        this.setType(type);
    }

    protected abstract String getFtpServer();

    protected abstract String getFtpPath();

    protected abstract boolean isFtpDirPreMade();

    protected abstract void checkin() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void upload() throws UnknownHostException, SocketException, FTPConnectionClosedException, LoginFailedException, DirectoryChangeFailedException, CopyStreamException, RefusedConnectionException, IOException {
        block55: {
            NUM_XML_FILES = 2;
            META_XML_SUFFIX = "_meta.xml";
            FILES_XML_SUFFIX = "_files.xml";
            username = this.getUsername();
            password = this.getPassword();
            if (this.getFtpServer() == null) {
                throw new IllegalStateException("ftp server not set");
            }
            if (this.getFtpPath() == null) {
                throw new IllegalStateException("ftp path not set");
            }
            if (username == null) {
                throw new IllegalStateException("username not set");
            }
            if (password == null) {
                throw new IllegalStateException("password not set");
            }
            metaXmlString = this.serializeDocument(this.getMetaDocument());
            filesXmlString = this.serializeDocument(this.getFilesDocument());
            metaXmlBytes = metaXmlString.getBytes();
            filesXmlBytes = filesXmlString.getBytes();
            metaXmlLength = metaXmlBytes.length;
            filesXmlLength = filesXmlBytes.length;
            files = this.getFiles();
            totalFiles = 2 + files.size();
            fileNames = new String[totalFiles];
            fileSizes = new long[totalFiles];
            fileNames[0] = metaXmlName = this.getIdentifier() + "_meta.xml";
            fileSizes[0] = metaXmlLength;
            fileNames[1] = filesXmlName = this.getIdentifier() + "_files.xml";
            fileSizes[1] = filesXmlLength;
            j = 2;
            i = files.iterator();
            while (i.hasNext()) {
                f = (File)i.next();
                fileNames[j] = f.getRemoteFileName();
                fileSizes[j] = f.getFileSize();
                ++j;
            }
            for (i = 0; i < fileSizes.length; ++i) {
                this._fileNames2Progress.put(fileNames[i], new AbstractContribution.UploadFileProgress(fileSizes[i]));
                this._totalUploadSize += fileSizes[i];
            }
            ftp = new FTPClient();
            if (this.isCancelled()) {
                return;
            }
            ftp.enterLocalPassiveMode();
            ** if (!this.isCancelled()) goto lbl-1000
lbl47:
            // 1 sources

            return;
lbl-1000:
            // 1 sources

            {
                ftp.connect(this.getFtpServer());
                reply = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion(reply)) {
                    throw new RefusedConnectionException(this.getFtpServer() + "refused FTP connection");
                }
                ** if (!this.isCancelled()) goto lbl-1000
            }
lbl53:
            // 1 sources

            return;
lbl-1000:
            // 1 sources

            {
                if (!ftp.login(username, password)) {
                    throw new LoginFailedException();
                }
                if (ftp.changeWorkingDirectory(this.getFtpPath())) ** GOTO lbl68
                if (!this.isFtpDirPreMade() && !ftp.makeDirectory(this.getFtpPath())) {
                    throw new DirectoryChangeFailedException();
                }
                if (!this.isCancelled()) ** break block52
                ftp.logout();
            }
            return;
            {
                if (!ftp.changeWorkingDirectory(this.getFtpPath())) {
                    throw new DirectoryChangeFailedException();
                }
lbl68:
                // 3 sources

                if (!this.isCancelled()) ** break block53
                ftp.logout();
            }
            return;
            {
                this.connected();
                this.uploadFile(metaXmlName, new ByteArrayInputStream(metaXmlBytes), ftp);
                this.uploadFile(filesXmlName, new ByteArrayInputStream(filesXmlBytes), ftp);
                if (!this.isCancelled()) ** break block54
                ftp.logout();
            }
            return;
            {
                try {
                    ftp.setFileType(2);
                    i = files.iterator();
                    while (i.hasNext()) {
                        f = (File)i.next();
                        this.uploadFile(f.getRemoteFileName(), new FileInputStream(f.getIOFile()), ftp);
                    }
                }
                catch (InterruptedIOException ioe) {
                    ftp.logout();
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                    catch (Throwable var23_35) {
                        ftp.logout();
                        throw var23_35;
                    }
                }
                ftp.logout();
                break block55;
            }
            finally {
                try {
                    ftp.disconnect();
                }
                catch (IOException e) {}
            }
        }
        if (this.isCancelled()) {
            return;
        }
        this.checkinStarted();
        if (this.isCancelled()) {
            return;
        }
        this.checkin();
        if (this.isCancelled()) {
            return;
        }
        this.checkinCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(String remoteFileName, InputStream input, FTPClient ftp) throws InterruptedIOException, IOException {
        this.fileStarted(remoteFileName);
        BufferedInputStream fileStream = new BufferedInputStream(new UploadMonitorInputStream(input, this));
        try {
            if (this.isCancelled()) {
                throw new InterruptedIOException();
            }
            ftp.storeFile(remoteFileName, fileStream);
        }
        finally {
            ((InputStream)fileStream).close();
        }
        if (this.isCancelled()) {
            throw new InterruptedIOException();
        }
        this.fileCompleted();
    }

    private Document getMetaDocument() {
        String METADATA_ELEMENT = "metadata";
        String COLLECTION_ELEMENT = "collection";
        String MEDIATYPE_ELEMENT = "mediatype";
        String TITLE_ELEMENT = "title";
        String DESCRIPTION_ELEMENT = "description";
        String LICENSE_URL_ELEMENT = "licenseurl";
        String UPLOAD_APPLICATION_ELEMENT = "upload_application";
        String APPID_ATTR = "appid";
        String APPID_ATTR_VALUE = "LimeWire";
        String VERSION_ATTR = "version";
        String UPLOADER_ELEMENT = "uploader";
        String IDENTIFIER_ELEMENT = "identifier";
        String TYPE_ELEMENT = "type";
        try {
            File firstFile;
            String licenseUrl;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element metadataElement = document.createElement("metadata");
            document.appendChild(metadataElement);
            Element collectionElement = document.createElement("collection");
            metadataElement.appendChild(collectionElement);
            collectionElement.appendChild(document.createTextNode(Archives.getCollectionString(this.getCollection())));
            Element mediatypeElement = document.createElement("mediatype");
            metadataElement.appendChild(mediatypeElement);
            mediatypeElement.appendChild(document.createTextNode(Archives.getMediaString(this.getMedia())));
            Element typeElement = document.createElement("type");
            metadataElement.appendChild(typeElement);
            typeElement.appendChild(document.createTextNode(Archives.getTypeString(this.getType())));
            Element titleElement = document.createElement("title");
            metadataElement.appendChild(titleElement);
            titleElement.appendChild(document.createTextNode(this.getTitle()));
            Element descriptionElement = document.createElement("description");
            metadataElement.appendChild(descriptionElement);
            descriptionElement.appendChild(document.createTextNode(this.getDescription()));
            Element identifierElement = document.createElement("identifier");
            metadataElement.appendChild(identifierElement);
            identifierElement.appendChild(document.createTextNode(this.getIdentifier()));
            Element uploadApplicationElement = document.createElement("upload_application");
            metadataElement.appendChild(uploadApplicationElement);
            uploadApplicationElement.setAttribute("appid", "LimeWire");
            uploadApplicationElement.setAttribute("version", CommonUtils.getLimeWireVersion());
            Element uploaderElement = document.createElement("uploader");
            metadataElement.appendChild(uploaderElement);
            uploaderElement.appendChild(document.createTextNode(this.getUsername()));
            Iterator filesIterator = this.getFiles().iterator();
            if (filesIterator.hasNext() && (licenseUrl = (firstFile = (File)filesIterator.next()).getLicenseUrl()) != null) {
                Element licenseUrlElement = document.createElement("licenseurl");
                metadataElement.appendChild(licenseUrlElement);
                licenseUrlElement.appendChild(document.createTextNode(licenseUrl));
            }
            Map userFields = this.getFields();
            Iterator i = userFields.keySet().iterator();
            while (i.hasNext()) {
                Object field = i.next();
                Object value = userFields.get(field);
                if (!(field instanceof String)) continue;
                Element e = document.createElement((String)field);
                metadataElement.appendChild(e);
                if (value == null || !(value instanceof String)) continue;
                e.appendChild(document.createTextNode((String)value));
            }
            return document;
        }
        catch (ParserConfigurationException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    private Document getFilesDocument() {
        String FILES_ELEMENT = "files";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element filesElement = document.createElement("files");
            document.appendChild(filesElement);
            Collection files = this.getFiles();
            Iterator i = files.iterator();
            while (i.hasNext()) {
                File file = (File)i.next();
                Element fileElement = file.getElement(document);
                filesElement.appendChild(fileElement);
            }
            return document;
        }
        catch (ParserConfigurationException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    private String serializeDocument(Document document) {
        try {
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMImplementationSourceImpl");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            String str = writer.writeToString(document);
            return str;
        }
        catch (ClassNotFoundException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        catch (InstantiationException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        catch (IllegalAccessException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }
}

