/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.archive.ArchiveResponse;
import com.limegroup.gnutella.archive.BadResponseException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class ArchiveRequest {
    private final String _url;
    private final NameValuePair[] _parameters;
    private PostMethod _post;
    private ArchiveResponse _response;

    private ArchiveRequest() {
        this._url = null;
        this._parameters = null;
    }

    ArchiveRequest(String url, NameValuePair[] parameters) {
        this._url = url;
        this._parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() throws BadResponseException, HttpException, IOException {
        Document document;
        PostMethod post = new PostMethod(this._url);
        post.addRequestHeader("Content-type", "application/x-www-form-urlencoded");
        post.addRequestHeader("Accept", "text/plain");
        post.addParameters(this._parameters);
        HttpClient client = new HttpClient();
        ArchiveRequest archiveRequest = this;
        synchronized (archiveRequest) {
            this._post = post;
        }
        client.executeMethod(post);
        String responseString = post.getResponseBodyAsString();
        InputStream responseStream = post.getResponseBodyAsStream();
        ArchiveRequest archiveRequest2 = this;
        synchronized (archiveRequest2) {
            this._post = null;
        }
        post.releaseConnection();
        String RESULT_ELEMENT = "result";
        String TYPE_ATTR = "type";
        String CODE_ATTR = "code";
        String URL_ELEMENT = "url";
        String MESSAGE_ELEMENT = "message";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.parse(responseStream);
        }
        catch (ParserConfigurationException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        catch (SAXException e) {
            throw new BadResponseException(e);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            responseStream.close();
        }
        Element resultElement = ArchiveRequest._findChildElement(document, "result");
        if (resultElement == null) {
            throw new BadResponseException("No top level element <result>\n" + responseString);
        }
        String type = resultElement.getAttribute("type");
        if (type.equals("")) {
            throw new BadResponseException("<result> element does not have a \"type\" attribute\n" + responseString);
        }
        String code = resultElement.getAttribute("code");
        String message = ArchiveRequest._findChildElementsText(resultElement, "message");
        String url = ArchiveRequest._findChildElementsText(resultElement, "url");
        if (url.equals("")) {
            url = ArchiveRequest._findChildElementsText(document, "url");
        }
        this._response = new ArchiveResponse(type, code, message, url);
    }

    synchronized void cancel() {
        if (this._post != null) {
            this._post.abort();
            this._post = null;
        }
    }

    ArchiveResponse getResponse() {
        if (this._response == null) {
            throw new IllegalStateException("call execute() before calling getResponse()");
        }
        return this._response;
    }

    private static Element _findChildElement(Node parent, String name) {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !n.getNodeName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    private static String _findText(Node parent) {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3) continue;
            return n.getNodeValue();
        }
        return "";
    }

    private static String _findChildElementsText(Node parent, String name) {
        Element e = ArchiveRequest._findChildElement(parent, name);
        if (e == null) {
            return "";
        }
        return ArchiveRequest._findText(e);
    }
}

