/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ContentCache {
    private static final Log LOG = LogFactory.getLog(ContentCache.class);
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "responses.cache");
    private Map responses = new HashMap();
    private boolean dirty = false;

    ContentCache() {
    }

    synchronized int getSize() {
        return this.responses.size();
    }

    synchronized boolean hasResponseFor(URN urn) {
        return this.responses.containsKey(urn);
    }

    synchronized void addResponse(URN urn, ContentResponseData response) {
        this.responses.put(urn, response);
        this.dirty = true;
    }

    synchronized ContentResponseData getResponse(URN urn) {
        return (ContentResponseData)this.responses.get(urn);
    }

    synchronized void initialize() {
        this.dirty = false;
        this.deserialize();
    }

    synchronized void writeToDisk() {
        if (this.dirty) {
            this.persistCache();
        }
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deserialize() {
        long cutoff = System.currentTimeMillis() - 604800000L;
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
                HashMap map = (HashMap)ois.readObject();
                if (map != null) {
                    Iterator i = map.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry next = i.next();
                        Object key = next.getKey();
                        Object value = next.getValue();
                        if (!(key instanceof URN) || !(value instanceof ContentResponseData)) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn("Invalid k[" + key + "], v[" + value + "]");
                            }
                            i.remove();
                            this.dirty = true;
                        }
                        if (((ContentResponseData)value).getCreationTime() >= cutoff) continue;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Removing old response [" + value + "]");
                        }
                        i.remove();
                        this.dirty = true;
                    }
                } else {
                    map = new HashMap();
                }
                this.responses = map;
            }
            catch (Throwable t) {
                this.dirty = true;
                LOG.error("Can't read responses", t);
                Object var10_10 = null;
                IOUtils.close(ois);
                if (this.responses != null) return;
                this.responses = new HashMap();
                return;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            IOUtils.close(ois);
            if (this.responses != null) throw throwable;
            this.responses = new HashMap();
            throw throwable;
        }
        IOUtils.close(ois);
        if (this.responses != null) return;
        this.responses = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistCache() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
            oos.writeObject(this.responses);
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        finally {
            IOUtils.close(oos);
        }
    }
}

