/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalControl {
    private static final Log LOG = LogFactory.getLog(ExternalControl.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final String HTTP = "http://";
    private static boolean initialized = false;
    private static String enqueuedRequest = null;

    public static String preprocessArgs(String[] args) {
        LOG.trace("enter proprocessArgs");
        StringBuffer arg = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            arg.append(args[i]);
        }
        return arg.toString();
    }

    public static void checkForActiveLimeWire() {
        if (ExternalControl.testForLimeWire(null)) {
            System.exit(0);
        }
    }

    public static void checkForActiveLimeWire(String arg) {
        if (CommonUtils.isWindows() && ExternalControl.testForLimeWire(arg)) {
            System.exit(0);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void enqueueMagnetRequest(String arg) {
        LOG.trace("enter enqueueMagnetRequest");
        enqueuedRequest = arg;
    }

    public static void runQueuedMagnetRequest() {
        initialized = true;
        if (enqueuedRequest != null) {
            String request = enqueuedRequest;
            enqueuedRequest = null;
            ExternalControl.handleMagnetRequest(request);
        }
    }

    public static void handleMagnetRequest(String arg) {
        LOG.trace("enter handleMagnetRequest");
        ActivityCallback callback = RouterService.getCallback();
        callback.restoreApplication();
        callback.showDownloads();
        MagnetOptions[] options = MagnetOptions.parseMagnet(arg);
        if (options.length == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid magnet, ignoring: " + arg);
            }
            return;
        }
        if (!callback.handleMagnets(options)) {
            ExternalControl.downloadMagnet(options);
        }
    }

    public static void downloadMagnet(MagnetOptions[] options) {
        int i;
        if (LOG.isDebugEnabled()) {
            for (i = 0; i < options.length; ++i) {
                LOG.debug("Kicking off downloader for option " + i + " " + options[i]);
            }
        }
        for (i = 0; i < options.length; ++i) {
            MagnetOptions curOpt = options[i];
            if (LOG.isDebugEnabled()) {
                URN urn = curOpt.getSHA1Urn();
                LOG.debug("Processing magnet with params:\nurn [" + urn + "]\n" + "options [" + curOpt + "]");
            }
            String msg = curOpt.getErrorMessage();
            if (!curOpt.isDownloadable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid magnet: " + curOpt);
                }
                msg = msg != null ? msg : curOpt.toString();
                MessageService.showError("ERROR_BAD_MAGNET_LINK", msg);
                return;
            }
            if (msg != null) {
                MessageService.showError("ERROR_INVALID_URLS_IN_MAGNET");
            }
            try {
                RouterService.download(curOpt, false);
                continue;
            }
            catch (IllegalArgumentException il) {
                ErrorService.error(il);
                continue;
            }
            catch (SaveLocationException sle) {
                if (sle.getErrorCode() == 5) {
                    MessageService.showError("ERROR_ALREADY_EXISTS", sle.getFile().getName());
                    continue;
                }
                if (sle.getErrorCode() != 10) continue;
                MessageService.showError("ERROR_ALREADY_DOWNLOADING", sle.getFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireMagnet(Socket socket) {
        LOG.trace("enter fireMagnet");
        Thread.currentThread().setName("IncomingMagnetThread");
        try {
            if (!NetworkUtils.isLocalHost(socket)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid magnet request from: " + socket.getInetAddress().getHostAddress());
                }
                return;
            }
            socket.setSoTimeout(8000);
            ByteReader br = new ByteReader(socket.getInputStream());
            String line = br.readLine();
            socket.setSoTimeout(0);
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            String s = CommonUtils.getUserName() + "\r\n";
            byte[] bytes = s.getBytes();
            out.write(bytes);
            out.flush();
            ExternalControl.handleMagnetRequest(line);
        }
        catch (IOException e) {
            LOG.warn("Exception while responding to magnet request", e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean testForLimeWire(String arg) {
        Socket socket = null;
        int port = ConnectionSettings.PORT.getValue();
        if (!NetworkUtils.isValidPort(port)) {
            ConnectionSettings.PORT.revertToDefault();
            port = ConnectionSettings.PORT.getValue();
        }
        socket = Sockets.connect(LOCALHOST, port, 500);
        InputStream istream = socket.getInputStream();
        socket.setSoTimeout(500);
        ByteReader byteReader = new ByteReader(istream);
        OutputStream os = socket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os);
        BufferedWriter out = new BufferedWriter(osw);
        out.write("MAGNET " + arg + " ");
        out.write("\r\n");
        out.flush();
        String str = byteReader.readLine();
        boolean bl = str != null && str.startsWith(CommonUtils.getUserName());
        Object var11_11 = null;
        if (socket == null) return bl;
        try {
            socket.close();
            return bl;
        }
        catch (IOException e) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            try {
                Object var11_12 = null;
                if (socket == null) return false;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                socket.close();
                return false;
            }
            catch (IOException e) {}
            return false;
        }
    }

    public static MagnetOptions[] parseMagnets(String magnets) {
        ArrayList<MagnetOptions> list = new ArrayList<MagnetOptions>();
        StringTokenizer tokens = new StringTokenizer(magnets, System.getProperty("line.separator"));
        while (tokens.hasMoreTokens()) {
            String next = tokens.nextToken();
            MagnetOptions[] options = MagnetOptions.parseMagnet(next);
            if (options.length <= 0) continue;
            list.addAll(Arrays.asList(options));
        }
        return list.toArray(new MagnetOptions[0]);
    }
}

