/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.browser.HTTPHandler;
import com.limegroup.gnutella.browser.MagnetHTML;
import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.io.SocketFactory;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class HTTPAcceptor {
    private static final String MAGNET_DEFAULT = "magnet10/default.js?";
    private static final String MAGNET_PAUSE = "magnet10/pause";
    private static final String MAGNET = "magnet:?";
    private static final String NOCONTENT = "HTTP/1.1 204 No Content\r\n";
    private static final String MAGNETDETAIL = "magcmd/detail?";
    private volatile ServerSocket _socket = null;
    private int _port = 45100;
    private static String _lastRequest = null;
    private static long _lastRequestTime = 0L;

    public void start() {
        block5: {
            try {
                this.setListeningPort(this._port);
            }
            catch (IOException e) {
                boolean error = true;
                for (int i = 1; i < 20; ++i) {
                    this._port = i + 45100;
                    try {
                        this.setListeningPort(this._port);
                        error = false;
                        break;
                    }
                    catch (IOException ignored) {
                        continue;
                    }
                }
                if (!error) break block5;
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
    }

    private void setListeningPort(int port) throws IOException {
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            IOUtils.close(this._socket);
            this._socket = null;
            this._port = 0;
            return;
        }
        ServerSocket newSocket = null;
        newSocket = SocketFactory.newServerSocket(port, new SocketListener());
        IOUtils.close(this._socket);
        this._socket = newSocket;
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    private void handleHTTPRequest(Socket socket) throws IOException {
        socket.setSoTimeout(8000);
        ByteReader br = new ByteReader(socket.getInputStream());
        String str = br.readLine();
        if (str == null) {
            throw new IOException();
        }
        str.trim();
        str = URLDecoder.decode(str);
        if (str.indexOf("magnet10") > 0) {
            int loc = 0;
            loc = str.indexOf(MAGNET_DEFAULT);
            if (loc > 0) {
                int loc2 = str.lastIndexOf(" HTTP");
                String command = str.substring(loc + MAGNET_DEFAULT.length(), loc2);
                this.triggerMagnetHandling(socket, MAGNET + command);
            } else {
                loc = str.indexOf(MAGNET_PAUSE);
                if (loc > 0) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.returnNoContent(socket);
                }
            }
        } else if (str.indexOf(MAGNETDETAIL) >= 0) {
            int loc = 0;
            loc = str.indexOf(MAGNETDETAIL);
            if (loc < 0) {
                return;
            }
            int loc2 = str.lastIndexOf(" HTTP");
            String command = str.substring(loc + MAGNETDETAIL.length(), loc2);
            String page = MagnetHTML.buildMagnetDetailPage(command);
            HTTPHandler.createPage(socket, page);
        } else if (str.indexOf(MAGNET) >= 0) {
            int loc = str.indexOf(MAGNET);
            int loc2 = str.lastIndexOf(" HTTP");
            if (loc < 0) {
                return;
            }
            String command = str.substring(loc, loc2);
            this.triggerMagnetHandling(socket, command);
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void triggerMagnetHandling(Socket socket, String command) {
        long curTime = new Date().getTime();
        if (!command.equals(_lastRequest) || curTime - _lastRequestTime >= 1500L) {
            ExternalControl.handleMagnetRequest(command);
            _lastRequest = command;
            _lastRequestTime = curTime;
        }
        this.returnNoContent(socket);
    }

    private void returnNoContent(Socket socket) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            String s = NOCONTENT;
            byte[] bytes = s.getBytes();
            out.write(bytes);
            out.flush();
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ConnectionDispatchRunner
    implements Runnable {
        private Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputStream in = this._socket.getInputStream();
                this._socket.setSoTimeout(8000);
                String word = IOUtils.readWord(in, 8);
                this._socket.setSoTimeout(0);
                if (word.equals("GET")) {
                    HTTPAcceptor.this.handleHTTPRequest(this._socket);
                } else if (word.equals("MAGNET")) {
                    ExternalControl.fireMagnet(this._socket);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.close(this._socket);
            }
        }
    }

    private class SocketListener
    implements AcceptObserver {
        private SocketListener() {
        }

        public void handleIOException(IOException ignored) {
        }

        public void shutdown() {
        }

        public void handleAccept(Socket client) {
            if (NetworkUtils.isLocalHost(client)) {
                ThreadFactory.startThread(new ConnectionDispatchRunner(client), "ConnectionDispatchRunner");
            }
        }
    }
}

