/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;

public class MagnetOptions
implements Serializable {
    public static final String MAGNET = "magnet:?";
    private static final String HTTP = "http://";
    private static final String DOWNLOAD_PREFIX = "MAGNET download from ";
    private final Map optionsMap;
    private static final String XS = "XS";
    private static final String XT = "XT";
    private static final String AS = "AS";
    private static final String DN = "DN";
    private static final String KT = "KT";
    private transient String[] defaultURLs;
    private transient String localizedErrorMessage;
    private transient URN urn;
    private transient String extractedFileName;

    public static MagnetOptions createMagnet(FileDetails fileDetails) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DN, fileDetails.getFileName());
        URN urn = fileDetails.getSHA1Urn();
        if (urn != null) {
            MagnetOptions.addAppend(map, XT, urn.httpStringValue());
        }
        InetSocketAddress isa = fileDetails.getSocketAddress();
        String url = null;
        if (isa != null && urn != null) {
            StringBuffer addr = new StringBuffer(HTTP);
            addr.append(isa.getAddress().getHostAddress()).append(':').append(isa.getPort()).append("/uri-res/N2R?");
            addr.append(urn.httpStringValue());
            url = addr.toString();
            MagnetOptions.addAppend(map, XS, url);
        }
        MagnetOptions magnet = new MagnetOptions(map);
        magnet.urn = urn;
        if (url != null) {
            magnet.defaultURLs = new String[]{url};
        }
        return magnet;
    }

    public static MagnetOptions createMagnet(String keywordTopics, String fileName, URN urn, String[] defaultURLs) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KT, keywordTopics);
        map.put(DN, fileName);
        if (urn != null) {
            MagnetOptions.addAppend(map, XT, urn.httpStringValue());
        }
        if (defaultURLs != null) {
            for (int i = 0; i < defaultURLs.length; ++i) {
                MagnetOptions.addAppend(map, AS, defaultURLs[i]);
            }
        }
        MagnetOptions magnet = new MagnetOptions(map);
        magnet.urn = urn;
        if (defaultURLs != null) {
            magnet.defaultURLs = new String[defaultURLs.length];
            System.arraycopy(defaultURLs, 0, magnet.defaultURLs, 0, magnet.defaultURLs.length);
        } else {
            magnet.defaultURLs = new String[0];
        }
        return magnet;
    }

    public static MagnetOptions[] parseMagnet(String arg) {
        HashMap options = new HashMap();
        if (arg.startsWith("'")) {
            arg = arg.substring(1);
        }
        if (arg.endsWith("'")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        if (!arg.startsWith(MAGNET)) {
            return new MagnetOptions[0];
        }
        arg = arg.substring(8);
        StringTokenizer st = new StringTokenizer(arg, "&");
        while (st.hasMoreTokens()) {
            int index;
            String cmdstr;
            String keystr;
            block15: {
                keystr = st.nextToken();
                int start = (keystr = keystr.trim()).indexOf("=") + 1;
                if (start == 0) continue;
                cmdstr = keystr.substring(start);
                keystr = keystr.substring(0, start - 1);
                try {
                    cmdstr = URLDecoder.decode(cmdstr);
                }
                catch (IOException e1) {
                    continue;
                }
                int periodLoc = keystr.indexOf(".");
                if (periodLoc > 0) {
                    try {
                        index = Integer.parseInt(keystr.substring(periodLoc + 1));
                        break block15;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                index = 0;
            }
            Integer iIndex = new Integer(index);
            HashMap<String, String> curOptions = (HashMap<String, String>)options.get(iIndex);
            if (curOptions == null) {
                curOptions = new HashMap<String, String>();
                options.put(iIndex, curOptions);
            }
            if (keystr.startsWith("xt")) {
                MagnetOptions.addAppend(curOptions, XT, cmdstr);
                continue;
            }
            if (keystr.startsWith("dn")) {
                curOptions.put(DN, cmdstr);
                continue;
            }
            if (keystr.startsWith("kt")) {
                curOptions.put(KT, cmdstr);
                continue;
            }
            if (keystr.startsWith("xs")) {
                MagnetOptions.addAppend(curOptions, XS, cmdstr);
                continue;
            }
            if (!keystr.startsWith("as")) continue;
            MagnetOptions.addAppend(curOptions, AS, cmdstr);
        }
        MagnetOptions[] ret = new MagnetOptions[options.size()];
        int i = 0;
        Iterator iter = options.values().iterator();
        while (iter.hasNext()) {
            Map current = (Map)iter.next();
            ret[i] = new MagnetOptions(current);
            ++i;
        }
        return ret;
    }

    private static void addAppend(Map map, String key, String value) {
        ArrayList<String> l = (ArrayList<String>)map.get(key);
        if (l == null) {
            l = new ArrayList<String>(1);
            map.put(key, l);
        }
        l.add(value);
    }

    private MagnetOptions(Map options) {
        this.optionsMap = Collections.unmodifiableMap(options);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        StringBuffer ret = new StringBuffer(MAGNET);
        Iterator iter = this.getExactTopics().iterator();
        while (iter.hasNext()) {
            String xt = (String)iter.next();
            ret.append("&xt=").append(xt);
        }
        if (this.getDisplayName() != null) {
            ret.append("&dn=").append(URLEncoder.encode(this.getDisplayName()));
        }
        if (this.getKeywordTopic() != null) {
            ret.append("&kt=").append(URLEncoder.encode(this.getKeywordTopic()));
        }
        iter = this.getXS().iterator();
        while (iter.hasNext()) {
            String xs = (String)iter.next();
            ret.append("&xs=").append(xs);
        }
        iter = this.getAS().iterator();
        while (iter.hasNext()) {
            String as = (String)iter.next();
            ret.append("&as=").append(as);
        }
        return ret.toString();
    }

    public URN getSHA1Urn() {
        if (this.urn == null) {
            this.urn = this.extractSHA1URNFromList(this.getExactTopics());
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getXS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getAS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromURLS(this.getDefaultURLs());
            }
            if (this.urn == null) {
                this.urn = URN.INVALID;
            }
        }
        if (this.urn == URN.INVALID) {
            return null;
        }
        return this.urn;
    }

    private URN extractSHA1URNFromURLS(String[] defaultURLs) {
        for (int i = 0; i < defaultURLs.length; ++i) {
            try {
                URI uri = new URI(defaultURLs[i].toCharArray());
                String query = uri.getQuery();
                if (query == null) continue;
                return URN.createSHA1Urn(uri.getQuery());
            }
            catch (URIException e) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isDownloadable() {
        return this.getDefaultURLs().length > 0 || this.getSHA1Urn() != null && this.getQueryString() != null;
    }

    public boolean isHashOnly() {
        String kt = this.getKeywordTopic();
        String dn = this.getDisplayName();
        return !(kt != null && kt.length() <= 0 || dn != null && dn.length() <= 0 || !this.getAS().isEmpty() || !this.getXS().isEmpty() || this.getExactTopics().isEmpty());
    }

    public String getQueryString() {
        String kt = this.getKeywordTopic();
        if (kt != null && kt.length() > 0) {
            return kt;
        }
        String dn = this.getDisplayName();
        if (dn != null && dn.length() > 0) {
            return dn;
        }
        return null;
    }

    public boolean isKeywordTopicOnly() {
        String kt = this.getKeywordTopic();
        String dn = this.getDisplayName();
        return kt != null && kt.length() > 0 && (dn == null || dn.length() > 0) && this.getAS().isEmpty() && this.getXS().isEmpty() && this.getExactTopics().isEmpty();
    }

    private URN extractSHA1URNFromList(List strings) {
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            try {
                return URN.createSHA1Urn((String)iter.next());
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private List getPotentialURLs() {
        ArrayList urls = new ArrayList();
        urls.addAll(this.getPotentialURLs(this.getExactTopics()));
        urls.addAll(this.getPotentialURLs(this.getXS()));
        urls.addAll(this.getPotentialURLs(this.getAS()));
        return urls;
    }

    private List getPotentialURLs(List strings) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            String str = (String)iter.next();
            if (!str.startsWith(HTTP)) continue;
            ret.add(str);
        }
        return ret;
    }

    public String[] getDefaultURLs() {
        if (this.defaultURLs == null) {
            List urls = this.getPotentialURLs();
            Iterator it = urls.iterator();
            while (it.hasNext()) {
                try {
                    String nextURL = (String)it.next();
                    new URI(nextURL.toCharArray());
                }
                catch (URIException e) {
                    it.remove();
                    this.localizedErrorMessage = e.getLocalizedMessage();
                }
            }
            this.defaultURLs = urls.toArray(new String[urls.size()]);
        }
        return this.defaultURLs;
    }

    public String getDisplayName() {
        return (String)this.optionsMap.get(DN);
    }

    public String getFileNameForSaving() {
        if (this.extractedFileName != null) {
            return this.extractedFileName;
        }
        String name = this.getRawNameForSaving();
        while (name.startsWith(".") || name.startsWith("\\") || name.startsWith("/")) {
            name = name.substring(1);
        }
        this.extractedFileName = name;
        return this.extractedFileName;
    }

    private String getRawNameForSaving() {
        String tempFileName = this.getDisplayName();
        if (tempFileName != null && tempFileName.length() > 0) {
            return tempFileName;
        }
        tempFileName = this.getKeywordTopic();
        if (tempFileName != null && tempFileName.length() > 0) {
            return tempFileName;
        }
        URN urn = this.getSHA1Urn();
        if (urn != null) {
            tempFileName = urn.toString();
            return tempFileName;
        }
        String[] urls = this.getDefaultURLs();
        if (urls.length > 0) {
            try {
                URI uri = new URI(urls[0].toCharArray());
                tempFileName = MagnetOptions.extractFileName(uri);
                if (tempFileName != null && tempFileName.length() > 0) {
                    return tempFileName;
                }
            }
            catch (URIException e) {
                // empty catch block
            }
        }
        try {
            File file = File.createTempFile("magnet", "");
            file.deleteOnExit();
            tempFileName = file.getName();
            return tempFileName;
        }
        catch (IOException ie) {
            tempFileName = DOWNLOAD_PREFIX;
            return tempFileName;
        }
    }

    public String getKeywordTopic() {
        return (String)this.optionsMap.get(KT);
    }

    public List getExactTopics() {
        return this.getList(XT);
    }

    public List getXS() {
        return this.getList(XS);
    }

    public List getAS() {
        return this.getList(AS);
    }

    private List getList(String key) {
        List l = (List)this.optionsMap.get(key);
        return l == null ? Collections.EMPTY_LIST : l;
    }

    public String getErrorMessage() {
        return this.localizedErrorMessage;
    }

    public static String extractFileName(URI uri) {
        String path = null;
        String host = null;
        try {
            path = uri.getPath();
            host = uri.getHost();
        }
        catch (URIException e) {
            // empty catch block
        }
        if (path != null && path.length() > 0) {
            int i = path.lastIndexOf(47);
            if (i < 0) {
                return path;
            }
            if (i >= 0 && i < path.length() - 1) {
                return path.substring(i + 1);
            }
        }
        if (host != null) {
            return DOWNLOAD_PREFIX + host;
        }
        return DOWNLOAD_PREFIX;
    }
}

