/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.messages.Message;

public abstract class AbstractMessageQueue
implements MessageQueue {
    private final int _cycleSize;
    private int _leftInCycle;
    private int _timeout;
    protected int _dropped;

    protected AbstractMessageQueue(int cycle, int timeout) throws IllegalArgumentException {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout too small: " + cycle);
        }
        if (cycle <= 0) {
            throw new IllegalArgumentException("Cycle too small: " + cycle);
        }
        this._cycleSize = cycle;
        this._leftInCycle = cycle;
        this._timeout = timeout;
    }

    public void add(Message m) {
        Message dropmsg = this.addInternal(m);
        if (dropmsg != null) {
            ++this._dropped;
            dropmsg.recordDrop();
        }
    }

    protected abstract Message addInternal(Message var1);

    public Message removeNext() {
        Message m;
        if (this._leftInCycle == 0) {
            return null;
        }
        long expireTime = System.currentTimeMillis() - (long)this._timeout;
        while (true) {
            if ((m = this.removeNextInternal()) == null) {
                return null;
            }
            if (m.getCreationTime() >= expireTime) break;
            ++this._dropped;
            m.recordDrop();
        }
        --this._leftInCycle;
        return m;
    }

    protected abstract Message removeNextInternal();

    public void resetCycle() {
        this._leftInCycle = this._cycleSize;
    }

    public final int resetDropped() {
        int ret = this._dropped;
        this._dropped = 0;
        return ret;
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

