/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

public class ConnectionStats {
    private int _numMessagesSent;
    private int _numMessagesReceived;
    private int _numReceivedMessagesDropped;
    private int _numSentMessagesDropped;
    private int _lastReceived;
    private int _lastRecvDropped;
    private int _lastSent;
    private int _lastSentDropped;

    public int getSent() {
        return this._numMessagesSent;
    }

    public int getReceived() {
        return this._numMessagesReceived;
    }

    public int getSentDropped() {
        return this._numSentMessagesDropped;
    }

    public int getReceivedDropped() {
        return this._numReceivedMessagesDropped;
    }

    public void addSentDropped(int dropped) {
        this._numSentMessagesDropped += dropped;
    }

    public void addSent() {
        ++this._numMessagesSent;
    }

    public void addReceivedDropped() {
        ++this._numReceivedMessagesDropped;
    }

    public void addReceived() {
        ++this._numMessagesReceived;
    }

    public synchronized float getPercentReceivedDropped() {
        int rdiff = this._numMessagesReceived - this._lastReceived;
        int ddiff = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return percent;
    }

    public synchronized float getPercentSentDropped() {
        int rdiff = this._numMessagesSent - this._lastSent;
        int ddiff = this._numSentMessagesDropped - this._lastSentDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return percent;
    }
}

