/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.BufferByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MessageWriter
implements ChannelWriter,
OutputRunner {
    private final MessageQueue queue;
    private final BufferByteArrayOutputStream out;
    private final ConnectionStats stats;
    private final SentMessageHandler sendHandler;
    private InterestWriteChannel channel;
    private boolean flipped = false;
    private boolean shutdown = false;

    public MessageWriter(ConnectionStats stats, MessageQueue queue, SentMessageHandler sendHandler) {
        this(stats, queue, sendHandler, null);
    }

    public MessageWriter(ConnectionStats stats, MessageQueue queue, SentMessageHandler sendHandler, InterestWriteChannel sink) {
        this.stats = stats;
        this.queue = queue;
        this.sendHandler = sendHandler;
        this.channel = sink;
        this.out = new BufferByteArrayOutputStream();
    }

    public synchronized InterestWriteChannel getWriteChannel() {
        return this.channel;
    }

    public synchronized void setWriteChannel(InterestWriteChannel channel) {
        this.channel = channel;
        channel.interest(this, true);
    }

    public synchronized void send(Message m) {
        if (this.shutdown) {
            return;
        }
        this.stats.addSent();
        this.queue.add(m);
        int dropped = this.queue.resetDropped();
        this.stats.addSentDropped(dropped);
        if (this.channel != null) {
            this.channel.interest(this, true);
        }
    }

    public synchronized boolean handleWrite() throws IOException {
        if (this.channel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        if (this.writeRemaining()) {
            return true;
        }
        do {
            Message m = this.queue.removeNext();
            int dropped = this.queue.resetDropped();
            this.stats.addSentDropped(dropped);
            if (m == null) {
                this.channel.interest(this, false);
                return false;
            }
            m.writeQuickly(this.out);
            this.sendHandler.processSentMessage(m);
        } while (!this.writeRemaining());
        return true;
    }

    private boolean writeRemaining() throws IOException {
        if (this.shutdown) {
            throw new IOException("connection shut down.");
        }
        ByteBuffer buffer = this.out.buffer();
        if (this.flipped || buffer.position() > 0) {
            if (!this.flipped) {
                buffer.flip();
                this.flipped = true;
            }
            this.channel.write(buffer);
            if (buffer.hasRemaining()) {
                return true;
            }
            this.flipped = false;
            buffer.clear();
        }
        return false;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
    }

    public void handleIOException(IOException x) {
        throw new RuntimeException("Unsupported", x);
    }
}

