/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointForSelf;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.http.SimpleReadHeaderState;
import com.limegroup.gnutella.http.SimpleWriteHeaderState;
import com.limegroup.gnutella.io.IOState;
import com.limegroup.gnutella.io.IOStateMachine;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.NBThrottle;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.ReadSkipState;
import com.limegroup.gnutella.io.ReadState;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleReader;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.ThexReader;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPDownloader
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog(HTTPDownloader.class);
    public static final int BUF_LENGTH = 2048;
    private static final int MIN_RETRY_AFTER = 60;
    private static final int MAX_RETRY_AFTER = 3600;
    static int MIN_PARTIAL_FILE_BYTES = 0x100000;
    private static final Throttle THROTTLE = new NBThrottle(false, Float.MAX_VALUE);
    private RemoteFileDesc _rfd;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private int _totalAmountRead;
    private int _amountRead;
    private int _amountToRead;
    private volatile boolean _disconnect;
    private int _initialReadingPoint;
    private int _initialWritingPoint;
    private long _contentLength;
    private volatile boolean _bodyConsumed = true;
    private Socket _socket;
    private IOStateMachine _stateMachine;
    private Observer observerHandler;
    private SimpleReadHeaderState _headerReader;
    private boolean _requestingThex;
    private ThexReader _thexReader;
    private final VerifyingFile _incompleteFile;
    private HashSet _locationsReceived;
    private Set _goodLocs;
    private Set _goodPushLocs;
    private Set _badPushLocs;
    private Set _badLocs;
    private Set _writtenGoodLocs;
    private Set _writtenBadLocs;
    private Set _writtenPushLocs;
    private Set _writtenBadPushLocs;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private String _thexUri = null;
    private String _root32 = null;
    private boolean _thexSucceeded = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isActive = false;
    private Interval _requestedInterval = null;
    private boolean _wantsFalts = false;
    private final boolean _inNetwork;

    public HTTPDownloader(RemoteFileDesc rfd, VerifyingFile incompleteFile, boolean inNetwork) {
        this(null, rfd, incompleteFile, inNetwork);
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc rfd, VerifyingFile incompleteFile, boolean inNetwork) {
        if (rfd == null) {
            throw new NullPointerException("null rfd");
        }
        this._rfd = rfd;
        this._socket = socket;
        this._incompleteFile = incompleteFile;
        this._filename = rfd.getFileName();
        this._index = rfd.getIndex();
        this._guid = rfd.getClientGUID();
        this._amountToRead = 0;
        this._port = rfd.getPort();
        this._host = rfd.getHost();
        this._chatEnabled = rfd.chatEnabled();
        this._browseEnabled = rfd.browseHostEnabled();
        this._locationsReceived = new HashSet();
        this._goodLocs = new HashSet();
        this._badLocs = new HashSet();
        this._goodPushLocs = new HashSet();
        this._badPushLocs = new HashSet();
        this._writtenGoodLocs = new HashSet();
        this._writtenBadLocs = new HashSet();
        this._writtenPushLocs = new HashSet();
        this._writtenBadPushLocs = new HashSet();
        this._amountRead = 0;
        this._totalAmountRead = 0;
        this._inNetwork = inNetwork;
        HTTPDownloader.applyRate();
    }

    Collection getLocationsReceived() {
        return this._locationsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSuccessfulAltLoc(AlternateLocation loc) {
        if (loc instanceof DirectAltLoc) {
            Set set = this._badLocs;
            synchronized (set) {
                this._writtenBadLocs.remove(loc);
                this._badLocs.remove(loc);
            }
            set = this._goodLocs;
            synchronized (set) {
                if (!this._writtenGoodLocs.contains(loc)) {
                    this._goodLocs.add(loc);
                }
            }
        }
        Set set = this._badPushLocs;
        synchronized (set) {
            this._writtenBadPushLocs.remove(loc);
            this._badPushLocs.remove(loc);
        }
        set = this._goodPushLocs;
        synchronized (set) {
            if (!this._writtenPushLocs.contains(loc)) {
                this._goodPushLocs.add(loc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailedAltLoc(AlternateLocation loc) {
        if (loc instanceof DirectAltLoc) {
            Set set = this._goodLocs;
            synchronized (set) {
                this._writtenGoodLocs.remove(loc);
                this._goodLocs.remove(loc);
            }
            set = this._badLocs;
            synchronized (set) {
                if (!this._writtenBadLocs.contains(loc)) {
                    this._badLocs.add(loc);
                }
            }
        }
        Set set = this._goodPushLocs;
        synchronized (set) {
            this._writtenPushLocs.remove(loc);
            this._goodPushLocs.remove(loc);
        }
        set = this._badPushLocs;
        synchronized (set) {
            if (!this._writtenBadPushLocs.contains(loc)) {
                this._badPushLocs.add(loc);
            }
        }
    }

    public void connectTCP(int timeout) throws IOException {
        if (this._socket == null) {
            long curTime = System.currentTimeMillis();
            this._socket = Sockets.connect(this._host, this._port, timeout);
            NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - curTime));
        }
        this._socket.setKeepAlive(true);
        this.observerHandler = new Observer();
        this._stateMachine = new IOStateMachine(this.observerHandler, new LinkedList(), 2048);
        this._stateMachine.setReadChannel(new ThrottleReader(THROTTLE));
        ((NIOMultiplexor)((Object)this._socket)).setReadObserver(this._stateMachine);
        ((NIOMultiplexor)((Object)this._socket)).setWriteObserver(this._stateMachine);
        this._socket.setSoTimeout(8000);
    }

    public void connectHTTP(int start, int stop, boolean supportQueueing, IOStateObserver observer) {
        this.connectHTTP(start, stop, supportQueueing, -1, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(int start, int stop, boolean supportQueueing, int amountDownloaded, IOStateObserver observer) {
        Object next;
        Iterator iter;
        URN sha1;
        AlternateLocation me;
        if (start < 0) {
            throw new IllegalArgumentException("invalid start: " + start);
        }
        if (stop <= start) {
            throw new IllegalArgumentException("stop(" + stop + ") <= start(" + start + ")");
        }
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            this._isActive = true;
            this._amountToRead = stop - start;
            this._amountRead = 0;
            this._initialReadingPoint = start;
            this._initialWritingPoint = start;
            this._bodyConsumed = false;
            this._contentLength = 0L;
            this._requestedInterval = new Interval(this._initialReadingPoint, stop - 1);
        }
        this.observerHandler.setDelegate(observer);
        LinkedHashMap<Object, Object> headers = new LinkedHashMap<Object, Object>();
        HashSet<HTTPHeaderValue> features = new HashSet<HTTPHeaderValue>();
        headers.put("HOST", this._host + ":" + this._port);
        headers.put("User-Agent", CommonUtils.getHttpServer());
        if (supportQueueing) {
            headers.put("X-Queue", "0.1");
            features.add(ConstantHTTPHeaderValue.QUEUE_FEATURE);
        }
        if (RouterService.acceptedIncomingConnection() || UDPService.instance().canDoFWT()) {
            features.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
            if (!RouterService.acceptedIncomingConnection()) {
                features.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
            }
        }
        if (this.isPartialFileValid() && (RouterService.acceptedIncomingConnection() || this._wantsFalts) && (me = AlternateLocation.create(this._rfd.getSHA1Urn())) != null) {
            this.addSuccessfulAltLoc(me);
        }
        if ((sha1 = this._rfd.getSHA1Urn()) != null) {
            headers.put(HTTPHeaderName.GNUTELLA_CONTENT_URN, sha1);
        }
        HashSet<Object> writeClone = null;
        Set set = this._goodLocs;
        synchronized (set) {
            if (this._goodLocs.size() > 0) {
                writeClone = new HashSet<Object>();
                iter = this._goodLocs.iterator();
                while (iter.hasNext()) {
                    next = iter.next();
                    writeClone.add(next);
                    this._writtenGoodLocs.add(next);
                }
                this._goodLocs.clear();
            }
        }
        if (writeClone != null) {
            headers.put(HTTPHeaderName.ALT_LOCATION, new HTTPHeaderValueCollection(writeClone));
        }
        writeClone = null;
        set = this._badLocs;
        synchronized (set) {
            if (this._badLocs.size() > 0) {
                writeClone = new HashSet();
                iter = this._badLocs.iterator();
                while (iter.hasNext()) {
                    next = iter.next();
                    writeClone.add(next);
                    this._writtenBadLocs.add(next);
                }
                this._badLocs.clear();
            }
        }
        if (writeClone != null) {
            headers.put(HTTPHeaderName.NALTS, new HTTPHeaderValueCollection(writeClone));
        }
        if (this._wantsFalts) {
            writeClone = null;
            set = this._goodPushLocs;
            synchronized (set) {
                if (this._goodPushLocs.size() > 0) {
                    writeClone = new HashSet();
                    iter = this._goodPushLocs.iterator();
                    while (iter.hasNext()) {
                        next = (PushAltLoc)iter.next();
                        if (((PushAltLoc)next).getPushAddress().getProxies().isEmpty()) {
                            if (((PushAltLoc)next).getPushAddress() instanceof PushEndpointForSelf) continue;
                            Assert.that(false, "empty pushloc in downloader");
                        }
                        writeClone.add(next);
                        this._writtenPushLocs.add(next);
                    }
                    this._goodPushLocs.clear();
                }
            }
            if (writeClone != null) {
                headers.put(HTTPHeaderName.FALT_LOCATION, new HTTPHeaderValueCollection(writeClone));
            }
            writeClone = null;
            set = this._badPushLocs;
            synchronized (set) {
                if (this._badPushLocs.size() > 0) {
                    writeClone = new HashSet();
                    iter = this._badPushLocs.iterator();
                    while (iter.hasNext()) {
                        next = (PushAltLoc)iter.next();
                        Assert.that(!((PushAltLoc)next).getPushAddress().getProxies().isEmpty());
                        writeClone.add(next);
                        this._writtenBadPushLocs.add(next);
                    }
                    this._badPushLocs.clear();
                }
            }
            if (writeClone != null) {
                headers.put(HTTPHeaderName.BFALT_LOCATION, new HTTPHeaderValueCollection(writeClone));
            }
        }
        headers.put("Range", "bytes=" + this._initialReadingPoint + "-" + (stop - 1));
        if (RouterService.acceptedIncomingConnection() && !NetworkUtils.isPrivateAddress(RouterService.getAddress())) {
            int port = RouterService.getPort();
            String host = NetworkUtils.ip2string(RouterService.getAddress());
            headers.put("X-Node", host + ":" + port);
            features.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
            if (ChatSettings.CHAT_ENABLED.getValue()) {
                headers.put("Chat", host + ":" + port);
                features.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
            }
        }
        if (features.size() > 0) {
            headers.put(HTTPHeaderName.FEATURES, new HTTPHeaderValueCollection(features));
        }
        if (amountDownloaded > 0) {
            headers.put(HTTPHeaderName.DOWNLOADED, "" + amountDownloaded);
        }
        SimpleWriteHeaderState writer = new SimpleWriteHeaderState("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1", headers, this._inNetwork ? BandwidthStat.HTTP_HEADER_UPSTREAM_INNETWORK_BANDWIDTH : BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH);
        SimpleReadHeaderState reader = new SimpleReadHeaderState(this._inNetwork ? BandwidthStat.HTTP_HEADER_DOWNSTREAM_INNETWORK_BANDWIDTH : BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH, DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._stateMachine.addStates(new IOState[]{writer, reader});
        this._headerReader = reader;
    }

    void consumeBody(IOStateObserver observer) {
        if (!this._bodyConsumed) {
            if (this._contentLength != -1L) {
                this.consumeBody(this._contentLength, observer);
            } else {
                observer.handleIOException(new IOException("no content length"));
            }
        } else {
            observer.handleStatesFinished();
        }
        this._bodyConsumed = true;
    }

    boolean isBodyConsumed() {
        return this._bodyConsumed;
    }

    public void requestHashTree(URN sha1, IOStateObserver observer) {
        SimpleReadHeaderState reader;
        if (LOG.isDebugEnabled()) {
            LOG.debug("requesting HashTree for " + this._thexUri + " from " + this._host + ":" + this._port);
        }
        this.observerHandler.setDelegate(observer);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("HOST", this._host + ":" + this._port);
        headers.put("User-Agent", CommonUtils.getHttpServer());
        SimpleWriteHeaderState writer = new SimpleWriteHeaderState("GET " + this._thexUri + " HTTP/1.1", headers, BandwidthStat.GNUTELLA_UPSTREAM_BANDWIDTH);
        this._headerReader = reader = new SimpleReadHeaderState(BandwidthStat.GNUTELLA_DOWNSTREAM_BANDWIDTH, DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._requestingThex = true;
        this._bodyConsumed = false;
        this._stateMachine.addStates(new IOState[]{writer, reader});
    }

    boolean isRequestingThex() {
        return this._requestingThex;
    }

    public ConnectionStatus parseThexResponseHeaders() {
        this._requestingThex = false;
        try {
            int code = HTTPDownloader.parseHTTPCode(this._headerReader.getConnectLine(), this._rfd);
            boolean failed = false;
            if (code < 200 || code >= 300) {
                failed = true;
            }
            return this.parseThexHeaders(code, failed);
        }
        catch (IOException failed) {
            return ConnectionStatus.getNoFile();
        }
    }

    public void downloadThexBody(URN sha1, IOStateObserver observer) {
        this._thexReader = HashTree.createHashTreeReader(sha1.httpStringValue(), this._root32, this._rfd.getFileSize());
        this.observerHandler.setDelegate(observer);
        this._stateMachine.addState(this._thexReader);
    }

    public HashTree getHashTree() {
        this._contentLength -= this._thexReader.getAmountProcessed();
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        HashTree tree = null;
        try {
            tree = this._thexReader.getHashTree();
        }
        catch (IOException iox) {
            LOG.warn("Failed to create tree", iox);
        }
        if (tree == null) {
            this._rfd.setTHEXFailed();
        } else {
            this._thexSucceeded = true;
        }
        return tree;
    }

    private ConnectionStatus parseThexHeaders(int code, boolean failed) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._rfd + " consuming headers");
        }
        this._contentLength = -1L;
        Iterator<Map.Entry<Object, Object>> i = this._headerReader.getHeaders().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> next = i.next();
            String header = (String)next.getKey();
            if (HTTPHeaderName.CONTENT_LENGTH.is(header)) {
                this._contentLength = HTTPDownloader.readContentLength((String)next.getValue());
            }
            if (code != 503 || !HTTPHeaderName.QUEUE.is(header)) continue;
            String value = (String)next.getValue();
            int[] queueInfo = new int[]{-1, -1, -1};
            this.parseQueueHeaders(value, queueInfo);
            int min = queueInfo[0];
            int max = queueInfo[1];
            int pos = queueInfo[2];
            if (min == -1 || max == -1 || pos == -1) continue;
            this._bodyConsumed = true;
            return ConnectionStatus.getQueued(pos, min);
        }
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        if (failed || this._contentLength == -1L) {
            return ConnectionStatus.getNoFile();
        }
        return ConnectionStatus.getConnected();
    }

    private void consumeBody(long contentLength, IOStateObserver observer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("enter consumeBody(" + contentLength + ")");
        }
        if (contentLength < 0L) {
            observer.handleIOException(new IOException("unknown content-length, can't consume"));
        }
        this.observerHandler.setDelegate(observer);
        this._stateMachine.addState(new ReadSkipState(contentLength));
    }

    public void parseHeaders() throws IOException {
        Object next;
        String connectLine = this._headerReader.getConnectLine();
        Properties headers = this._headerReader.getHeaders();
        if (connectLine == null || connectLine.equals("")) {
            throw new IOException();
        }
        int code = HTTPDownloader.parseHTTPCode(connectLine, this._rfd);
        this._contentLength = -1L;
        int[] refQueueInfo = new int[]{-1, -1, -1};
        Iterator<Map.Entry<Object, Object>> i = headers.entrySet().iterator();
        while (i.hasNext()) {
            next = i.next();
            String header = (String)next.getKey();
            String value = (String)next.getValue();
            if (HTTPHeaderName.CONTENT_RANGE.is(header)) {
                this.validateContentRange(this.parseContentRange(value));
                continue;
            }
            if (HTTPHeaderName.CONTENT_LENGTH.is(header)) {
                this._contentLength = HTTPDownloader.readContentLength(value);
                continue;
            }
            if (HTTPHeaderName.CONTENT_URN.is(header)) {
                this.checkContentUrnHeader(value, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.GNUTELLA_CONTENT_URN.is(header)) {
                this.checkContentUrnHeader(value, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.ALT_LOCATION.is(header)) {
                this.readAlternateLocations(value);
                continue;
            }
            if (HTTPHeaderName.QUEUE.is(header)) {
                this.parseQueueHeaders(value, refQueueInfo);
                continue;
            }
            if (HTTPHeaderName.SERVER.is(header)) {
                this._server = value;
                continue;
            }
            if (HTTPHeaderName.AVAILABLE_RANGES.is(header)) {
                this.parseAvailableRangesHeader(value, this._rfd);
                continue;
            }
            if (HTTPHeaderName.RETRY_AFTER.is(header)) {
                HTTPDownloader.parseRetryAfterHeader(value, this._rfd);
                continue;
            }
            if (HTTPHeaderName.CREATION_TIME.is(header)) {
                HTTPDownloader.parseCreationTimeHeader(value, this._rfd);
                continue;
            }
            if (HTTPHeaderName.FEATURES.is(header)) {
                this.parseFeatureHeader(value);
                continue;
            }
            if (HTTPHeaderName.THEX_URI.is(header)) {
                this.parseTHEXHeader(value);
                continue;
            }
            if (HTTPHeaderName.FALT_LOCATION.is(header)) {
                this.parseFALTHeader(value);
                continue;
            }
            if (!HTTPHeaderName.PROXIES.is(header)) continue;
            this.parseProxiesHeader(value);
        }
        if (code < 200 || code >= 300) {
            if (code == 404) {
                throw new FileNotFoundException();
            }
            if (code == 410) {
                throw new NotSharingException();
            }
            if (code == 416) {
                if (this._rfd.isPartialSource()) {
                    Iterator iter = this._rfd.getAvailableRanges().getAllIntervals();
                    while (iter.hasNext()) {
                        next = (Interval)iter.next();
                        if (!this._requestedInterval.isSubrange((Interval)next)) continue;
                        throw new ProblemReadingHeaderException("Bad ranges sent");
                    }
                } else {
                    throw new ProblemReadingHeaderException("no ranges sent");
                }
                throw new RangeNotAvailableException();
            }
            if (code == 503) {
                int min = refQueueInfo[0];
                int max = refQueueInfo[1];
                int pos = refQueueInfo[2];
                if (min != -1 && max != -1 && pos != -1) {
                    this._bodyConsumed = true;
                    throw new QueuedException(min, max, pos);
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(code);
        }
    }

    private void checkContentUrnHeader(String value, URN sha1) throws ContentUrnMismatchException {
        if (this._root32 == null && value.indexOf("urn:bitprint:") > -1) {
            this._root32 = value.substring(value.lastIndexOf(".") + 1).trim();
        }
        if (sha1 == null) {
            return;
        }
        URN contentUrn = null;
        try {
            contentUrn = URN.createSHA1Urn(value);
        }
        catch (IOException ioe) {
            return;
        }
        if (!sha1.equals(contentUrn)) {
            throw new ContentUrnMismatchException();
        }
    }

    private void readAlternateLocations(String altStr) {
        if (altStr == null) {
            return;
        }
        URN sha1 = this._rfd.getSHA1Urn();
        if (sha1 == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(altStr, ",");
        while (st.hasMoreTokens()) {
            try {
                RemoteFileDesc rfd;
                AlternateLocation al = AlternateLocation.create(st.nextToken().trim(), sha1);
                Assert.that(al.getSHA1Urn().equals(sha1));
                if (al.isMe() || !this._locationsReceived.add(rfd = al.createRemoteFileDesc(this._rfd.getSize()))) continue;
                if (al instanceof DirectAltLoc) {
                    DownloadStat.ALTERNATE_COLLECTED.incrementStat();
                    continue;
                }
                DownloadStat.PUSH_ALTERNATE_COLLECTED.incrementStat();
            }
            catch (IOException e) {}
        }
    }

    private boolean isPartialFileValid() {
        return this._rfd.getSHA1Urn() != null && this._incompleteFile.getVerifiedBlockSize() > MIN_PARTIAL_FILE_BYTES && UploadSettings.ALLOW_PARTIAL_SHARING.getValue() && NetworkUtils.isValidPort(RouterService.getPort()) && NetworkUtils.isValidAddress(RouterService.getAddress());
    }

    public static int readContentLength(String value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private static int parseHTTPCode(String str, RemoteFileDesc rfd) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String token = tokenizer.nextToken();
        if (token.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException("got: " + str);
        }
        rfd.setHTTP11(token.indexOf("1.1") > 0);
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        token = tokenizer.nextToken();
        String num = token.trim();
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
    }

    private void parseQueueHeaders(String str, int[] refQueueInfo) {
        if (str == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, " ,:=");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                String value;
                if (token.equalsIgnoreCase("pollMin")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[0] = Integer.parseInt(value);
                    continue;
                }
                if (token.equalsIgnoreCase("pollMax")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[1] = Integer.parseInt(value);
                    continue;
                }
                if (!token.equalsIgnoreCase("position")) continue;
                value = tokenizer.nextToken();
                refQueueInfo[2] = Integer.parseInt(value);
            }
            catch (NumberFormatException nfx) {
                Arrays.fill(refQueueInfo, -1);
                break;
            }
            catch (NoSuchElementException nsex) {
                Arrays.fill(refQueueInfo, -1);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateContentRange(Interval responseRange) throws IOException {
        int low = responseRange.low;
        int high = responseRange.high + 1;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (this._disconnect) {
                throw new IOException("stolen from");
            }
            if (low < this._initialReadingPoint || high > this._initialReadingPoint + this._amountToRead) {
                throw new ProblemReadingHeaderException("invalid subrange given.  wanted low: " + this._initialReadingPoint + ", high: " + (this._initialReadingPoint + this._amountToRead - 1) + "... given low: " + low + ", high: " + high);
            }
            this._initialReadingPoint = low;
            this._amountToRead = high - low;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interval parseContentRange(String str) throws IOException {
        int numAfterSlash;
        int numBeforeSlash;
        int numBeforeDash;
        if (LOG.isDebugEnabled()) {
            LOG.debug("reading content range: " + str);
        }
        try {
            int start = str.indexOf("bytes") + 6;
            int slash = str.indexOf(47);
            if (str.substring(start, slash).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this._rfd + " Content-Range like */?, " + str);
                }
                HTTPDownloader hTTPDownloader = this;
                synchronized (hTTPDownloader) {
                    return new Interval(0L, this._amountToRead - 1);
                }
            }
            int dash = str.lastIndexOf("-");
            numBeforeDash = Integer.parseInt(str.substring(start, dash));
            numBeforeSlash = Integer.parseInt(str.substring(dash + 1, slash));
            if (numBeforeSlash < numBeforeDash) {
                throw new ProblemReadingHeaderException("invalid range, high (" + numBeforeSlash + ") less than low (" + numBeforeDash + ")");
            }
            if (str.substring(slash + 1).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this._rfd + " Content-Range like #-#/*, " + str);
                }
                return new Interval(numBeforeDash, numBeforeSlash);
            }
            numAfterSlash = Integer.parseInt(str.substring(slash + 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(str);
        }
        if (numBeforeSlash == numAfterSlash) {
            --numBeforeDash;
            --numBeforeSlash;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._rfd + " Content-Range like #-#/#, " + str);
        }
        return new Interval(numBeforeDash, numBeforeSlash);
    }

    private void parseAvailableRangesHeader(String line, RemoteFileDesc rfd) throws IOException {
        int stop;
        IntervalSet availableRanges = new IntervalSet();
        line = line.toLowerCase();
        int start = line.indexOf("bytes") + 6;
        while (start != -1 && start < line.length() && (stop = line.indexOf(45, start)) != -1) {
            Interval interval = null;
            try {
                int low = Integer.parseInt(line.substring(start, stop).trim());
                start = stop + 1;
                stop = line.indexOf(44, start);
                if (stop == -1) {
                    stop = line.length();
                }
                int high = Integer.parseInt(line.substring(start, stop).trim());
                start = stop + 1;
                if (high >= rfd.getSize()) {
                    high = rfd.getSize() - 1;
                }
                if (low > high) continue;
                interval = new Interval(low, high);
            }
            catch (NumberFormatException e) {
                throw new ProblemReadingHeaderException(e);
            }
            availableRanges.add(interval);
        }
        rfd.setAvailableRanges(availableRanges);
    }

    private static void parseRetryAfterHeader(String str, RemoteFileDesc rfd) throws IOException {
        int seconds = 0;
        try {
            seconds = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
        seconds = Math.max(seconds, 60);
        seconds = Math.min(seconds, 3600);
        rfd.setRetryAfter(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCreationTimeHeader(String str, RemoteFileDesc rfd) throws IOException {
        long milliSeconds = 0L;
        try {
            milliSeconds = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
        if (rfd.getSHA1Urn() != null) {
            CreationTimeCache ctCache;
            CreationTimeCache creationTimeCache = ctCache = CreationTimeCache.instance();
            synchronized (creationTimeCache) {
                Long cTime = ctCache.getCreationTime(rfd.getSHA1Urn());
                if (cTime == null || cTime > milliSeconds) {
                    ctCache.addTime(rfd.getSHA1Urn(), milliSeconds);
                }
            }
        }
    }

    private void parseFeatureHeader(String str) {
        StringTokenizer tok = new StringTokenizer(str, ",");
        while (tok.hasMoreTokens()) {
            String feature = tok.nextToken();
            String protocol = "";
            int slash = feature.indexOf("/");
            protocol = slash == -1 ? feature.toLowerCase().trim() : feature.substring(0, slash).toLowerCase().trim();
            if (protocol.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (protocol.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (protocol.equals("fwalt")) {
                this._wantsFalts = true;
                continue;
            }
            if (!protocol.equals("fwt")) continue;
            int FWTVersion = 0;
            try {
                FWTVersion = (int)HTTPUtils.parseFeatureToken(feature);
                this._wantsFalts = true;
            }
            catch (ProblemReadingHeaderException prhe) {
                continue;
            }
            try {
                this.updatePEAddress();
                PushEndpoint.setFWTVersionSupported(this._rfd.getClientGUID(), FWTVersion);
            }
            catch (IOException ignored) {}
        }
    }

    private void parseTHEXHeader(String str) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._host + ":" + this._port + ">" + str);
        }
        if (str.indexOf(";") > 0) {
            StringTokenizer tok = new StringTokenizer(str, ";");
            this._thexUri = tok.nextToken();
            this._root32 = tok.nextToken();
        } else {
            this._thexUri = str;
        }
    }

    private void parseFALTHeader(String str) {
        this._wantsFalts = true;
        this.readAlternateLocations(str);
    }

    private void parseProxiesHeader(String str) {
        if (this._rfd.getPushAddr() == null || str == null || str.length() < 12) {
            return;
        }
        try {
            PushEndpoint.overwriteProxies(this._rfd.getClientGUID(), str);
            this.updatePEAddress();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updatePEAddress() throws IOException {
        IpPortImpl newAddr = new IpPortImpl(this._socket.getInetAddress().getHostAddress(), this._socket.getPort());
        if (NetworkUtils.isValidExternalIpPort(newAddr)) {
            PushEndpoint.setAddr(this._rfd.getClientGUID(), newAddr);
        }
    }

    public void doDownload(IOStateObserver observer) throws SocketException {
        this._socket.setSoTimeout(60000);
        this.observerHandler.setDelegate(observer);
        this._stateMachine.addState(new DownloadState());
    }

    void createAssertionReport(AssertFailure bad) {
        ManagedDownloader myDownloader;
        String currentWorker = "current worker " + System.identityHashCode(this);
        String allWorkers = null;
        URN urn = this._rfd.getSHA1Urn();
        allWorkers = urn != null ? ((myDownloader = RouterService.getDownloadManager().getDownloaderForURN(urn)) == null ? "couldn't find my downloader???" : myDownloader.getWorkersInfo()) : " sha1 not available ";
        String errorReport = bad.getMessage() + "\n\n" + currentWorker + "\n\n" + allWorkers;
        AssertFailure failure = new AssertFailure(errorReport);
        failure.setStackTrace(bad.getStackTrace());
        throw failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER:" + this + " signaled to stop at " + (this._initialReadingPoint + this._amountRead));
            }
            this._isActive = false;
        }
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                IOUtils.close(HTTPDownloader.this._socket);
            }
        });
    }

    public synchronized void stopAt(int stop) {
        this._disconnect = true;
        this._amountToRead = Math.min(this._amountToRead, stop - this._initialReadingPoint);
    }

    public synchronized void startAt(int start) {
        this._initialWritingPoint = start;
    }

    synchronized void forgetRanges() {
        this._initialWritingPoint = 0;
        this._initialReadingPoint = 0;
        this._amountToRead = 0;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0;
    }

    public synchronized int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public synchronized int getInitialWritingPoint() {
        return this._initialWritingPoint;
    }

    public synchronized int getAmountRead() {
        return this._amountRead;
    }

    public synchronized int getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public synchronized int getAmountToRead() {
        return this._amountToRead;
    }

    public synchronized boolean isActive() {
        return this._isActive;
    }

    synchronized boolean isVictim() {
        return this._disconnect;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public boolean wantsFalts() {
        return this._wantsFalts;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public boolean hasHashTree() {
        return this._thexUri != null && this._root32 != null && !this._rfd.hasTHEXFailed() && !this._thexSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        int totalAmountRead = 0;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (!this._isActive) {
                return;
            }
            totalAmountRead = this.getTotalAmountRead();
        }
        this.bandwidthTracker.measureBandwidth(totalAmountRead);
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public static void setRate(float bytesPerSecond) {
        THROTTLE.setRate(bytesPerSecond);
    }

    public static void applyRate() {
        float downloadRate = Float.MAX_VALUE;
        int downloadThrottle = DownloadSettings.DOWNLOAD_SPEED.getValue();
        if (downloadThrottle < 100) {
            downloadRate = (float)downloadThrottle / 100.0f * ((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f) * 1024.0f;
        }
        HTTPDownloader.setRate(downloadRate);
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    public static void setThrottleSwitching(boolean on) {
    }

    private static class Observer
    implements IOStateObserver {
        private IOStateObserver delegate;
        private boolean handled = false;
        private boolean error = false;

        private Observer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleIOException(IOException iox) {
            IOStateObserver del;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    LOG.warn("Ignoring iox", iox);
                    return;
                }
                this.handled = true;
                del = this.delegate;
            }
            if (del != null) {
                del.handleIOException(iox);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStatesFinished() {
            IOStateObserver del;
            Observer observer = this;
            synchronized (observer) {
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Ignoring states finished", new Exception());
                    }
                    return;
                }
                this.handled = true;
                del = this.delegate;
            }
            if (del != null) {
                del.handleStatesFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            IOStateObserver del;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Ignoring shutdown.");
                    }
                    return;
                }
                this.handled = true;
                del = this.delegate;
            }
            if (del != null) {
                del.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDelegate(IOStateObserver observer) {
            boolean hadError = false;
            Observer observer2 = this;
            synchronized (observer2) {
                this.handled = false;
                hadError = this.error;
                this.delegate = observer;
            }
            if (hadError) {
                observer.shutdown();
            }
        }
    }

    private static class DownloadRestarter
    implements VerifyingFile.WriteCallback {
        private final DownloadState downloader;
        private final InterestReadChannel irc;
        private final ByteBuffer buffer;

        DownloadRestarter(InterestReadChannel irc, ByteBuffer buffer, DownloadState downloader) {
            this.irc = irc;
            this.buffer = buffer;
            this.downloader = downloader;
        }

        public void writeScheduled() {
            LOG.debug("Delayed write scheduled");
            this.buffer.clear();
            this.downloader.writeDone();
            this.irc.interest(true);
        }
    }

    private class DownloadState
    extends ReadState {
        private long currPos;
        private volatile boolean doingWrite;

        private DownloadState() {
            this.currPos = HTTPDownloader.this._initialReadingPoint;
        }

        void writeDone() {
            this.doingWrite = false;
        }

        protected boolean processRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
            if (this.doingWrite) {
                return true;
            }
            boolean dataLeft = false;
            try {
                dataLeft = this.readImpl(channel, buffer);
            }
            catch (IOException error) {
                LOG.debug("Error while reading", error);
                this.chunkCompleted();
                throw error;
            }
            if (!dataLeft) {
                this.chunkCompleted();
                if (!HTTPDownloader.this.isHTTP11() || HTTPDownloader.this._disconnect) {
                    throw new IOException("stolen from");
                }
            }
            return dataLeft;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void chunkCompleted() {
            HTTPDownloader.this._bodyConsumed = true;
            HTTPDownloader hTTPDownloader = HTTPDownloader.this;
            synchronized (hTTPDownloader) {
                HTTPDownloader.this._isActive = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readImpl(ReadableByteChannel rc, ByteBuffer buffer) throws IOException {
            while (true) {
                long filePosition;
                int dataStart;
                int dataLength;
                int left;
                int read = 0;
                HTTPDownloader hTTPDownloader = HTTPDownloader.this;
                synchronized (hTTPDownloader) {
                    if (HTTPDownloader.this._amountRead >= HTTPDownloader.this._amountToRead) {
                        LOG.debug("Read >= to needed, done.");
                        HTTPDownloader.this._isActive = false;
                        return false;
                    }
                    left = HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead;
                }
                int preread = Math.min(left, buffer.position());
                if (preread != 0 && LOG.isDebugEnabled()) {
                    LOG.debug("Using preread data of: " + preread);
                }
                if (left - preread > 0) {
                    if (buffer.limit() > left) {
                        buffer.limit(left);
                    }
                    while (buffer.hasRemaining() && (read = rc.read(buffer)) > 0) {
                    }
                    buffer.limit(buffer.capacity());
                }
                int totalRead = buffer.position();
                if (HTTPDownloader.this._inNetwork) {
                    BandwidthStat.HTTP_BODY_DOWNSTREAM_INNETWORK_BANDWIDTH.addData(totalRead);
                } else {
                    BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.addData(totalRead);
                }
                if (totalRead == 0) {
                    if (read == -1) {
                        LOG.debug("EOF while reading");
                        throw new IOException("EOF");
                    }
                    if (read == 0) {
                        return true;
                    }
                }
                DownloadState downloadState = this;
                synchronized (downloadState) {
                    if (HTTPDownloader.this._isActive) {
                        if ((totalRead = Math.min(totalRead, HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead)) <= 0) {
                            LOG.debug("Someone stole completely from us while reading");
                            HTTPDownloader.this._isActive = false;
                            buffer.clear();
                            return false;
                        }
                        int skipped = Math.min(totalRead, Math.max(0, (int)((long)HTTPDownloader.this._initialWritingPoint - this.currPos)));
                        if (skipped > 0) {
                            LOG.debug("Amount we should skip: " + skipped);
                        }
                        dataLength = totalRead - skipped;
                        dataStart = skipped;
                        filePosition = this.currPos + (long)skipped;
                        HTTPDownloader.this._amountRead += totalRead;
                        this.currPos += (long)totalRead;
                        if (skipped >= totalRead) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("skipped full read of: " + skipped + " bytes");
                            }
                            buffer.clear();
                            continue;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("WORKER:" + this + " stopping at " + (HTTPDownloader.this._initialReadingPoint + HTTPDownloader.this._amountRead));
                        }
                        buffer.clear();
                        return false;
                    }
                }
                try {
                    if (!HTTPDownloader.this._incompleteFile.writeBlock(filePosition, dataStart, dataLength, buffer.array())) {
                        LOG.debug("Scheduling callback for write.");
                        InterestReadChannel irc = (InterestReadChannel)rc;
                        irc.interest(false);
                        this.doingWrite = true;
                        HTTPDownloader.this._incompleteFile.writeBlockWithCallback(filePosition, dataStart, dataLength, buffer.array(), new DownloadRestarter(irc, buffer, this));
                        return true;
                    }
                }
                catch (AssertFailure bad) {
                    HTTPDownloader.this.createAssertionReport(bad);
                }
                buffer.clear();
            }
        }

        public long getAmountProcessed() {
            return -1L;
        }
    }
}

