/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.PingRanker;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.util.Collection;
import java.util.Iterator;

public abstract class SourceRanker {
    protected MeshHandler meshHandler;

    public boolean addToPool(Collection hosts) {
        boolean ret = false;
        Iterator iter = hosts.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc host = (RemoteFileDesc)iter.next();
            if (!this.addToPool(host)) continue;
            ret = true;
        }
        return ret;
    }

    public abstract boolean addToPool(RemoteFileDesc var1);

    public abstract boolean hasMore();

    public abstract RemoteFileDesc getBest();

    protected abstract Collection getShareableHosts();

    public abstract int getNumKnownHosts();

    public synchronized boolean hasNonBusy() {
        return this.getNumKnownHosts() > this.getNumBusyHosts();
    }

    public synchronized int getNumBusyHosts() {
        int ret = 0;
        long now = System.currentTimeMillis();
        Iterator iter = this.getPotentiallyBusyHosts().iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (!rfd.isBusy(now)) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized int calculateWaitTime() {
        if (!this.hasMore()) {
            return 0;
        }
        int waitTime = Integer.MAX_VALUE;
        long now = System.currentTimeMillis();
        Iterator iter = this.getPotentiallyBusyHosts().iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (!rfd.isBusy(now)) continue;
            waitTime = Math.min(waitTime, rfd.getWaitTime(now));
        }
        return waitTime * 1000;
    }

    protected abstract Collection getPotentiallyBusyHosts();

    public synchronized void stop() {
        this.clearState();
        this.meshHandler = null;
    }

    protected void clearState() {
    }

    public static SourceRanker getAppropriateRanker() {
        if (RouterService.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            return new PingRanker();
        }
        return new LegacyRanker();
    }

    public static SourceRanker getAppropriateRanker(SourceRanker original) {
        SourceRanker better;
        if (original == null) {
            return SourceRanker.getAppropriateRanker();
        }
        if (RouterService.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            if (original instanceof PingRanker) {
                return original;
            }
            better = new PingRanker();
        } else {
            if (original instanceof LegacyRanker) {
                return original;
            }
            better = new LegacyRanker();
        }
        better.setMeshHandler(original.getMeshHandler());
        better.addToPool(original.getShareableHosts());
        original.stop();
        return better;
    }

    public synchronized void setMeshHandler(MeshHandler handler) {
        this.meshHandler = handler;
    }

    public synchronized MeshHandler getMeshHandler() {
        return this.meshHandler;
    }
}

