/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.IP;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IPList {
    private List ips = new LinkedList();

    public void add(String ip_str) {
        IP ip;
        try {
            ip = new IP(ip_str);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (!this.ips.contains(ip)) {
            this.ips.add(ip);
        }
    }

    public boolean contains(IP ip) {
        Iterator iter = this.ips.iterator();
        while (iter.hasNext()) {
            IP pattern = (IP)iter.next();
            if (!pattern.contains(ip)) continue;
            return true;
        }
        return false;
    }

    public int logMinDistanceTo(IP ip) {
        int distance = this.minDistanceTo(ip);
        int logDistance = 0;
        int testMask = -1;
        while ((distance & testMask) != 0) {
            testMask <<= 1;
            ++logDistance;
        }
        return logDistance;
    }

    public int minDistanceTo(IP ip) {
        if (ip.getMask() != -1) {
            throw new IllegalArgumentException("Expected single IP, not an IP range.");
        }
        int min_distance = Integer.MAX_VALUE;
        Iterator iter = this.ips.iterator();
        while (iter.hasNext()) {
            IP ipRange = (IP)iter.next();
            int distance = Integer.MIN_VALUE ^ ipRange.getDistanceTo(ip);
            if (min_distance <= distance) continue;
            min_distance = distance;
        }
        return Integer.MIN_VALUE ^ min_distance;
    }
}

