/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryRequest;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class OnDemandUnicaster {
    private static final int CLEAR_TIME = 300000;
    private static final Map _queryKeys = new Hashtable();
    private static final UDPService _udp;
    private static final Map _bufferedURNs;

    public static void handleQueryKeyPong(PingReply pr) throws NullPointerException, IllegalArgumentException {
        if (pr == null) {
            throw new NullPointerException("null pong");
        }
        QueryKey qk = pr.getQueryKey();
        if (qk == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress address = pr.getInetAddress();
        int port = pr.getPort();
        GUESSEndpoint endpoint = new GUESSEndpoint(address, port);
        _queryKeys.put(endpoint, qk);
        SendLaterBundle bundle = (SendLaterBundle)_bufferedURNs.remove(endpoint);
        if (bundle != null) {
            QueryRequest query = QueryRequest.createQueryKeyQuery(bundle._queryURN, qk);
            RouterService.getMessageRouter().originateQueryGUID(query.getGUID());
            _udp.send(query, endpoint.getAddress(), endpoint.getPort());
        }
    }

    public static void query(GUESSEndpoint ep, URN queryURN) throws IllegalArgumentException {
        if (ep == null) {
            throw new IllegalArgumentException("No Endpoint!");
        }
        if (queryURN == null) {
            throw new IllegalArgumentException("No urn to look for!");
        }
        QueryKey key = (QueryKey)_queryKeys.get(ep);
        if (key == null) {
            GUESSEndpoint endpoint = new GUESSEndpoint(ep.getAddress(), ep.getPort());
            SendLaterBundle bundle = new SendLaterBundle(queryURN);
            _bufferedURNs.put(endpoint, bundle);
            PingRequest pr = PingRequest.createQueryKeyRequest();
            _udp.send(pr, ep.getAddress(), ep.getPort());
        } else {
            QueryRequest query = QueryRequest.createQueryKeyQuery(queryURN, key);
            RouterService.getMessageRouter().originateQueryGUID(query.getGUID());
            _udp.send(query, ep.getAddress(), ep.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean clearDataStructures(long lastQueryKeyClearTime, long queryKeyClearInterval) throws Throwable {
        boolean clearedQueryKeys = false;
        if (System.currentTimeMillis() - lastQueryKeyClearTime > queryKeyClearInterval) {
            clearedQueryKeys = true;
            _queryKeys.clear();
        }
        Map map = _bufferedURNs;
        synchronized (map) {
            Iterator iter = _bufferedURNs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                SendLaterBundle bundle = (SendLaterBundle)entry.getValue();
                if (!bundle.shouldExpire()) continue;
                iter.remove();
            }
        }
        return clearedQueryKeys;
    }

    static {
        _bufferedURNs = new Hashtable();
        _udp = UDPService.instance();
        RouterService.schedule(new Expirer(), 300000L, 300000L);
    }

    private static class Expirer
    implements Runnable {
        private static final int QUERY_KEY_CLEAR_TIME = 86400000;
        private long _lastQueryKeyClearTime = System.currentTimeMillis();

        public void run() {
            try {
                if (OnDemandUnicaster.clearDataStructures(this._lastQueryKeyClearTime, 86400000L)) {
                    this._lastQueryKeyClearTime = System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private static class SendLaterBundle {
        private static final int MAX_LIFETIME = 60000;
        public final URN _queryURN;
        private final long _creationTime;

        public SendLaterBundle(URN urn) {
            this._queryURN = urn;
            this._creationTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._creationTime > 60000L;
        }
    }
}

