/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.guess.QueryKeyGenerator;
import com.limegroup.gnutella.guess.TEAQueryKeyGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryKey {
    private static final Log LOG = LogFactory.getLog(QueryKey.class);
    private static QueryKeyGenerator secretKey = null;
    private static QueryKeyGenerator oldSecretKey = null;
    public static final int MIN_QK_SIZE_IN_BYTES = 4;
    public static final int MAX_QK_SIZE_IN_BYTES = 16;
    private byte[] _queryKey;
    private final int _hashCode;

    private QueryKey(byte[] key, boolean prepareForNet) throws IllegalArgumentException {
        if (!QueryKey.isValidQueryKeyBytes(key)) {
            throw new IllegalArgumentException();
        }
        key = (byte[])key.clone();
        if (prepareForNet) {
            for (int i = key.length - 1; i >= 0; --i) {
                if (key[i] != 28) continue;
                key[i] = -6;
            }
        }
        int code = 0x5A5A5A5A;
        for (int i = key.length - 1; i >= 0; --i) {
            code ^= 0xFF & key[i];
            code *= (code << 1) + 1;
            code = code >>> 27 | code << 5;
        }
        this._queryKey = key;
        this._hashCode = code;
    }

    public boolean isFor(SocketAddress address) {
        InetAddress ip = ((InetSocketAddress)address).getAddress();
        int port = ((InetSocketAddress)address).getPort();
        return this.isFor(ip, port);
    }

    public boolean isFor(InetAddress ip, int port) {
        if (secretKey.checkKeyBytes(this._queryKey, ip, port)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QueryKey valid:" + this);
            }
            return true;
        }
        if (oldSecretKey.checkKeyBytes(this._queryKey, ip, port)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QueryKey old but valid:" + this);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("QueryKey corrupt or expired:" + this);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o.hashCode() != this._hashCode) {
            return false;
        }
        if (!(o instanceof QueryKey)) {
            return false;
        }
        QueryKey other = (QueryKey)o;
        return Arrays.equals(this._queryKey, other._queryKey);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this._queryKey);
    }

    public byte[] getBytes() {
        byte[] b = new byte[this._queryKey.length];
        System.arraycopy(this._queryKey, 0, b, 0, this._queryKey.length);
        return b;
    }

    public String toString() {
        return "{Query Key: " + new BigInteger(1, this._queryKey).toString(16) + "}";
    }

    public static boolean isValidQueryKeyBytes(byte[] key) {
        return key != null && key.length >= 4 && key.length <= 16;
    }

    public static QueryKey getQueryKey(byte[] networkQK, boolean prepareForNet) throws IllegalArgumentException {
        return new QueryKey(networkQK, prepareForNet);
    }

    public static QueryKey getQueryKey(SocketAddress address) {
        InetAddress ip = ((InetSocketAddress)address).getAddress();
        int port = ((InetSocketAddress)address).getPort();
        return QueryKey.getQueryKey(ip, port);
    }

    public static QueryKey getQueryKey(InetAddress ip, int port) {
        return new QueryKey(secretKey.getKeyBytes(ip, port), true);
    }

    public static QueryKey getQueryKey(InetAddress ip, int port, QueryKeyGenerator keyGen) {
        return new QueryKey(keyGen.getKeyBytes(ip, port), true);
    }

    public static QueryKeyGenerator createKeyGenerator() {
        return new TEAQueryKeyGenerator();
    }

    static {
        oldSecretKey = secretKey = QueryKey.createKeyGenerator();
    }
}

