/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.UISettings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ButtonIconController {
    private Object NULL = new Object();
    private final Properties BUTTON_NAMES = ButtonIconController.loadButtonNameMap();
    private final Map BUTTON_CACHE = new HashMap();

    public void wipeButtonIconCache() {
        this.BUTTON_CACHE.clear();
    }

    public Icon getIconForButton(String buttonName) {
        String fileName = (String)this.BUTTON_NAMES.get(buttonName);
        if (fileName == null) {
            return null;
        }
        ImageIcon icon = (ImageIcon)this.BUTTON_CACHE.get(fileName);
        if (icon == this.NULL) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        try {
            String retrieveName = UISettings.SMALL_ICONS.getValue() ? fileName + "_small" : fileName + "_large";
            icon = ResourceManager.getThemeImage(retrieveName);
            this.BUTTON_CACHE.put(fileName, icon);
        }
        catch (MissingResourceException mre) {
            try {
                icon = ResourceManager.getThemeImage(fileName);
                this.BUTTON_CACHE.put(fileName, icon);
            }
            catch (MissingResourceException mre2) {
                this.BUTTON_CACHE.put(fileName, this.NULL);
            }
        }
        return icon;
    }

    public Icon getRolloverIconForButton(String buttonName) {
        String fileName = (String)this.BUTTON_NAMES.get(buttonName);
        if (fileName == null) {
            return null;
        }
        String rolloverName = fileName + "_rollover";
        Icon rollover = (Icon)this.BUTTON_CACHE.get(rolloverName);
        if (rollover == this.NULL) {
            return null;
        }
        if (rollover != null) {
            return rollover;
        }
        Icon icon = (Icon)this.BUTTON_CACHE.get(fileName);
        if (icon == this.NULL || icon == null) {
            this.BUTTON_CACHE.put(rolloverName, this.NULL);
            return null;
        }
        rollover = ImageManipulator.brighten(icon);
        if (rollover == null) {
            this.BUTTON_CACHE.put(rolloverName, this.NULL);
        } else {
            this.BUTTON_CACHE.put(rolloverName, rollover);
        }
        return rollover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadButtonNameMap() {
        BufferedInputStream is;
        Properties p;
        block8: {
            p = new Properties();
            URL url = ResourceManager.getURLResource("icon_mapping.properties");
            is = null;
            if (url == null) break block8;
            is = new BufferedInputStream(url.openStream());
            p.load(is);
        }
        Object var5_3 = null;
        if (is == null) return p;
        try {
            ((InputStream)is).close();
            return p;
        }
        catch (IOException ignored) {}
        return p;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (is == null) return p;
                try {
                    ((InputStream)is).close();
                    return p;
                }
                catch (IOException ignored) {}
                return p;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

