/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.StatusComponent;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public final class SplashWindow
extends JWindow {
    private static final StatusComponent GLASS_PANE = new StatusComponent(1);
    private static final JLabel splashLabel = new JLabel();
    private static final SplashWindow INSTANCE = new SplashWindow();

    public static SplashWindow instance() {
        return INSTANCE;
    }

    private SplashWindow() {
        ImageIcon splashIcon = ResourceManager.getThemeImage(CommonUtils.isPro() ? "splashpro" : "splash");
        Image image = splashIcon.getImage();
        Dimension size = new Dimension(image.getWidth(null) + 2, image.getHeight(null) + 2);
        this.setSize(size);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
        splashLabel.setIcon(splashIcon);
        this.getContentPane().add((Component)splashLabel, "Center");
        this.setGlassPane(GLASS_PANE);
        this.pack();
    }

    public void begin() {
        this.toFront();
        this.setVisible(true);
        GLASS_PANE.setVisible(true);
    }

    public static void setStatusText(final String text) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                GLASS_PANE.setText(text);
            }
        });
    }

    public static void refreshImage() {
        ImageIcon splashIcon = ResourceManager.getThemeImage("splash");
        splashLabel.setIcon(splashIcon);
        GLASS_PANE.setVisible(false);
        INSTANCE.pack();
        splashLabel.paintImmediately(0, 0, splashLabel.getWidth(), splashLabel.getHeight());
    }

    static {
        GLASS_PANE.add(Box.createVerticalGlue(), 0);
        GLASS_PANE.add(GUIMediator.getVerticalSeparator());
        GLASS_PANE.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }
}

