/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.InputFieldDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class StandardListEditor {
    private final JPanel MAIN_PANEL = new JPanel(new GridBagLayout());
    private final JList LIST = new JList();
    private final JButton REMOVE_BUTTON;
    private final JButton ADD_BUTTON;
    private AddAction _addAction;
    private RemoveAction _removeAction;
    private ActionListener _addListener = null;
    private boolean _listChanged = false;

    public StandardListEditor(String INPUT_FIELD_KEY) {
        this("LIST_EDITOR_ADD_BUTTON", "LIST_EDITOR_REMOVE_BUTTON", INPUT_FIELD_KEY);
    }

    public StandardListEditor(ActionListener listener) {
        this("LIST_EDITOR_ADD_BUTTON", "LIST_EDITOR_REMOVE_BUTTON", "");
        this.setAddActionListener(listener);
    }

    public StandardListEditor(String ADD_BUTTON_KEY, String REMOVE_BUTTON_KEY, String INPUT_FIELD_KEY) {
        this._addAction = new AddAction(ADD_BUTTON_KEY, INPUT_FIELD_KEY);
        this._removeAction = new RemoveAction(REMOVE_BUTTON_KEY);
        GUIUtils.bindKeyToAction(this.LIST, KeyStroke.getKeyStroke(127, 0), this._removeAction);
        this.LIST.setSelectionMode(0);
        this.LIST.addListSelectionListener(new ListEditorSelectionListener());
        JScrollPane scrollPane = new JScrollPane(this.LIST);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.MAIN_PANEL.add((Component)scrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 3, 6, 0);
        this.ADD_BUTTON = new JButton(this._addAction);
        this.MAIN_PANEL.add((Component)this.ADD_BUTTON, gbc);
        this.REMOVE_BUTTON = new JButton(this._removeAction);
        this.REMOVE_BUTTON.setEnabled(false);
        this.MAIN_PANEL.add((Component)this.REMOVE_BUTTON, gbc);
    }

    public Component getComponent() {
        return this.MAIN_PANEL;
    }

    private void addElement(Object element) {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        model.addElement(element);
    }

    public void addFile(File file) {
        this.addElement(file);
    }

    public void addString(String string) {
        this.addElement(string);
    }

    public void setListData(Vector data) {
        DefaultListModel model = new DefaultListModel();
        for (int i = 0; i < data.size(); ++i) {
            model.addElement(data.get(i));
        }
        this.LIST.setModel(model);
    }

    private void setListDataObjects(Object[] data) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (int i = 0; i < data.length; ++i) {
            model.addElement(data[i]);
        }
        this.LIST.setModel(model);
    }

    public void setListData(File[] data) {
        this.setListDataObjects(data);
    }

    public void setListData(String[] data) {
        this.setListDataObjects(data);
    }

    public void clearSelection() {
        this.LIST.clearSelection();
    }

    public String[] getDataAsStringArray() {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        Object[] dataObjects = model.toArray();
        String[] dataStrings = new String[dataObjects.length];
        for (int i = 0; i < dataObjects.length; ++i) {
            dataStrings[i] = dataObjects[i].toString();
        }
        return dataStrings;
    }

    public File[] getDataAsFileArray() {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        Object[] dataObjects = model.toArray();
        File[] dataFiles = new File[dataObjects.length];
        for (int i = 0; i < dataObjects.length; ++i) {
            dataFiles[i] = (File)dataObjects[i];
        }
        return dataFiles;
    }

    public Object[] getDataAsObjectArray() {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        return model.toArray();
    }

    private void setAddActionListener(ActionListener addListener) {
        this._addListener = addListener;
    }

    public boolean getListChanged() {
        return this._listChanged;
    }

    public void resetList() {
        this._listChanged = false;
    }

    private class ListEditorSelectionListener
    implements ListSelectionListener {
        private ListEditorSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
            } else {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(true);
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction(String name) {
            this.putValue("Name", GUIMediator.getStringResource(name));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIST_EDITOR_REMOVE_BUTTON_TIP"));
        }

        public void actionPerformed(ActionEvent e) {
            StandardListEditor.this._listChanged = true;
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                return;
            }
            DefaultListModel model = (DefaultListModel)StandardListEditor.this.LIST.getModel();
            model.remove(StandardListEditor.this.LIST.getSelectedIndex());
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private final String INPUT_FIELD_KEY;

        public AddAction(String name, String key) {
            this.putValue("Name", GUIMediator.getStringResource(name));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIST_EDITOR_ADD_BUTTON_TIP"));
            this.INPUT_FIELD_KEY = key;
        }

        public void actionPerformed(ActionEvent e) {
            if (StandardListEditor.this._addListener != null) {
                StandardListEditor.this._addListener.actionPerformed(e);
            } else {
                InputFieldDialog dialog = new InputFieldDialog(this.INPUT_FIELD_KEY);
                int returnCode = dialog.showDialog();
                if (returnCode == 79) {
                    StandardListEditor.this._listChanged = true;
                    StandardListEditor.this.addElement(dialog.getText());
                }
            }
        }
    }
}

