/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.metal.MetalLabelUI;

final class StatusLinkHandler {
    private final LabelURLPair[] LABEL_URLS = new LabelURLPair[]{new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_01"), "http://www.limewire.com/index.jsp/pro&21"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_02"), "http://www.limewire.com/index.jsp/pro&22"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_03"), "http://www.limewire.com/index.jsp/pro&23"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_04"), "http://www.limewire.com/index.jsp/pro&24"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_05"), "http://www.limewire.com/index.jsp/pro&25"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_06"), "http://www.limewire.com/index.jsp/pro&26"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_07"), "http://www.limewire.com/index.jsp/pro&27"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_08"), "http://www.limewire.com/index.jsp/pro&28"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_09"), "http://www.limewire.com/index.jsp/pro&29")};
    private int _curLabelIndex = 0;
    private final JLabel LABEL = new JLabel("", 0);

    StatusLinkHandler() {
        this.LABEL.setUI(new LinkLabelUI());
        FontMetrics fm = this.LABEL.getFontMetrics(this.LABEL.getFont());
        int width = fm.stringWidth("123456789/123456789/1");
        if (this.LABEL_URLS != null) {
            int i = this.LABEL_URLS.length;
            while (--i >= 0) {
                width = Math.max(width, fm.stringWidth(this.LABEL_URLS[i].getLabel()));
            }
        }
        Dimension dim = new Dimension(width, fm.getHeight());
        this.LABEL.setForeground(Color.blue);
        this.LABEL.setPreferredSize(dim);
        this.LABEL.setMaximumSize(dim);
        this.LABEL.setText(this.getNextLabelURLPair().getLabel());
        this.LABEL.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                StatusLinkHandler.this.handleLinkClick();
            }

            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        });
        if (this.LABEL_URLS.length > 1) {
            new Timer(30000, new LabelTimerListener()).start();
        }
    }

    Component getComponent() {
        return this.LABEL;
    }

    private LabelURLPair getNextLabelURLPair() {
        if (this._curLabelIndex == this.LABEL_URLS.length - 1) {
            this._curLabelIndex = -1;
        }
        ++this._curLabelIndex;
        return this.LABEL_URLS[this._curLabelIndex];
    }

    private void handleLinkChange() {
        String label = this.getNextLabelURLPair().getLabel();
        this.LABEL.setText(label);
        FontMetrics fm = this.LABEL.getFontMetrics(this.LABEL.getFont());
        int width = fm.stringWidth(label);
        int height = fm.getHeight();
        Dimension preferred = new Dimension(width, height);
        this.LABEL.setPreferredSize(preferred);
        GUIMediator.instance().getStatusLine().refresh();
    }

    private void handleLinkClick() {
        GUIMediator.openURL(this.LABEL_URLS[this._curLabelIndex].getURL());
    }

    private class LinkLabelUI
    extends MetalLabelUI {
        private LinkLabelUI() {
        }

        protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
            super.paintEnabledText(l, g, s, textX, textY);
            if (StatusLinkHandler.this.LABEL.getText() == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            g.fillRect(textX, fm.getAscent() + 2, fm.stringWidth(StatusLinkHandler.this.LABEL.getText()) - ((StatusLinkHandler)StatusLinkHandler.this).LABEL.getInsets().right, 1);
        }
    }

    private static final class LabelURLPair {
        private final String LABEL_STRING;
        private final String URL;

        private LabelURLPair(String label, String url) {
            this.LABEL_STRING = label;
            this.URL = url;
        }

        private String getLabel() {
            return this.LABEL_STRING;
        }

        private String getURL() {
            return this.URL;
        }
    }

    private class LabelTimerListener
    implements ActionListener {
        private LabelTimerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusLinkHandler.this.handleLinkChange();
        }
    }
}

