/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.apache.commons.httpclient.URI;

public class URLLabel
extends JLabel {
    private final String url;
    private String display;

    public URLLabel(URL url, String display) {
        this(url.toExternalForm(), display);
    }

    public URLLabel(URI uri, String display) {
        this(uri.toString(), display);
    }

    public URLLabel(String url) {
        this(url, url);
    }

    public URLLabel(String url, String display) {
        super("<html><a href=\"" + url + "\">" + display + "</a></html");
        this.addMouseListener(GUIUtils.getURLInputListener(url));
        this.setToolTipText(url);
        this.url = url;
        this.display = display;
        this.setPreferredSize(this.buildPreferredSize(display));
    }

    public URLLabel(String url, Icon icon) {
        super(icon);
        this.addMouseListener(GUIUtils.getURLInputListener(url));
        this.setToolTipText(url);
        this.url = url;
        this.display = null;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.display != null) {
            this.setPreferredSize(this.buildPreferredSize(this.display));
        }
    }

    private Dimension buildPreferredSize(String display) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return new Dimension(fm.stringWidth(display) + 3, fm.getHeight());
    }
}

