/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.version.UpdateInformation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

final class UpdateDialog
extends JDialog {
    public UpdateDialog(UpdateInformation info) {
        super(GUIMediator.getAppFrame());
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(GUIMediator.getStringResource("UPDATE_DIALOG_CAPTION"));
        JButton button = this.buildContentArea(info);
        this.pack();
        Dimension size = new Dimension(500, 300);
        this.setSize(size);
        ((JComponent)this.getContentPane()).setPreferredSize(size);
        this.getRootPane().setDefaultButton(button);
        button.requestFocus();
        this.setLocation(GUIMediator.getScreenCenterPoint(this));
    }

    private JButton buildContentArea(UpdateInformation info) {
        URLLabel icon = new URLLabel(info.getUpdateURL(), this.getUpdateIcon());
        JComponent title = this.makeText(this.getUpdateTitle(info.getUpdateTitle()), false);
        JComponent text = this.makeText(info.getUpdateText(), true);
        JButton button1 = this.makeButton1(info);
        JButton button2 = this.makeButton2(info);
        JComponent jc = (JComponent)this.getContentPane();
        jc.setLayout(new GridBagLayout());
        jc.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gc = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        gc.gridwidth = -1;
        gc.insets = new Insets(0, 0, 0, 5);
        p.add((Component)icon, gc);
        gc.gridwidth = 0;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 0, 0);
        p.add((Component)title, gc);
        jc.add((Component)p, gc);
        gc.fill = 1;
        gc.anchor = 10;
        gc.insets = new Insets(5, 0, 5, 0);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        jc.add((Component)text, gc);
        p = new JPanel(new GridBagLayout());
        gc.gridwidth = -1;
        gc.fill = 0;
        gc.insets = new Insets(0, 0, 0, 3);
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.anchor = 13;
        p.add((Component)button1, gc);
        gc.gridwidth = 0;
        gc.anchor = 17;
        gc.insets = new Insets(0, 3, 0, 0);
        p.add((Component)button2, gc);
        gc.insets = new Insets(0, 0, 0, 0);
        gc.anchor = 10;
        jc.add((Component)p, gc);
        return button1;
    }

    private String getUpdateTitle(String title) {
        if (title != null) {
            return "<b>" + title + "</b>";
        }
        return "<b>" + GUIMediator.getStringResource("UPDATE_TITLE") + "</b>";
    }

    private Icon getUpdateIcon() {
        return GUIMediator.getThemeImage("searching");
    }

    private JComponent makeText(String text, boolean scroll) {
        JEditorPane pane = new JEditorPane();
        JLabel dummy = new JLabel();
        pane.setContentType("text/html");
        pane.setEditable(false);
        pane.setBackground(dummy.getBackground());
        pane.setFont(dummy.getFont());
        pane.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        text = this.updateForeground(dummy.getForeground(), text);
        pane.setText(text);
        pane.setCaretPosition(0);
        if (!scroll) {
            return pane;
        }
        JScrollPane scroller = new JScrollPane(pane);
        scroller.setPreferredSize(new Dimension(400, 100));
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setBorder(null);
        return scroller;
    }

    private String updateForeground(Color color, String html) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String hex = this.toHex(r) + this.toHex(g) + this.toHex(b);
        return "<html><body text='#" + hex + "'>" + html + "</body></html>";
    }

    private String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    private JButton makeButton1(final UpdateInformation info) {
        String text = info.getButton1Text();
        if (text == null) {
            text = GUIMediator.getStringResource("UPDATE_NOW_LABEL");
        }
        JButton b = new JButton(text);
        b.setToolTipText(GUIMediator.getStringResource("UPDATE_TIP"));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String updateCommand = info.getUpdateCommand();
                if (updateCommand != null) {
                    GUIMediator.flagUpdate(updateCommand);
                    int restartNow = GUIMediator.showYesNoTitledMessage("UPDATE_RESTART", "UPDATE_RESTART_TITLE");
                    if (restartNow == 101) {
                        GUIMediator.shutdown();
                    }
                } else {
                    GUIMediator.openURL(info.getUpdateURL());
                }
                UpdateDialog.this.setVisible(false);
                UpdateDialog.this.dispose();
            }
        });
        return b;
    }

    private JButton makeButton2(UpdateInformation info) {
        String text = info.getButton2Text();
        if (text == null) {
            text = GUIMediator.getStringResource("UPDATE_LATER_LABEL");
        }
        JButton b = new JButton(text);
        b.setToolTipText(GUIMediator.getStringResource("UPDATE_TIP"));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateDialog.this.setVisible(false);
                UpdateDialog.this.dispose();
            }
        });
        return b;
    }
}

