/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class CopyMagnetLinkToClipboardAction
extends AbstractAction {
    private FileDetailsProvider provider;

    public CopyMagnetLinkToClipboardAction(FileDetailsProvider provider) {
        this.provider = provider;
        this.putValue("Name", GUIMediator.getStringResource("MAGNET_COPY_MAGNET_LINKS_LABEL"));
        this.putValue("ShortDescription", GUIMediator.getStringResource("MAGNET_COPY_MAGNET_LINKS_TOOLTIP"));
    }

    public void actionPerformed(ActionEvent e) {
        this.setClipboardString();
    }

    private void setClipboardString() {
        FileDetails[] files = this.provider.getFileDetails();
        StringBuffer buffer = new StringBuffer();
        boolean isFirewalled = false;
        String sep = System.getProperty("line.separator");
        for (int i = 0; i < files.length; ++i) {
            MagnetOptions magnet;
            if (buffer.length() > 0) {
                buffer.append(sep);
            }
            if (!(magnet = MagnetOptions.createMagnet(files[i])).isDownloadable()) continue;
            isFirewalled |= files[i].isFirewalled();
            buffer.append(magnet.toExternalForm());
        }
        String text = buffer.toString();
        MagnetClipboardListener.getInstance().setCopiedText(text);
        StringSelection sel = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
        if (isFirewalled) {
            GUIMediator.showWarning("MAGNET_COPY_MAGNET_LINKS_WARNING", QuestionsHandler.FIREWALLED_MAGNET_LINK);
        }
    }
}

