/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MessageService;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class ShareFileSpeciallyAction
extends AbstractAction {
    public ShareFileSpeciallyAction() {
        this.putValue("Name", GUIMediator.getStringResource("SHARE_FILE_ACTION_NAME"));
        this.putValue("ShortDescription", "Opens a Dialog and Lets You Choose a File to Share");
        String mnemonic = GUIMediator.getStringResource("SHARE_FILE_ACTION_MNEMONIC");
        if (mnemonic.length() > 0) {
            this.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
        }
    }

    public void actionPerformed(ActionEvent e) {
        final File toShare = FileChooserHandler.getInputFile(MessageService.getParentComponent(), "SHARE_FILE_ACTION_NAME", "SHARE_FILE_ACTION_APPROVE_LABEL", null);
        if (toShare != null) {
            GUIMediator.instance().schedule(new Runnable(){

                public void run() {
                    RouterService.getFileManager().addFileAlways(toShare, new Listener());
                }
            });
        }
    }

    private static class Listener
    implements FileEventListener {
        private Listener() {
        }

        public void handleFileEvent(FileManagerEvent fev) {
            GUIMediator.safeInvokeLater(new Runnable(this, fev){
                private final /* synthetic */ FileManagerEvent val$fev;
                private final /* synthetic */ Listener this$0;
                {
                    this.this$0 = this$0;
                    this.val$fev = val$fev;
                }

                public void run() {
                    if (this.val$fev.isAlreadySharedEvent()) {
                        GUIMediator.showFormattedError("SHARE_FILE_ALREADY_SHARED", new Object[]{this.val$fev.getFiles()[0]});
                    } else if (!this.val$fev.isAddEvent()) {
                        GUIMediator.showFormattedError("SHARE_FILE_FAILED", new Object[]{this.val$fev.getFiles()[0]});
                    }
                }
            });
        }
    }
}

