/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.download.DownloaderDialog;
import com.limegroup.gnutella.gui.download.DownloaderFactory;
import com.limegroup.gnutella.gui.download.MagnetDownloaderFactory;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class DownloaderUtils {
    public static Downloader createDownloader(DownloaderFactory factory) {
        if (DownloaderUtils.isAlreadyDownloading(factory)) {
            return null;
        }
        if (!DownloaderUtils.isSaveLocationTaken(factory) && !DownloaderUtils.continueWithOrWithoutHashConflict(factory)) {
            return null;
        }
        return DownloaderUtils.createDownloader(factory, false);
    }

    public static Downloader createDownloaderAs(DownloaderFactory factory) {
        if (DownloaderUtils.isAlreadyDownloading(factory)) {
            return null;
        }
        if (!DownloaderUtils.continueWithOrWithoutHashConflict(factory)) {
            return null;
        }
        File file = DownloaderUtils.showFileChooser(factory, MessageService.getParentComponent());
        if (file == null) {
            return null;
        }
        factory.setSaveFile(file);
        return DownloaderUtils.createDownloader(factory, CommonUtils.isAnyMac());
    }

    public static Downloader createDownloader(MagnetOptions magnet) {
        String msg = magnet.getErrorMessage();
        if (!magnet.isDownloadable()) {
            if (msg == null) {
                msg = magnet.toString();
            }
            GUIMediator.showError("ERROR_BAD_MAGNET_LINK", msg);
            return null;
        }
        if (msg != null) {
            GUIMediator.showWarning("ERROR_INVALID_URLS_IN_MAGNET");
        }
        MagnetDownloaderFactory factory = new MagnetDownloaderFactory(magnet);
        if (magnet.getDisplayName() == null) {
            Downloader dl = DownloaderUtils.createDownloaderAs(factory);
            if (dl != null && magnet.isHashOnly()) {
                GUIMediator.showError("DOWNLOAD_HASH_ONLY_MAGNET");
            }
            return dl;
        }
        return DownloaderUtils.createDownloader(factory);
    }

    public static Downloader createDownloader(DownloaderFactory factory, boolean overwrite) {
        try {
            return factory.createDownloader(overwrite);
        }
        catch (SaveLocationException sle) {
            return DownloaderDialog.handle(factory, sle);
        }
    }

    public static boolean isAlreadyDownloading(DownloaderFactory factory) {
        if (RouterService.getDownloadManager().conflicts(factory.getURN(), factory.getSaveFile().getName(), factory.getFileSize())) {
            DownloaderUtils.showIsAlreadyDownloadingWarning(factory);
            return true;
        }
        return false;
    }

    public static void showIsAlreadyDownloadingWarning(DownloaderFactory factory) {
        GUIMediator.showFormattedError("FORMATTED_ERROR_ALREADY_DOWNLOADING", new Object[]{factory.getSaveFile()}, QuestionsHandler.ALREADY_DOWNLOADING);
    }

    public static FileDesc getFromLibrary(URN urn) {
        if (urn == null) {
            return null;
        }
        FileDesc desc = RouterService.getFileManager().getFileDescForUrn(urn);
        return desc instanceof IncompleteFileDesc ? null : desc;
    }

    public static boolean continueWithOrWithoutHashConflict(DownloaderFactory factory) {
        FileDesc desc = DownloaderUtils.getFromLibrary(factory.getURN());
        if (desc != null) {
            return DownloaderUtils.showHashConflict(desc);
        }
        return true;
    }

    private static boolean showHashConflict(FileDesc desc) {
        String message = MessageFormat.format(GUIMediator.getStringResource("DOWNLOADER_UTILS_HASH_CONFLICT_MESSAGE"), desc.getFile());
        String question = GUIMediator.getStringResource("DOWNLOADER_UTILS_HASH_CONFLICT_QUESTION");
        String continueLabel = GUIMediator.getStringResource("DOWNLOADER_UTILS_HASH_CONFLICT_CONTINUE_LABEL");
        String[] content = new String[]{message, question};
        JOptionPane pane = new JOptionPane(content, 3, 0, null, new String[]{continueLabel, GUIMediator.getStringResource("GENERAL_CANCEL_BUTTON_LABEL")});
        JDialog dialog = pane.createDialog(MessageService.getParentComponent(), GUIMediator.getStringResource("DOWNLOADER_UTILS_ALREADY_IN_LIBRARY"));
        dialog.setVisible(true);
        return continueLabel.equals(pane.getValue());
    }

    public static File showFileChooser(DownloaderFactory factory, Component c) {
        return FileChooserHandler.getSaveAsFile(c, "DOWNLOADER_UTILS_FILECHOOSER_TITLE", factory.getSaveFile());
    }

    private static boolean isSaveLocationTaken(DownloaderFactory factory) {
        return factory.getSaveFile().exists() || RouterService.getDownloadManager().isSaveLocationTaken(factory.getSaveFile());
    }
}

