/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.download.DownloaderFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;

public class MagnetDownloaderFactory
implements DownloaderFactory {
    private MagnetOptions magnet;
    private File saveFile;

    public MagnetDownloaderFactory(MagnetOptions magnet) {
        this.magnet = magnet;
        String fileName = magnet.getFileNameForSaving();
        if (fileName == null) {
            fileName = GUIMediator.getStringResource("NO_FILENAME_LABEL");
        }
        this.saveFile = new File(SharingSettings.getSaveDirectory(), fileName);
        if (!magnet.isDownloadable()) {
            throw new IllegalArgumentException("Invalid magnet");
        }
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }

    public int getFileSize() {
        return 0;
    }

    public URN getURN() {
        return this.magnet.getSHA1Urn();
    }

    public Downloader createDownloader(boolean overwrite) throws SaveLocationException {
        return RouterService.download(this.magnet, overwrite, this.saveFile.getParentFile(), this.getSaveFile().getName());
    }
}

