/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.settings.iTunesSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class iTunesMediator {
    private static final Log LOG = LogFactory.getLog(iTunesMediator.class);
    private static iTunesMediator INSTANCE;
    private final ProcessingQueue QUEUE = new ProcessingQueue("iTunesAdderThread");

    public static synchronized iTunesMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new iTunesMediator();
        }
        return INSTANCE;
    }

    private iTunesMediator() {
    }

    public void addSong(File file) {
        if (!CommonUtils.isMacOSX()) {
            return;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: '" + file + "' does not exist");
            }
            return;
        }
        if (!file.isFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: '" + file + "' is a directory");
            }
            return;
        }
        String name = file.getName().toLowerCase(Locale.US);
        if (iTunesMediator.isSupported(name)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Will add '" + file + "' to Playlist");
            }
            this.QUEUE.add(new ExecOSAScriptCommand(file));
        }
    }

    private static boolean isSupported(String name) {
        String[] types = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue();
        for (int i = 0; i < types.length; ++i) {
            if (!name.endsWith(types[i])) continue;
            return true;
        }
        return false;
    }

    private static String[] createOSAScriptCommand(File file) {
        String path = file.getAbsolutePath();
        String playlist = iTunesSettings.ITUNES_PLAYLIST.getValue();
        String[] command = new String[]{"osascript", "-e", "tell application \"Finder\"", "-e", "set hfsFile to (POSIX file \"" + path + "\")", "-e", "set thePlaylist to \"" + playlist + "\"", "-e", "tell application \"iTunes\"", "-e", "launch", "-e", "if not (exists playlist thePlaylist) then", "-e", "set thisPlaylist to make new playlist", "-e", "set name of thisPlaylist to thePlaylist", "-e", "end if", "-e", "add hfsFile to playlist thePlaylist", "-e", "end tell", "-e", "end tell"};
        return command;
    }

    private class ExecOSAScriptCommand
    implements Runnable {
        private final File file;

        public ExecOSAScriptCommand(File file) {
            this.file = file;
        }

        public void run() {
            try {
                Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.file));
            }
            catch (IOException err) {
                LOG.debug(err);
            }
        }
    }
}

