/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.init.ProgressMonitor;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.BinaryHeap;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class FileScan {
    private int MEM_WEIGHT = 1;
    private int NUM_WEIGHT = 1;
    private int MAX_DEPTH = 3;
    private String[] _extensions;
    private String[] _filters;
    private BinaryHeap _dirs = new BinaryHeap(5);
    private ProgressMonitor monitor;
    private CompositeOrFilter filter = new CompositeOrFilter(new FileFilter[]{new DirectoryFilter(), new ShareableFilesFilter()});

    public FileScan(ProgressMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("monitor must not be null, use NullProgressMonitor then");
        }
        this.monitor = monitor;
        monitor.setIndeterminate(true);
        this._filters = new String[0];
        String exts = SharingSettings.EXTENSIONS_TO_SHARE.getValue();
        this._extensions = StringUtils.split(exts, ";");
    }

    public void setFileExtensions(String[] e) {
        this._extensions = e;
    }

    public void setDirectoryBlackList(String[] f) {
        this._filters = f;
    }

    public String[] getListAsArray() {
        ArrayList<String> files = new ArrayList<String>();
        Iterator i = this._dirs.iterator();
        while (i.hasNext()) {
            Pair p = (Pair)i.next();
            try {
                files.add(p.dir.getCanonicalPath());
            }
            catch (IOException ioe) {}
        }
        return files.toArray(new String[0]);
    }

    public String getListAsString() {
        String[] dirs = this.getListAsArray();
        StringBuffer files = new StringBuffer();
        for (int i = 0; i < dirs.length; ++i) {
            files.append(dirs[i]);
            files.append(';');
        }
        return files.toString();
    }

    public void scan(File file) {
        this.scan(file, this.MAX_DEPTH);
        this.monitor.setIndeterminate(false);
        this.monitor.setMaximum(1000);
        this.monitor.setValue(1000);
    }

    private void scan(File dir, int depth) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = this.listFiles(dir);
        this.addDirectory(dir, files);
        if (depth == 0) {
            return;
        }
        --depth;
        for (int i = 0; i < files.length; ++i) {
            if (this.monitor.isCancelled()) {
                this._dirs.clear();
                return;
            }
            if (!files[i].isDirectory()) continue;
            this.scan(files[i], depth);
        }
    }

    private void addDirectory(File dir, File[] files) {
        if (!dir.isDirectory()) {
            return;
        }
        long mem = 0L;
        int num = 0;
        for (int i = 0; i < files.length; ++i) {
            if (this.monitor.isCancelled()) {
                this._dirs.clear();
                return;
            }
            if (!files[i].isFile()) continue;
            mem += files[i].length();
            ++num;
        }
        long key = this.calculateKey(num, mem);
        Pair p = new Pair(key, dir);
        if (!this._dirs.isFull()) {
            this._dirs.insert(p);
        } else if (p.compareTo(this._dirs.getMax()) < 0) {
            this._dirs.extractMax();
            this._dirs.insert(p);
        }
    }

    private long calculateKey(int num_files, long size_files) {
        return (long)(num_files * this.NUM_WEIGHT) + size_files * (long)this.MEM_WEIGHT;
    }

    private boolean hasExtension(String filename) {
        int begin = filename.lastIndexOf(".") + 1;
        if (begin <= 0 || begin == filename.length()) {
            return false;
        }
        int end = filename.length();
        String ext = filename.substring(begin);
        for (int i = 0; i < this._extensions.length; ++i) {
            if (!ext.equalsIgnoreCase(this._extensions[i])) continue;
            return true;
        }
        return false;
    }

    private File[] listFiles(File dir) {
        File[] files = dir.listFiles(this.filter);
        if (files == null) {
            return new File[0];
        }
        return files;
    }

    private class Pair
    implements Comparable {
        public long key;
        public File dir;

        public Pair(long key, File dir) {
            this.key = key;
            this.dir = dir;
        }

        public int compareTo(Object o) {
            Pair p = (Pair)o;
            long diff = this.key - p.key;
            return diff > 0L ? -1 : (diff == 0L ? 0 : 1);
        }

        public String toString() {
            return this.key + " " + this.dir;
        }
    }

    private class CompositeOrFilter
    implements FileFilter {
        private FileFilter[] filters;

        public CompositeOrFilter(FileFilter[] filters) {
            if (filters == null) {
                throw new NullPointerException("filters must not be null");
            }
            this.filters = filters;
        }

        public boolean accept(File pathname) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].accept(pathname)) continue;
                return true;
            }
            return false;
        }
    }

    private class ShareableFilesFilter
    implements FileFilter {
        private ShareableFilesFilter() {
        }

        public boolean accept(File file) {
            return file.isFile() && FileScan.this.hasExtension(file.getName());
        }
    }

    private class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file) {
            if (!file.isDirectory() && !file.canRead()) {
                return false;
            }
            String dirName = file.getName().toLowerCase(Locale.US);
            for (int i = 0; i < FileScan.this._filters.length; ++i) {
                String curFilter = FileScan.this._filters[i].toLowerCase(Locale.US);
                if (dirName.indexOf(curFilter) == -1) continue;
                return false;
            }
            return true;
        }
    }
}

