/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JPanel;

final class ScanConfirmWindow
extends SetupWindow {
    private final int SHARED_DIRECTORY_LIMIT = 5;
    private CheckBoxListPanel CHECK_BOX_PANEL = new CheckBoxListPanel();
    private boolean _windowOpened = false;

    ScanConfirmWindow(SetupManager manager) {
        super(manager, "SETUP_CONFIRM_TITLE", "SETUP_CONFIRM_LABEL");
    }

    protected void createWindow() {
        if (!this._windowOpened) {
            String[] dirNames = this._manager.getScannedPaths();
            boolean hasDirectories = this.setDirectories(dirNames);
            this._windowOpened = true;
            if (!hasDirectories) {
                this.setLabelKey("SETUP_CONFIRM_LABEL_NO_DIRECTORIES");
            }
        }
        super.createWindow();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 6, 0);
        SetupWindow.MultiLineLabel label = new SetupWindow.MultiLineLabel(GUIMediator.getStringResource("SETUP_CONFIRM_FOLDERS_WILL_BE_SHARED"));
        label.setFont(label.getFont().deriveFont(0));
        mainPanel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        mainPanel.add((Component)this.CHECK_BOX_PANEL, gbc);
        this.setSetupComponent(mainPanel);
    }

    public void applySettings() throws ApplySettingsException {
        File[] dirs = this.getSelectedDirectories();
        boolean gotSaveDir = false;
        int finalLength = dirs.length;
        File saveDir = null;
        try {
            saveDir = SharingSettings.getSaveDirectory();
            if (saveDir == null || !saveDir.exists()) {
                throw new FileNotFoundException();
            }
            ++finalLength;
            gotSaveDir = true;
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        for (int i = 0; i < dirs.length; ++i) {
            SharingSettings.DIRECTORIES_TO_SHARE.add(dirs[i]);
        }
        if (gotSaveDir) {
            SharingSettings.DIRECTORIES_TO_SHARE.add(saveDir);
        }
    }

    private File[] getSelectedDirectories() {
        Object[] selected = this.CHECK_BOX_PANEL.getSelectedObjects();
        File[] files = new File[selected.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File((String)selected[i]);
        }
        return files;
    }

    private boolean setDirectories(String[] dirPaths) {
        if (dirPaths.length == 0) {
            return false;
        }
        this.CHECK_BOX_PANEL.getList().setObjects(dirPaths, false);
        return true;
    }
}

