/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LimeJProgressBar;
import com.limegroup.gnutella.gui.init.ProgressMonitor;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.util.ThreadFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

final class WaitWindow
extends SetupWindow {
    JProgressBar progressBar = new LimeJProgressBar();
    ProgressBarProgressMonitor progressMonitor = new ProgressBarProgressMonitor();

    WaitWindow(SetupManager manager) {
        super(manager, "SETUP_WAIT_TITLE", "SETUP_WAIT_LABEL");
    }

    protected void createWindow() {
        super.createWindow();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.progressMonitor.reset();
        this.progressBar.setEnabled(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 6, 0);
        mainPanel.add((Component)this.progressBar, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        mainPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JButton(new CancelScanAction()), gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        mainPanel.add((Component)new JPanel(), gbc);
        this.setSetupComponent(mainPanel);
    }

    public void handleWindowOpeningEvent() {
        super.handleWindowOpeningEvent();
        this._manager.enableActions(8);
        ThreadFactory.startThread(new Runnable(){

            public void run() {
                WaitWindow.this._manager.scan(WaitWindow.this.progressMonitor);
                boolean cancelled = WaitWindow.this.progressMonitor.isCancelled();
                SwingUtilities.invokeLater(new Runnable(this, cancelled){
                    private final /* synthetic */ boolean val$cancelled;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$cancelled = val$cancelled;
                    }

                    public void run() {
                        if (this.val$cancelled) {
                            1.access$100(this.this$1)._manager.enableActions(1.access$100(this.this$1).getAppropriateActions());
                            1.access$100(this.this$1).progressBar.setEnabled(false);
                            if (1.access$100(this.this$1).getNext() != 1.access$100(this.this$1)) {
                                1.access$100(this.this$1).setNext(1.access$100(this.this$1).getNext().getNext());
                            }
                            1.access$100(this.this$1).getNext().getNext().setPrevious(1.access$100(this.this$1).getPrevious());
                            1.access$100(this.this$1).progressBar.setString(GUIMediator.getStringResource("SETUP_WAIT_SCAN_CANCELLED_LABEL"));
                        } else {
                            1.access$100(this.this$1)._manager.next();
                        }
                    }
                });
            }

            static /* synthetic */ WaitWindow access$100(1 x0) {
                return x0.WaitWindow.this;
            }
        }, "Scanning HardDrive");
    }

    private class CancelScanAction
    extends AbstractAction {
        public CancelScanAction() {
            super(GUIMediator.getStringResource("SETUP_WAIT_CANCEL_SCAN_ACTION_NAME"));
        }

        public void actionPerformed(ActionEvent e) {
            WaitWindow.this.progressMonitor.setCancelled(true);
            this.setEnabled(false);
        }
    }

    private class ProgressBarProgressMonitor
    implements ProgressMonitor {
        private volatile boolean cancelled = false;

        private ProgressBarProgressMonitor() {
        }

        public void reset() {
            this.cancelled = false;
            WaitWindow.this.progressBar.setValue(0);
            WaitWindow.this.progressBar.setStringPainted(true);
            WaitWindow.this.progressBar.setString(GUIMediator.getStringResource("SETUP_WAIT_PROGRESS_STRING"));
        }

        public void setIndeterminate(boolean newValue) {
            SwingUtilities.invokeLater(new Runnable(this, newValue){
                private final /* synthetic */ boolean val$newValue;
                private final /* synthetic */ ProgressBarProgressMonitor this$1;
                {
                    this.this$1 = this$1;
                    this.val$newValue = val$newValue;
                }

                public void run() {
                    ProgressBarProgressMonitor.access$200((ProgressBarProgressMonitor)this.this$1).progressBar.setIndeterminate(this.val$newValue);
                }
            });
        }

        public void setValue(int value) {
            SwingUtilities.invokeLater(new Runnable(this, value){
                private final /* synthetic */ int val$value;
                private final /* synthetic */ ProgressBarProgressMonitor this$1;
                {
                    this.this$1 = this$1;
                    this.val$value = val$value;
                }

                public void run() {
                    ProgressBarProgressMonitor.access$200((ProgressBarProgressMonitor)this.this$1).progressBar.setValue(this.val$value);
                }
            });
        }

        public void setMaximum(int steps) {
            SwingUtilities.invokeLater(new Runnable(this, steps){
                private final /* synthetic */ int val$steps;
                private final /* synthetic */ ProgressBarProgressMonitor this$1;
                {
                    this.this$1 = this$1;
                    this.val$steps = val$steps;
                }

                public void run() {
                    ProgressBarProgressMonitor.access$200((ProgressBarProgressMonitor)this.this$1).progressBar.setMaximum(this.val$steps);
                }
            });
        }

        public void addToValue(int amountOfWork) {
            SwingUtilities.invokeLater(new Runnable(this, amountOfWork){
                private final /* synthetic */ int val$amountOfWork;
                private final /* synthetic */ ProgressBarProgressMonitor this$1;
                {
                    this.this$1 = this$1;
                    this.val$amountOfWork = val$amountOfWork;
                }

                public void run() {
                    int value = ProgressBarProgressMonitor.access$200((ProgressBarProgressMonitor)this.this$1).progressBar.getValue();
                    ProgressBarProgressMonitor.access$200((ProgressBarProgressMonitor)this.this$1).progressBar.setValue(value + this.val$amountOfWork);
                }
            });
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        static /* synthetic */ WaitWindow access$200(ProgressBarProgressMonitor x0) {
            return x0.WaitWindow.this;
        }
    }
}

