/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LanguageWindow;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.menu.ShowHideMenu;
import com.limegroup.gnutella.gui.menu.ThemeMenu;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

final class ViewMenu
extends AbstractMenu {
    private static final String SETTING_PROPERTY = "limewire.setting";

    ViewMenu(String key) {
        super(key);
        this.MENU.add(new ShowHideMenu("VIEW_SHOW_HIDE").getMenu());
        this.addSeparator();
        this.MENU.add(new ThemeMenu("VIEW_THEMES").getMenu());
        this.MENU.addSeparator();
        IconListener listener = new IconListener();
        JMenuItem item = this.addToggleMenuItem("VIEW_SMALL_ICONS", listener, UISettings.SMALL_ICONS.getValue());
        item.putClientProperty(SETTING_PROPERTY, UISettings.SMALL_ICONS);
        item = this.addToggleMenuItem("VIEW_TEXT_WITH_ICONS", listener, UISettings.TEXT_WITH_ICONS.getValue());
        item.putClientProperty(SETTING_PROPERTY, UISettings.TEXT_WITH_ICONS);
        this.MENU.addSeparator();
        item = this.addMenuItem("VIEW_LANGS_TITLE", new LanguageListener());
        this.MENU.add(item);
    }

    private static class IconListener
    implements ActionListener {
        private IconListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton item = (AbstractButton)e.getSource();
            BooleanSetting setting = (BooleanSetting)item.getClientProperty(ViewMenu.SETTING_PROPERTY);
            setting.setValue(item.isSelected());
            GUIMediator.instance().buttonViewChanged();
        }
    }

    private static class LanguageListener
    implements ActionListener {
        private LanguageListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LanguageWindow lw = new LanguageWindow();
            if (GUIMediator.isAppVisible()) {
                lw.setLocationRelativeTo(GUIMediator.getAppFrame());
            } else {
                lw.setLocation(GUIMediator.getScreenCenterPoint(lw));
            }
            lw.setVisible(true);
        }
    }
}

