/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.OverlayAd;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

final class SearchResultDisplayer
implements ThemeObserver,
RefreshListener {
    private final JPanel MAIN_PANEL = new BoxPanel(1);
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private static final List entries = new ArrayList();
    private final JPanel results = new JPanel();
    private final CardLayout switcher = new CardLayout();
    private final ResultPanel DUMMY;
    private final OverlayAd OVERLAY;
    private ChangeListener _activeSearchListener;
    private final PaneListener PANE_LISTENER = new PaneListener();

    SearchResultDisplayer() {
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        ProgTabUIFactory.extendUI(this.TABBED_PANE);
        this.TABBED_PANE.setRequestFocusEnabled(false);
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.switcher);
        this.OVERLAY = new OverlayAd();
        this.DUMMY = new ResultPanel(this.OVERLAY);
        JPanel mainScreen = new JPanel(new BorderLayout());
        mainScreen.add((Component)this.DUMMY.getComponent(), "Center");
        this.results.add("dummy", mainScreen);
        this.results.add("tabbedPane", this.TABBED_PANE);
        this.switcher.first(this.results);
        this.MAIN_PANEL.add(this.results);
        this.TABBED_PANE.addMouseListener(this.PANE_LISTENER);
        this.TABBED_PANE.addMouseMotionListener(this.PANE_LISTENER);
        this.TABBED_PANE.addChangeListener(this.PANE_LISTENER);
        ThemeMediator.addThemeObserver(this);
        CancelSearchIconProxy.updateTheme();
    }

    void setSearchListener(ChangeListener listener) {
        this._activeSearchListener = listener;
    }

    void updateResults() {
        for (int i = 0; i < entries.size(); ++i) {
            ((ResultPanel)entries.get(i)).refresh();
        }
    }

    ResultPanel addResultTab(GUID guid, SearchInformation info) {
        ResultPanel panel = new ResultPanel(guid, info);
        entries.add(panel);
        this.TABBED_PANE.addTab(info.getTitle(), CancelSearchIconProxy.createSelected(), panel.getComponent());
        this.TABBED_PANE.setSelectedIndex(entries.size() - 1);
        if (entries.size() > SearchSettings.PARALLEL_SEARCH.getValue()) {
            this.killSearchAtIndex(0);
        }
        GUIMediator.instance().setSearching(true);
        this.OVERLAY.searchPerformed();
        this.switcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return panel;
    }

    void addQueryResult(byte[] replyGUID, SearchResult line, ResultPanel rp) {
        if (!rp.matches(new GUID(replyGUID))) {
            throw new IllegalArgumentException("guids don't match");
        }
        rp.add(line);
        int resultPanelIndex = -1;
        resultPanelIndex = entries.indexOf(rp);
        if (resultPanelIndex == -1) {
            return;
        }
        this.TABBED_PANE.setTitleAt(resultPanelIndex, this.titleOf(rp));
    }

    void addChangeListener(ChangeListener listener) {
        this.TABBED_PANE.addChangeListener(listener);
    }

    void addFocusListener(FocusListener listener) {
        this.TABBED_PANE.addFocusListener(listener);
    }

    void showMenu(MouseEvent e) {
        ResultPanel rp = this.getSelectedResultPanel();
        if (rp != null) {
            JPopupMenu menu = rp.createPopupMenu();
            Point p = e.getPoint();
            if (menu != null) {
                try {
                    menu.show(this.MAIN_PANEL, p.x + 1, p.y - 6);
                }
                catch (IllegalComponentStateException icse) {
                    // empty catch block
                }
            }
        }
    }

    ResultPanel getSelectedResultPanel() {
        int i = this.TABBED_PANE.getSelectedIndex();
        if (i == -1) {
            return null;
        }
        try {
            return (ResultPanel)entries.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    ResultPanel getResultPanelForGUID(GUID rguid) {
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel rp = (ResultPanel)entries.get(i);
            if (!rp.matches(rguid)) continue;
            return rp;
        }
        return null;
    }

    ResultPanel getPanelAtIndex(int index) {
        return (ResultPanel)entries.get(index);
    }

    int getIndexForGUID(GUID rguid) {
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel rp = (ResultPanel)entries.get(i);
            if (!rp.matches(rguid)) continue;
            return i;
        }
        return -1;
    }

    int getIndexForPoint(int x, int y) {
        TabbedPaneUI ui = this.TABBED_PANE.getUI();
        return ui.tabForCoordinate(this.TABBED_PANE, x, y);
    }

    void killSearch() {
        int i = this.TABBED_PANE.getSelectedIndex();
        if (i == -1) {
            return;
        }
        this.killSearchAtIndex(i);
    }

    void killSearchAtIndex(int i) {
        ResultPanel killed = (ResultPanel)entries.remove(i);
        final GUID killedGUID = new GUID(killed.getGUID());
        GUIMediator.instance().schedule(new Runnable(){

            public void run() {
                RouterService.stopQuery(killedGUID);
            }
        });
        try {
            this.TABBED_PANE.removeTabAt(i);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.fixIcons();
        SearchMediator.searchKilled(killed);
        ThemeMediator.removeThemeObserver(killed);
        if (entries.size() == 0) {
            try {
                this.switcher.first(this.results);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                // empty catch block
            }
            GUIMediator.instance().setSearching(false);
        } else {
            this.checkToStopLime();
        }
    }

    void browseHostFailed(GUID guid) {
        int i = this.getIndexForGUID(guid);
        if (i > -1) {
            ResultPanel rp = this.getPanelAtIndex(i);
            this.killSearchAtIndex(i);
            GUIMediator.showError("ERROR_BROWSE_HOST_FAILED_BEGIN_KEY", rp.getTitle(), "ERROR_BROWSE_HOST_FAILED_END_KEY", QuestionsHandler.BROWSE_HOST_FAILED);
        }
    }

    void checkToStopLime() {
        long now = System.currentTimeMillis();
        boolean stopLime = true;
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel panel = (ResultPanel)entries.get(i);
            stopLime &= panel.isStopped() || panel.calculatePercentage(now) >= 1.0;
        }
        if (stopLime) {
            GUIMediator.instance().setSearching(false);
        }
    }

    void setTabDisplayCount(ResultPanel rp) {
        int i;
        boolean found = false;
        for (i = 0; i < entries.size(); ++i) {
            Object panel = entries.get(i);
            if (panel != rp) continue;
            found = true;
            break;
        }
        if (found) {
            this.TABBED_PANE.setTitleAt(i, this.titleOf(rp));
        }
    }

    private void fixIcons() {
        int sel = this.TABBED_PANE.getSelectedIndex();
        for (int i = 0; i < entries.size(); ++i) {
            this.TABBED_PANE.setIconAt(i, i == sel ? CancelSearchIconProxy.createSelected() : CancelSearchIconProxy.createPlain());
        }
    }

    ResultPanel getDummyResultPanel() {
        return this.DUMMY;
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public void updateTheme() {
        ProgTabUIFactory.extendUI(this.TABBED_PANE);
        this.DUMMY.updateTheme();
        this.OVERLAY.updateTheme();
        CancelSearchIconProxy.updateTheme();
        this.fixIcons();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ResultPanel curPanel = (ResultPanel)i.next();
            curPanel.updateTheme();
        }
    }

    public void refresh() {
        this.checkToStopLime();
        if (this.TABBED_PANE.isVisible() && this.TABBED_PANE.isShowing()) {
            Rectangle allBounds = this.TABBED_PANE.getBounds();
            Component comp = null;
            try {
                comp = this.TABBED_PANE.getSelectedComponent();
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                // empty catch block
            }
            if (comp != null) {
                Rectangle compBounds = comp.getBounds();
                Rectangle allTabs = new Rectangle(allBounds.x, allBounds.y, allBounds.width, compBounds.y - 1);
                this.TABBED_PANE.repaint(allTabs);
            }
        }
    }

    private String titleOf(ResultPanel rp) {
        int total;
        int current = rp.filteredSources();
        if (current < (total = rp.totalSources())) {
            return rp.getTitle() + " (" + current + "/" + total + ")";
        }
        return rp.getTitle() + " (" + total + ")";
    }

    private class PaneListener
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private int lastIdx = -1;

        private PaneListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.tryPopup(e)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                int y;
                int x = e.getX();
                int idx = this.shouldKillIndex(x, y = e.getY());
                if (idx != -1) {
                    this.lastIdx = -1;
                    SearchResultDisplayer.this.killSearchAtIndex(idx);
                }
                if (idx == -1) {
                    this.stateChanged(null);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            int y;
            int x = e.getX();
            int idx = this.shouldKillIndex(x, y = e.getY());
            if (idx != this.lastIdx && this.lastIdx != -1) {
                this.resetIcon();
            }
            if (idx != -1) {
                SearchResultDisplayer.this.TABBED_PANE.setIconAt(idx, CancelSearchIconProxy.createArmed());
                this.lastIdx = idx;
            }
        }

        private int shouldKillIndex(int x, int y) {
            Icon icon;
            int idx = SearchResultDisplayer.this.getIndexForPoint(x, y);
            if (idx != -1 && (icon = SearchResultDisplayer.this.TABBED_PANE.getIconAt(idx)) != null && icon instanceof CancelSearchIconProxy && ((CancelSearchIconProxy)icon).shouldKill(x, y)) {
                return idx;
            }
            return -1;
        }

        private void resetIcon() {
            if (this.lastIdx != -1 && this.lastIdx < SearchResultDisplayer.this.TABBED_PANE.getTabCount()) {
                if (this.lastIdx == SearchResultDisplayer.this.TABBED_PANE.getSelectedIndex()) {
                    SearchResultDisplayer.this.TABBED_PANE.setIconAt(this.lastIdx, CancelSearchIconProxy.createSelected());
                } else {
                    SearchResultDisplayer.this.TABBED_PANE.setIconAt(this.lastIdx, CancelSearchIconProxy.createPlain());
                }
                this.lastIdx = -1;
            }
        }

        public void mousePressed(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.resetIcon();
        }

        public void mouseDragged(MouseEvent e) {
        }

        private boolean tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int idx = SearchResultDisplayer.this.getIndexForPoint(e.getX(), e.getY());
                if (idx != -1) {
                    SearchResultDisplayer.this.TABBED_PANE.setSelectedIndex(idx);
                }
                SearchResultDisplayer.this.showMenu(e);
                return true;
            }
            return false;
        }

        public void stateChanged(ChangeEvent e) {
            SearchResultDisplayer.this._activeSearchListener.stateChanged(e);
            SearchResultDisplayer.this.fixIcons();
        }
    }
}

