/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.spam.SpamManager;

public class SpamFilter
implements TableLineFilter {
    private static final Saver SAVER = new Saver();

    public boolean allow(TableLine node) {
        return !SpamFilter.isAboveSpamThreshold(node);
    }

    public void markAsSpamUser(TableLine line, boolean isSpam) {
        RemoteFileDesc[] descs = line.getAllRemoteFileDescs();
        if (isSpam) {
            SpamManager.instance().handleUserMarkedSpam(descs);
        } else {
            SpamManager.instance().handleUserMarkedGood(descs);
        }
        line.update();
        GUIMediator.instance().schedule(SAVER);
    }

    static final boolean isAboveSpamThreshold(TableLine line) {
        return line.getSpamRating() >= SearchSettings.FILTER_SPAM_RESULTS.getValue();
    }

    private static class Saver
    implements Runnable {
        private Saver() {
        }

        public void run() {
            RatingTable.instance().save();
        }
    }
}

