/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ColorRenderer
extends JComponent
implements TableCellRenderer,
ThemeObserver {
    private Map otherRenderers = new HashMap();

    public ColorRenderer() {
        ThemeMediator.addThemeObserver(this);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        Class clazz;
        Object val;
        Color clr;
        ColoredCell cc = (ColoredCell)value;
        if (cc != null) {
            clr = cc.getColor();
            val = cc.getValue();
            clazz = cc.getCellClass();
        } else {
            clr = null;
            val = "";
            clazz = String.class;
        }
        TableCellRenderer tcr = table.getDefaultRenderer(clazz);
        tcr = this.getCachedOrNewRenderer(tcr);
        Component renderer = tcr.getTableCellRendererComponent(table, val, isSel, hasFocus, row, column);
        if (!isSel && !hasFocus) {
            renderer.setForeground(clr);
        }
        return renderer;
    }

    private boolean isReadable(Color foreGround, Color backGround) {
        if (foreGround == null || backGround == null) {
            return false;
        }
        return Math.abs(this.getLightness(foreGround) - this.getLightness(backGround)) > 0.2;
    }

    private double getLightness(Color color) {
        return 0.0;
    }

    public void updateTheme() {
        Iterator i = this.otherRenderers.values().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof ThemeObserver)) continue;
            ((ThemeObserver)o).updateTheme();
        }
    }

    public void updateUI() {
        Iterator i = this.otherRenderers.values().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof JComponent)) continue;
            ((JComponent)o).updateUI();
        }
    }

    private TableCellRenderer getCachedOrNewRenderer(TableCellRenderer tcr) {
        TableCellRenderer renderer = (TableCellRenderer)this.otherRenderers.get(tcr);
        if (renderer == null) {
            Class<?> rendererClass = tcr.getClass();
            try {
                renderer = (TableCellRenderer)rendererClass.newInstance();
            }
            catch (IllegalAccessException e) {
                Assert.that(false, e.getMessage());
            }
            catch (InstantiationException e) {
                Assert.that(false, e.getMessage());
            }
            catch (ClassCastException e) {
                Assert.that(false, e.getMessage());
            }
            this.otherRenderers.put(tcr, renderer);
        }
        return renderer;
    }
}

