/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.FileTransfer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class FileTransferable
implements Transferable {
    private final List files;
    private final List lazyFiles;

    public FileTransferable(List l) {
        this(l, null);
    }

    public FileTransferable(List real, List lazy) {
        this.files = real;
        this.lazyFiles = lazy;
    }

    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (this.lazyFiles != null && this.lazyFiles.size() > 0) {
            Iterator i = this.lazyFiles.iterator();
            while (i.hasNext()) {
                File f = ((FileTransfer)i.next()).getFile();
                if (f == null) continue;
                this.files.add(f);
            }
            this.lazyFiles.clear();
        }
        return this.files;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.javaFileListFlavor);
    }
}

