/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.tabs.AbstractTab;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public final class LibraryPlayListTab
extends AbstractTab {
    private static JComponent COMPONENT;
    private static JPanel PANEL;
    private static LibraryMediator LIBRARY_MEDIATOR;

    public LibraryPlayListTab(LibraryMediator lm) {
        super("LIBRARY", 3, "library_tab");
        LIBRARY_MEDIATOR = lm;
        LibraryPlayListTab.setPlayerEnabled(GUIMediator.isPlaylistVisible());
    }

    public void storeState(boolean visible) {
        ApplicationSettings.LIBRARY_VIEW_ENABLED.setValue(visible);
    }

    public JComponent getComponent() {
        return PANEL;
    }

    public static void setPlayerEnabled(boolean value) {
        if (COMPONENT != null && value == COMPONENT instanceof JSplitPane) {
            return;
        }
        PANEL.removeAll();
        if (value) {
            JSplitPane divider = new JSplitPane(0, LIBRARY_MEDIATOR.getComponent(), GUIMediator.getPlayList().getComponent());
            divider.setOneTouchExpandable(true);
            new DividerLocationSettingUpdater(divider, UISettings.UI_LIBRARY_PLAY_LIST_TAB_DIVIDER_LOCATION);
            COMPONENT = divider;
        } else {
            COMPONENT = LIBRARY_MEDIATOR.getComponent();
        }
        PANEL.add((Component)COMPONENT, "Center");
        PANEL.invalidate();
        PANEL.validate();
    }

    static {
        PANEL = new JPanel(new BorderLayout());
    }
}

