/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ThemeMediator {
    private static final List THEME_OBSERVERS = new LinkedList();

    public static void changeTheme(File newTheme) {
        ThemeMediator.changeTheme(newTheme, null, false);
    }

    public static void changeTheme(File newTheme, String className) {
        ThemeMediator.changeTheme(newTheme, className, false);
    }

    public static void changeTheme(File newTheme, boolean forceReload) {
        ThemeMediator.changeTheme(newTheme, null, forceReload);
    }

    public static void changeTheme(File newTheme, String className, boolean forceReload) {
        if (!newTheme.isFile()) {
            GUIMediator.showError("ERROR_INVALID_THEME_FILE");
            return;
        }
        if (className != null && !className.equals("")) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                GUIMediator.showError("ERROR_INVALID_THEME_FILE");
                return;
            }
        } else {
            className = "";
        }
        String oldClassName = ThemeSettings.getOtherLF();
        if (oldClassName == null) {
            oldClassName = "";
        }
        if (!ThemeSettings.THEME_FILE.getValue().equals(newTheme) || !className.equals(oldClassName)) {
            File oldTheme = ThemeSettings.THEME_FILE.getValue();
            ThemeSettings.THEME_FILE.setValue(newTheme);
            ThemeSettings.setOtherLF(className);
            ThemeFileHandler.reload(forceReload);
            if (!ThemeFileHandler.isCurrent()) {
                ThemeSettings.THEME_FILE.setValue(oldTheme);
                ThemeFileHandler.reload(forceReload);
                ThemeMediator.showThemeError(newTheme.getName());
            } else {
                boolean isPinstripes = ThemeSettings.isPinstripesTheme();
                boolean wasMetal = ResourceManager.instance().isBrushedMetalSet();
                boolean isMetal = ThemeSettings.isBrushedMetalTheme();
                if (isPinstripes && wasMetal || isMetal && !wasMetal) {
                    GUIMediator.showMessage("THEME_CHANGED_MESSAGE");
                } else {
                    GUIMediator.setAppVisible(false);
                    SplashWindow.instance().setVisible(true);
                    SplashWindow.refreshImage();
                    ResourceManager.instance().themeChanged();
                    SwingUtilities.updateComponentTreeUI(GUIMediator.getMainOptionsComponent());
                    SwingUtilities.updateComponentTreeUI(StatisticsMediator.instance().getMainStatisticsComponent());
                    TipOfTheDayMediator.instance().updateComponentTreeUI();
                    SwingUtilities.updateComponentTreeUI(GUIMediator.getAppFrame());
                    ThemeMediator.updateThemeObservers();
                    GUIMediator.setAppVisible(true);
                    SplashWindow.instance().setVisible(false);
                }
            }
        }
    }

    public static void addThemeObserver(ThemeObserver observer) {
        THEME_OBSERVERS.add(observer);
    }

    public static void removeThemeObserver(ThemeObserver observer) {
        THEME_OBSERVERS.remove(observer);
    }

    public static void updateThemeObservers() {
        Iterator iter = THEME_OBSERVERS.iterator();
        while (iter.hasNext()) {
            ThemeObserver curObserver = (ThemeObserver)iter.next();
            curObserver.updateTheme();
        }
        GUIMediator.getMainOptionsComponent().validate();
        StatisticsMediator.instance().getMainStatisticsComponent().validate();
        GUIMediator.getAppFrame().validate();
    }

    public static void showThemeError(String name) {
        Dimension size = new Dimension(300, 100);
        final JDialog d = new JDialog(GUIMediator.getAppFrame());
        d.setModal(true);
        d.setResizable(false);
        d.setTitle(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE_TITLE"));
        d.setDefaultCloseOperation(2);
        BoxPanel body = new BoxPanel(1);
        BoxPanel text = new BoxPanel(1);
        MultiLineLabel label = new MultiLineLabel(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE"), 250);
        label.setFont(new Font("Dialog", 1, 12));
        text.add(Box.createVerticalGlue());
        text.add(GUIUtils.center(label));
        text.add(Box.createVerticalGlue());
        BoxPanel buttons = new BoxPanel(0);
        JButton getNew = new JButton(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE_GET_MORE"));
        JButton later = new JButton(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE_LATER"));
        getNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.openURL("http://www.limewire.com/skins2");
                d.dispose();
                d.setVisible(false);
            }
        });
        later.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                d.dispose();
                d.setVisible(false);
            }
        });
        buttons.add(getNew);
        buttons.add(GUIMediator.getHorizontalSeparator());
        buttons.add(later);
        body.add(text);
        body.add(buttons);
        body.setPreferredSize(size);
        d.getContentPane().add(body);
        d.pack();
        d.setLocationRelativeTo(GUIMediator.getAppFrame());
        d.setVisible(true);
    }
}

