/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.util;

import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import java.io.File;
import java.text.MessageFormat;

public class CoreExceptionHandler {
    public static void handleSaveLocationError(SaveLocationException sle) {
        GUIMediator.showTranslatedError(CoreExceptionHandler.getSaveLocationErrorString(sle));
    }

    public static String getShortSaveLocationErrorString(SaveLocationException sle) {
        switch (sle.getErrorCode()) {
            case 1: {
                return GUIMediator.getStringResource("SAVE_LOCATION_SECURITY_VIOLATION_SHORT_ERROR");
            }
            case 2: {
                return GUIMediator.getStringResource("SAVE_LOCATION_ALREADY_SAVED_SHORT_ERROR");
            }
            case 3: {
                return GUIMediator.getStringResource("SAVE_LOCATION_DIRECTORY_NOT_WRITEABLE_SHORT_ERROR");
            }
            case 4: {
                return GUIMediator.getStringResource("SAVE_LOCATION_DIRECTORY_DOES_NOT_EXIST_SHORT_ERROR");
            }
            case 5: {
                return GUIMediator.getStringResource("SAVE_LOCATION_ALREADY_EXISTS_SHORT_ERROR");
            }
            case 6: {
                return GUIMediator.getStringResource("SAVE_LOCATION_IS_ALREADY_DOWNLOADED_TO_SHORT_ERROR");
            }
            case 8: {
                return GUIMediator.getStringResource("SAVE_LOCATION_NOT_A_DIRECOTRY_SHORT_ERROR");
            }
            case 7: {
                return GUIMediator.getStringResource("SAVE_LOCATION_FILE_NOT_REGULAR_SHORT_ERROR");
            }
            case 9: {
                return GUIMediator.getStringResource("SAVE_LOCATION_FILESYSTEM_SHORT_ERROR");
            }
            case 10: {
                return GUIMediator.getStringResource("SAVE_LOCATION_ALREADY_DOWNLOADING_SHORT_ERROR");
            }
        }
        throw new IllegalArgumentException("Unhandled error code: " + sle.getErrorCode());
    }

    public static String getSaveLocationErrorString(SaveLocationException sle) {
        return CoreExceptionHandler.getSaveLocationErrorString(sle, false);
    }

    public static String getSaveLocationErrorString(SaveLocationException sle, boolean html) {
        switch (sle.getErrorCode()) {
            case 1: {
                return MessageFormat.format(GUIMediator.getStringResource("SAVE_LOCATION_SECURITY_VIOLATION_ERROR"), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 2: {
                return GUIMediator.getStringResource("SAVE_LOCATION_ALREADY_SAVED_ERROR");
            }
            case 3: {
                return MessageFormat.format(GUIMediator.getStringResource("SAVE_LOCATION_DIRECTORY_NOT_WRITEABLE_ERROR"), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 4: {
                return MessageFormat.format(GUIMediator.getStringResource("SAVE_LOCATION_DIRECTORY_DOES_NOT_EXIST_ERROR"), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 5: {
                return MessageFormat.format(GUIMediator.getStringResource("SAVE_LOCATION_ALREADY_EXISTS_ERROR"), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 6: {
                return MessageFormat.format(GUIMediator.getStringResource("SAVE_LOCATION_IS_ALREADY_DOWNLOADED_TO_ERROR"), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 8: {
                return MessageFormat.format(GUIMediator.getStringResource("SAVE_LOCATION_NOT_A_DIRECOTRY_ERROR"), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 7: {
                return MessageFormat.format(GUIMediator.getStringResource("SAVE_LOCATION_FILE_NOT_REGULAR_ERROR"), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 9: {
                return GUIMediator.getStringResource("SAVE_LOCATION_FILESYSTEM_ERROR");
            }
            case 10: {
                return GUIMediator.getStringResource("SAVE_LOCATION_ALREADY_DOWNLOADING_ERROR");
            }
        }
        throw new IllegalArgumentException("Unhandled error code: " + sle.getErrorCode());
    }

    private static Object[] params(boolean html, File file) {
        String fileName = GUIUtils.convertToNonBreakingSpaces(0, file.toString());
        return new Object[]{html ? "<i>" + fileName + "</i>" : fileName};
    }
}

