/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLUtils {
    private static final Log LOG = LogFactory.getLog(XMLUtils.class);
    private static Map bundles;

    private XMLUtils() {
    }

    public static List getDisplayList(LimeXMLDocument doc) {
        LinkedList<String> data = new LinkedList<String>();
        LimeXMLSchema schema = doc.getSchema();
        List fields = schema.getCanonicalizedFields();
        Iterator j = fields.iterator();
        while (j.hasNext()) {
            SchemaFieldInfo sfi = (SchemaFieldInfo)j.next();
            String name = sfi.getCanonicalizedFieldName();
            String value = doc.getValue(name);
            if (value == null || sfi.isHidden()) continue;
            NameValue pair = XMLUtils.getDisplayPair(sfi, value, schema);
            data.add(pair.getName() + ": " + pair.getValue());
        }
        return data;
    }

    public static NameValue getDisplayPair(SchemaFieldInfo field, String value, LimeXMLSchema schema) {
        String name = XMLUtils.getResource(field.getCanonicalizedFieldName());
        value = XMLUtils.getDisplay(field, value);
        return new NameValue(name, value);
    }

    public static String getDisplay(SchemaFieldInfo field, String value) {
        if (field.getJavaType() == Date.class) {
            try {
                value = CommonUtils.seconds2time(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static Comparable getComparable(SchemaFieldInfo field, String value) {
        if (field == null || value == null) {
            return null;
        }
        if (field.getJavaType() == Integer.class || field.getJavaType() == Date.class) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return value;
    }

    public static String getResource(String field) {
        try {
            return GUIMediator.getStringResource("XML_" + field);
        }
        catch (MissingResourceException mre) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Missing main resource for: " + field + ", falling back.", mre);
            }
            return XMLUtils.fallbackResource(field, XMLUtils.getBundleForField(field));
        }
    }

    public static String getTitleForSchemaFromField(String field) {
        if (!field.endsWith("__")) {
            return null;
        }
        int idx1 = field.indexOf("__") + 2;
        int idx2 = field.indexOf("__", idx1);
        return XMLUtils.getResource(field.substring(0, idx2));
    }

    public static String getTitleForSchemaURI(String schemaURI) {
        LimeXMLSchema schema = LimeXMLSchemaRepository.instance().getSchema(schemaURI);
        if (schema != null) {
            return XMLUtils.getTitleForSchema(schema);
        }
        return null;
    }

    public static String getTitleForSchema(LimeXMLSchema schema) {
        return XMLUtils.getResource(schema.getRootXMLName() + "__" + schema.getInnerXMLName());
    }

    private static ResourceBundle getBundleForField(String field) {
        if (bundles == null) {
            XMLUtils.loadBundles();
        }
        return (ResourceBundle)bundles.get(XMLUtils.getDescriptionFromField(field));
    }

    private static String getDescriptionFromField(String field) {
        int idx1 = field.indexOf("__") + 2;
        int idx2 = field.indexOf("__", idx1);
        if (idx2 == -1) {
            idx2 = field.length();
        }
        return field.substring(idx1, idx2);
    }

    private static void loadBundles() {
        bundles = new HashMap();
        Collection schemas = LimeXMLSchemaRepository.instance().getAvailableSchemas();
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            LimeXMLSchema schema = (LimeXMLSchema)i.next();
            String key = schema.getDescription();
            try {
                bundles.put(key, GUIMediator.getXMLResourceBundle(key));
            }
            catch (MissingResourceException mre) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Missing resource bundle for schema: " + key, mre);
            }
        }
    }

    private static String fallbackResource(String field, ResourceBundle bundle) {
        block3: {
            if (bundle != null) {
                try {
                    return bundle.getString(field);
                }
                catch (MissingResourceException mre) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Missing fallback resource for: " + field + ", capitalizing field name.", mre);
                }
            }
        }
        return XMLUtils.processField(field);
    }

    private static String formatFieldName(String name) {
        return name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1).replace('_', ' ').trim();
    }

    private static String processField(String field) {
        int endIdx = field.endsWith("__") ? field.length() - 2 : field.length();
        int startIdx = field.lastIndexOf("__", endIdx - 1) + 2;
        return XMLUtils.formatFieldName(field.substring(startIdx, endIdx));
    }
}

