/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ApplicationEditor
extends MetaEditorPanel {
    private JLabel nameLabel;
    private LimeTextField nameTextField;
    private JLabel publisherLabel;
    private LimeTextField publisherTextField;
    private JCheckBox publisherCheckBox;
    private JLabel platformLabel;
    private JComboBox platformComboBox;
    private JCheckBox platformCheckBox;
    private JLabel licenseTypeLabel;
    private JComboBox licenseTypeComboBox;
    private JCheckBox licenseTypeCheckBox;
    private JLabel licenseLabel;
    private LimeTextField licenseTextField;
    private JCheckBox licenseCheckBox;
    private String name = null;
    private boolean nameEdited = false;

    public ApplicationEditor(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument doc) {
        super(fds, schema, doc);
        this.setName(MetaEditorUtil.getStringResource("applications__application"));
        this.init();
        this.initFields();
        this.setMultiEdit(fds.length > 1);
        ComboBoxValue val = (ComboBoxValue)this.licenseTypeComboBox.getSelectedItem();
        if (val == null || !val.equals(new ComboBoxValue("creativecommons.org/licenses/"))) {
            this.licenseTextField.setVisible(false);
            this.licenseLabel.setVisible(false);
            this.licenseCheckBox.setVisible(false);
        }
        this.nameTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                ApplicationEditor.this.nameEdited = true;
            }
        });
    }

    public void setMultiEdit(boolean multiEdit) {
        super.setMultiEdit(multiEdit);
        this.nameLabel.setVisible(!multiEdit);
        this.nameTextField.setVisible(!multiEdit);
    }

    public boolean hasChanged() {
        return this.nameEdited || super.hasChanged();
    }

    protected void prepareSave() {
        String text;
        if (this.name != null && (text = this.nameTextField.getText().trim()).equals("")) {
            this.nameTextField.setText(this.name);
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.nameLabel = new JLabel(MetaEditorUtil.getStringResource("applications__application__name__"));
        this.add((Component)this.nameLabel, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        this.nameTextField = new LimeTextField(40);
        this.add((Component)this.nameTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.publisherLabel = new JLabel(MetaEditorUtil.getStringResource("applications__application__publisher__"));
        this.add((Component)this.publisherLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.publisherCheckBox = new JCheckBox();
        this.add((Component)this.publisherCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.publisherTextField = new LimeTextField(24);
        this.add((Component)this.publisherTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.platformLabel = new JLabel(MetaEditorUtil.getStringResource("applications__application__platform__"));
        this.add((Component)this.platformLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.platformCheckBox = new JCheckBox();
        this.add((Component)this.platformCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.platformComboBox = new JComboBox();
        this.add((Component)this.platformComboBox, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseLabel = new JLabel(MetaEditorUtil.getStringResource("applications__application__license"));
        this.add((Component)this.licenseLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseCheckBox = new JCheckBox();
        this.add((Component)this.licenseCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTextField = new LimeTextField(24);
        this.licenseTextField.setEnabled(false);
        this.add((Component)this.licenseTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTypeLabel = new JLabel(MetaEditorUtil.getStringResource("applications__application__licensetype__"));
        this.add((Component)this.licenseTypeLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTypeCheckBox = new JCheckBox();
        this.add((Component)this.licenseTypeCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTypeComboBox = new JComboBox();
        this.add((Component)this.licenseTypeComboBox, gbc);
    }

    protected void initFields() {
        this.addComponent("applications__application__name__", this.nameTextField);
        this.addComponent("applications__application__publisher__", this.publisherCheckBox, this.publisherTextField);
        this.addComponent("applications__application__platform__", this.platformCheckBox, this.platformComboBox);
        this.addComponent("applications__application__license", this.licenseCheckBox, this.licenseTextField);
        this.addComponent("applications__application__licensetype__", this.licenseTypeCheckBox, this.licenseTypeComboBox);
        super.initFields();
    }
}

