/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DetailsPanel
extends JPanel {
    private int maxRows = 7;
    private Font boldFont = null;
    private ArrayList list = new ArrayList();

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private void add(String name, String value) {
        this.list.add(new NameValuePair(name, value));
    }

    public void initWithFileDesc(FileDesc fd, String schemaUri) {
        String kind = MetaEditorUtil.getKind(fd.getFile());
        if (kind != null) {
            this.add(GUIMediator.getStringResource("META_EDITOR_KIND_LABEL"), kind);
        }
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection collection = map.getReplyCollection(schemaUri);
        LimeXMLDocument doc = collection.getDocForHash(fd.getSHA1Urn());
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        LimeXMLSchema schema = rep.getSchema(schemaUri);
        if (doc != null) {
            List fields = schema.getCanonicalizedFields();
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                String value;
                SchemaFieldInfo infoField = (SchemaFieldInfo)it.next();
                String field = infoField.getCanonicalizedFieldName();
                if (DetailsPanel.skipField(field) || (value = doc.getValue(field)) == null || value.equals("")) continue;
                String name = MetaEditorUtil.getStringResource(field);
                this.add(name, value);
            }
        }
        String name = GUIMediator.getStringResource("META_EDITOR_SIZE_LABEL");
        String value = GUIUtils.toUnitbytes(fd.getFileSize());
        this.add(name, value);
        name = GUIMediator.getStringResource("META_EDITOR_DATE_MODIFIED_LABEL");
        value = GUIUtils.msec2DateTime(fd.lastModified());
        this.list.add(new NameValuePair(name, value));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            this.addLabel((NameValuePair)it.next(), layout, c);
        }
    }

    protected void addLabel(NameValuePair pair, GridBagLayout bag, GridBagConstraints c) {
        JLabel name = new JLabel(pair.name, 11);
        if (this.boldFont == null) {
            Font currentFont = name.getFont();
            this.boldFont = new Font(currentFont.getName(), 1, currentFont.getSize());
        }
        name.setFont(this.boldFont);
        c.anchor = 12;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 2, 3);
        bag.setConstraints(name, c);
        this.add(name);
        MultiLineLabel value = new MultiLineLabel(pair.value, 300);
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        bag.setConstraints(value, c);
        this.add(value);
    }

    private static boolean skipField(String field) {
        if (field.equals("audios__audio__title__")) {
            return true;
        }
        if (field.equals("audios__audio__artist__")) {
            return true;
        }
        if (field.equals("audios__audio__album__")) {
            return true;
        }
        if (field.equals("audios__audio__seconds__")) {
            return true;
        }
        if (field.equals("audios__audio__comments__")) {
            return true;
        }
        return !MetaEditorUtil.contains(field);
    }

    private static final class NameValuePair {
        private final String name;
        private final String value;

        private NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

