/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.archive.Contribution;
import com.limegroup.gnutella.archive.DirectoryChangeFailedException;
import com.limegroup.gnutella.archive.LoginFailedException;
import com.limegroup.gnutella.archive.RefusedConnectionException;
import com.limegroup.gnutella.archive.UploadListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LimeJProgressBar;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.util.ThreadFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class InternetArchiveUploader
implements FileEventListener,
UploadListener {
    private static final int DIALOG_WIDTH = 400;
    private static final int DIALOG_HEIGHT = 200;
    private final JLabel _mainProgressLabel = new JLabel();
    private final JLabel _fileProgressLabel = new JLabel();
    private final JProgressBar _fileProgressBar = new LimeJProgressBar(0, 100);
    private final JProgressBar _mainProgressBar = new LimeJProgressBar(0, 100);
    private final JLabel _mainLabel = new JLabel(GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_LABEL"));
    private JDialog _dialog;
    private FileDesc _fd;
    private final Contribution _contribution;
    private boolean _isEventHandled;
    private volatile boolean _isCancelled;
    private JButton finishButton;
    private final ProgressUpdater PROGRESS_UPDATER = new ProgressUpdater();

    public InternetArchiveUploader(FileDesc fd, Contribution contribution) {
        this._fd = fd;
        this._contribution = contribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFileEvent(FileManagerEvent evt) {
        if (this._contribution == null) {
            return;
        }
        if (!evt.isChangeEvent() || evt.getFileDescs() == null || evt.getFileDescs().length == 0) {
            return;
        }
        if (this._fd.equals(evt.getFileDescs()[0])) {
            InternetArchiveUploader internetArchiveUploader = this;
            synchronized (internetArchiveUploader) {
                if (this._isEventHandled) {
                    return;
                }
                this._isEventHandled = true;
            }
            this.init();
            FileDesc newFD = evt.getFileDescs()[1];
            this._contribution.addFileDesc(newFD);
            this._contribution.addListener(this);
            this._dialog.setLocationRelativeTo(MessageService.getParentComponent());
            this._dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    InternetArchiveUploader.this.cancel();
                }
            });
            ThreadFactory.startThread(new Runnable(){

                public void run() {
                    InternetArchiveUploader.this.doUpload();
                }
            }, "InternetArchive_Uploader");
            this._dialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpload() {
        String message;
        block13: {
            message = null;
            boolean success = false;
            if (this._isCancelled) return;
            try {
                try {
                    this._contribution.upload();
                    message = GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_COMPLETED");
                    success = true;
                }
                catch (RefusedConnectionException rce) {
                    message = "ERROR_INTERNETARCHIVE_CONNECTION";
                    Object var5_4 = null;
                    if (this._isCancelled) return;
                    if (success) {
                        GUIMediator.safeInvokeLater(new Runnable(){

                            public void run() {
                                InternetArchiveUploader.this._mainProgressBar.setValue(100);
                                InternetArchiveUploader.this._mainProgressBar.setString("100%");
                                InternetArchiveUploader.this._mainProgressLabel.setText(GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_COMPLETED"));
                                InternetArchiveUploader.this._fileProgressLabel.setText("");
                                InternetArchiveUploader.this._fileProgressBar.setIndeterminate(false);
                                InternetArchiveUploader.this._fileProgressBar.setStringPainted(true);
                                InternetArchiveUploader.this._fileProgressBar.setValue(100);
                                InternetArchiveUploader.this._fileProgressBar.setString("100%");
                                InternetArchiveUploader.this.finishButton.setText(GUIMediator.getStringResource("GENERAL_OK_BUTTON_LABEL"));
                            }
                        });
                        return;
                    }
                    String mess = message;
                    GUIMediator.safeInvokeLater(new Runnable(mess){
                        private final /* synthetic */ String val$mess;
                        {
                            this.val$mess = val$mess;
                        }

                        public void run() {
                            GUIMediator.showError(this.val$mess);
                            InternetArchiveUploader.this.cancel();
                        }
                    });
                    return;
                }
                catch (LoginFailedException lfe) {
                    message = "ERROR_INTERNETARCHIVE_LOGIN";
                    Object var5_5 = null;
                    if (this._isCancelled) return;
                    if (success) {
                        GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    String mess = message;
                    GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                catch (DirectoryChangeFailedException lfe) {
                    message = "ERROR_INTERNETARCHIVE_DIRECTORY";
                    Object var5_6 = null;
                    if (this._isCancelled) return;
                    if (success) {
                        GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    String mess = message;
                    GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                catch (IOException e) {
                    message = "ERROR_INTERNETARCHIVE_COMMUNICATION";
                    Object var5_7 = null;
                    if (this._isCancelled) return;
                    if (success) {
                        GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    String mess = message;
                    GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                Object var5_3 = null;
                if (this._isCancelled) return;
                if (!success) break block13;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (this._isCancelled) throw throwable;
                if (success) {
                    GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                String mess = message;
                GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        String mess = message;
        GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void init() {
        this._dialog = new JDialog((Frame)GUIMediator.getAppFrame(), true);
        GUIUtils.addHideAction((JComponent)this._dialog.getContentPane());
        this._dialog.setResizable(false);
        String title = GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_TITLE");
        this._dialog.setTitle(title + " - " + this._contribution.getTitle());
        this._dialog.setSize(new Dimension(400, 200));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        con.anchor = 17;
        con.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)this._mainLabel, con);
        con.anchor = 10;
        con.gridy = 1;
        this._mainProgressBar.setIndeterminate(true);
        this._mainProgressBar.setStringPainted(true);
        this._mainProgressBar.setValue(0);
        mainPanel.add((Component)this._mainProgressBar, con);
        con.gridy = 2;
        this._mainProgressLabel.setText(GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_INIT"));
        mainPanel.add((Component)this._mainProgressLabel, con);
        con.gridy = 3;
        con.insets = new Insets(10, 0, 0, 0);
        this._fileProgressBar.setEnabled(false);
        this._fileProgressBar.setStringPainted(true);
        this._fileProgressBar.setValue(0);
        mainPanel.add((Component)this._fileProgressBar, con);
        con.gridy = 4;
        con.insets = new Insets(2, 0, 0, 0);
        mainPanel.add((Component)this._fileProgressLabel, con);
        this.finishButton = new JButton(GUIMediator.getStringResource("GENERAL_CANCEL_BUTTON_LABEL"));
        this.finishButton.addActionListener(new OKCancelButtonListener());
        con.gridy = 5;
        con.insets = new Insets(20, 0, 0, 0);
        mainPanel.add((Component)this.finishButton, con);
        this._dialog.getContentPane().add(mainPanel);
    }

    public void connected() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                InternetArchiveUploader.this._mainProgressLabel.setText(GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_CONNECTED"));
            }
        });
    }

    public void fileCompleted() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                InternetArchiveUploader.this.setProgressBarStatus();
            }
        });
    }

    public void fileProgressed() {
        this.PROGRESS_UPDATER.updateEvent();
        GUIMediator.safeInvokeLater(this.PROGRESS_UPDATER);
    }

    public void fileStarted() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int totalFiles;
                int filesSent;
                String fileName;
                InternetArchiveUploader.this._mainProgressBar.setIndeterminate(false);
                InternetArchiveUploader.this._fileProgressBar.setEnabled(true);
                InternetArchiveUploader.this.setProgressBarStatus();
                Contribution contribution = InternetArchiveUploader.this._contribution;
                synchronized (contribution) {
                    fileName = InternetArchiveUploader.this._contribution.getFileName().length() > 30 ? InternetArchiveUploader.this._contribution.getFileName().substring(0, 30) + "..." : InternetArchiveUploader.this._contribution.getFileName();
                    filesSent = InternetArchiveUploader.this._contribution.getFilesSent();
                    totalFiles = InternetArchiveUploader.this._contribution.getTotalFiles();
                }
                String mainLabelString = GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_FILE_UPLOADING") + " " + (filesSent + 1) + " " + GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_FILE_UPLOADING_OF") + " " + totalFiles + ": " + fileName;
                InternetArchiveUploader.this._mainProgressLabel.setText(mainLabelString);
            }
        });
    }

    public void checkinCompleted() {
    }

    public void checkinStarted() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                InternetArchiveUploader.this._fileProgressBar.setIndeterminate(true);
                InternetArchiveUploader.this._fileProgressBar.setStringPainted(false);
                InternetArchiveUploader.this._mainProgressLabel.setText(GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_CHECKIN"));
                InternetArchiveUploader.this._fileProgressLabel.setText("");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProgressBarStatus() {
        int filePercent;
        int totalPercent;
        Contribution contribution = this._contribution;
        synchronized (contribution) {
            totalPercent = (int)(100.0 * (double)this._contribution.getTotalBytesSent() / (double)this._contribution.getTotalSize());
            filePercent = (int)(100.0 * (double)this._contribution.getFileBytesSent() / (double)this._contribution.getFileSize());
        }
        this._fileProgressBar.setValue(filePercent);
        this._fileProgressBar.setString(filePercent + "%");
        this._mainProgressBar.setValue(totalPercent);
        this._mainProgressBar.setString(totalPercent + "%");
    }

    private void cancel() {
        if (!this._isCancelled) {
            this._isCancelled = true;
        }
        this._contribution.cancel();
        this.dispose();
    }

    private void dispose() {
        this._dialog.setVisible(false);
        this._dialog.dispose();
    }

    private class ProgressUpdater
    implements Runnable {
        private final String uploaded = GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_FILE_UPLOADED");
        private final String of = GUIMediator.getStringResource("INTERNETARCHIVE_UPLOADER_FILE_BYTESOF");
        private boolean dirty;

        private ProgressUpdater() {
        }

        public synchronized void updateEvent() {
            this.dirty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String fileString;
            ProgressUpdater progressUpdater = this;
            synchronized (progressUpdater) {
                if (!this.dirty) {
                    return;
                }
                this.dirty = false;
            }
            Contribution contribution = InternetArchiveUploader.this._contribution;
            synchronized (contribution) {
                fileString = this.uploaded + "  " + InternetArchiveUploader.this._contribution.getFileBytesSent() + " " + this.of + " " + InternetArchiveUploader.this._contribution.getFileSize();
                InternetArchiveUploader.this.setProgressBarStatus();
            }
            InternetArchiveUploader.this._fileProgressLabel.setText(fileString);
        }
    }

    private class OKCancelButtonListener
    implements ActionListener {
        private OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (((JButton)arg0.getSource()).getText().equals(GUIMediator.getStringResource("GENERAL_OK_BUTTON_LABEL"))) {
                InternetArchiveUploader.this.dispose();
            } else {
                InternetArchiveUploader.this.cancel();
            }
        }
    }
}

