/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor.audio;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.xml.editor.DetailsPanel;
import com.limegroup.gnutella.gui.xml.editor.IconPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorPanel;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

class AudioInfo
extends MetaEditorPanel {
    private JLabel albumLabel;
    private JLabel artistLabel;
    private JPanel detailsPanel;
    private JPanel iconPanel;
    private JLabel titleLabel;
    private JTextArea whereTextArea;

    public AudioInfo(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument doc) {
        super(fds, schema, doc);
        super.setName(GUIMediator.getStringResource("META_EDITOR_INFO_TAB_LABEL"));
        this.initComponents();
        File file = fds[0].getFile();
        ((DetailsPanel)this.detailsPanel).setMaxRows(13);
        ((DetailsPanel)this.detailsPanel).initWithFileDesc(fds[0], schema.getSchemaURI());
        ((IconPanel)this.iconPanel).initWithFileDesc(fds[0]);
        this.whereTextArea.setFont(new JLabel().getFont());
        this.whereTextArea.setText(fds[0].getFile().toString());
        String title = this.getValue("audios__audio__title__");
        String artist = this.getValue("audios__audio__artist__");
        String album = this.getValue("audios__audio__album__");
        if (title != null) {
            String length = this.getValue("audios__audio__seconds__");
            if (length != null) {
                try {
                    title = title + " (" + CommonUtils.seconds2time(Integer.parseInt(length)) + ")";
                }
                catch (NumberFormatException err) {
                    // empty catch block
                }
            }
            this.titleLabel.setText(title);
        } else {
            this.titleLabel.setText("");
        }
        if (artist != null) {
            this.artistLabel.setText(artist);
        } else {
            this.artistLabel.setText("");
        }
        if (album != null) {
            this.albumLabel.setText(album);
        } else {
            this.albumLabel.setText("");
        }
    }

    private void initComponents() {
        JPanel panel1 = new JPanel();
        JSeparator seperator1 = new JSeparator();
        JPanel panel2 = new JPanel();
        this.iconPanel = new IconPanel();
        this.titleLabel = new JLabel();
        this.artistLabel = new JLabel();
        this.albumLabel = new JLabel();
        JPanel panel3 = new JPanel();
        JSeparator seperator2 = new JSeparator();
        this.whereTextArea = new JTextArea();
        DetailsPanel panel4 = new DetailsPanel();
        this.detailsPanel = new DetailsPanel();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        panel1.setLayout(new BorderLayout());
        panel1.setOpaque(false);
        panel1.add((Component)seperator1, "South");
        panel2.setLayout(new GridBagLayout());
        panel2.setOpaque(false);
        this.iconPanel.setBackground(new Color(255, 255, 255));
        this.iconPanel.setBorder(new LineBorder(new Color(153, 153, 153)));
        this.iconPanel.setPreferredSize(new Dimension(48, 48));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panel2.add((Component)this.iconPanel, gridBagConstraints);
        this.titleLabel.setText("TITLE (LENGTH)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        panel2.add((Component)this.titleLabel, gridBagConstraints);
        this.artistLabel.setText("ARTIST");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        panel2.add((Component)this.artistLabel, gridBagConstraints);
        this.albumLabel.setText("ALBUM");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        panel2.add((Component)this.albumLabel, gridBagConstraints);
        panel1.add((Component)panel2, "West");
        this.add((Component)panel1, "North");
        panel3.setLayout(new BorderLayout());
        panel3.setOpaque(false);
        panel3.add((Component)seperator2, "North");
        this.whereTextArea.setEditable(false);
        this.whereTextArea.setLineWrap(true);
        this.whereTextArea.setRows(2);
        this.whereTextArea.setText("/Users/roger/Shared/HackThePlanet.mp3");
        this.whereTextArea.setWrapStyleWord(true);
        this.whereTextArea.setMinimumSize(new Dimension(12, 13));
        this.whereTextArea.setPreferredSize(new Dimension(12, 32));
        this.whereTextArea.setOpaque(false);
        panel3.add((Component)this.whereTextArea, "South");
        this.add((Component)panel3, "South");
        panel4.setLayout(new FlowLayout(0));
        panel4.setOpaque(false);
        this.detailsPanel.setLayout(new GridLayout(8, 2, 3, 0));
        this.detailsPanel.setOpaque(false);
        panel4.add(this.detailsPanel);
        this.add((Component)panel4, "Center");
    }
}

