/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.BlockingHandshakeSupport;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;

public class BlockingOutgoingHandshaker
implements Handshaker {
    private BlockingHandshakeSupport support;
    private Properties ourRequestHeaders;
    private HandshakeResponder ourResponder;

    public BlockingOutgoingHandshaker(Properties requestHeaders, HandshakeResponder responder, Socket socket, InputStream in, OutputStream out) {
        this.support = new BlockingHandshakeSupport(socket, in, out);
        this.ourRequestHeaders = requestHeaders;
        this.ourResponder = responder;
    }

    public HandshakeResponse getReadHeaders() {
        return this.support.getReadHandshakeResponse();
    }

    public HandshakeResponse getWrittenHeaders() {
        return this.support.getWrittenHandshakeResponse();
    }

    public void shake() throws IOException, BadHandshakeException, NoGnutellaOkException {
        this.initializeOutgoing();
        this.concludeOutgoingHandshake();
    }

    private void initializeOutgoing() throws IOException {
        this.support.writeConnectLine();
        this.support.sendHeaders(this.ourRequestHeaders);
    }

    private void concludeOutgoingHandshake() throws IOException {
        String connectLine = this.support.readLine();
        if (!this.support.isConnectLineValid(connectLine)) {
            HandshakingStat.OUTGOING_BAD_CONNECT.incrementStat();
            throw new IOException("Bad connect string");
        }
        this.support.readHeaders(8000);
        HandshakeResponse theirResponse = this.support.createRemoteResponse(connectLine);
        switch (theirResponse.getStatusCode()) {
            case 200: {
                break;
            }
            case 503: {
                this.handleSlotsFullStats(theirResponse);
                throw NoGnutellaOkException.SERVER_REJECT;
            }
            default: {
                HandshakingStat.OUTGOING_SERVER_UNKNOWN.incrementStat();
                throw NoGnutellaOkException.createServerUnknown(theirResponse.getStatusCode());
            }
        }
        HandshakeResponse ourResponse = this.ourResponder.respond(theirResponse, true);
        this.support.writeResponse(ourResponse);
        switch (ourResponse.getStatusCode()) {
            case 200: {
                HandshakingStat.SUCCESSFUL_OUTGOING.incrementStat();
                break;
            }
            case 503: {
                HandshakingStat.OUTGOING_CLIENT_REJECT.incrementStat();
                throw NoGnutellaOkException.CLIENT_REJECT;
            }
            case 577: {
                throw NoGnutellaOkException.CLIENT_REJECT_LOCALE;
            }
            default: {
                HandshakingStat.OUTGOING_CLIENT_UNKNOWN.incrementStat();
                throw NoGnutellaOkException.createClientUnknown(ourResponse.getStatusCode());
            }
        }
    }

    private void handleSlotsFullStats(HandshakeResponse theirResponse) {
        if (theirResponse.isLimeWire()) {
            if (theirResponse.isUltrapeer()) {
                HandshakingStat.OUTGOING_LIMEWIRE_ULTRAPEER_REJECT.incrementStat();
            } else {
                HandshakingStat.OUTGOING_LIMEWIRE_LEAF_REJECT.incrementStat();
            }
        } else if (theirResponse.isUltrapeer()) {
            HandshakingStat.OUTGOING_OTHER_ULTRAPEER_REJECT.incrementStat();
        } else {
            HandshakingStat.OUTGOING_OTHER_LEAF_REJECT.incrementStat();
        }
    }
}

