/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.statistics.HandshakingStat;
import com.limegroup.gnutella.util.NetworkUtils;
import java.util.Properties;

public class UltrapeerHandshakeResponder
extends DefaultHandshakeResponder {
    public UltrapeerHandshakeResponder(String host) {
        super(host);
    }

    protected HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        HandshakeStatus status = this._manager.allowConnection(response);
        if (!status.isAcceptable()) {
            HandshakingStat.UP_OUTGOING_REJECT_FULL.incrementStat();
            return HandshakeResponse.createRejectOutgoingResponse(status);
        }
        Properties ret = new Properties();
        if (response.hasLeafGuidance()) {
            if (this._manager.allowLeafDemotion() && response.isGoodUltrapeer()) {
                HandshakingStat.UP_OUTGOING_GUIDANCE_FOLLOWED.incrementStat();
                ret.put("X-Ultrapeer", "False");
            } else {
                HandshakingStat.UP_OUTGOING_GUIDANCE_IGNORED.incrementStat();
            }
        } else {
            HandshakingStat.UP_OUTGOING_ACCEPT.incrementStat();
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    protected HandshakeResponse respondToIncoming(HandshakeResponse response) {
        if (response.isCrawler()) {
            HandshakingStat.INCOMING_CRAWLER.incrementStat();
            return HandshakeResponse.createCrawlerResponse();
        }
        UltrapeerHeaders ret = new UltrapeerHeaders(this.getRemoteIP());
        ret.put("Listen-IP", NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort());
        HandshakeStatus status = this.reject(response, ret);
        if (!status.isAcceptable()) {
            return HandshakeResponse.createUltrapeerRejectIncomingResponse(response, status);
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(response, ret);
    }

    private HandshakeStatus reject(HandshakeResponse response, Properties ret) {
        HandshakeStatus leafStatus = this._manager.allowConnectionAsLeaf(response);
        boolean allowedAsLeaf = leafStatus.isAcceptable();
        if (response.isLeaf()) {
            if (!allowedAsLeaf) {
                HandshakingStat.UP_INCOMING_REJECT_LEAF.incrementStat();
            } else {
                HandshakingStat.UP_INCOMING_ACCEPT_LEAF.incrementStat();
            }
            return leafStatus;
        }
        boolean supernodeNeeded = this._manager.supernodeNeeded();
        if (allowedAsLeaf && !supernodeNeeded) {
            HandshakingStat.UP_INCOMING_GUIDED.incrementStat();
            ret.put("X-Ultrapeer-Needed", Boolean.FALSE.toString());
            return HandshakeStatus.OK;
        }
        HandshakeStatus upStatus = this._manager.allowConnection(response);
        boolean allowedAsUltrapeer = upStatus.isAcceptable();
        if (allowedAsUltrapeer) {
            HandshakingStat.UP_INCOMING_ACCEPT_UP.incrementStat();
            ret.put("X-Ultrapeer-Needed", Boolean.TRUE.toString());
            return upStatus;
        }
        if (!allowedAsLeaf) {
            HandshakingStat.UP_INCOMING_REJECT_NO_ROOM_LEAF.incrementStat();
            return leafStatus;
        }
        HandshakingStat.UP_INCOMING_REJECT_NO_ROOM_UP.incrementStat();
        return upStatus;
    }
}

