/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HeaderSupport;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ReadState;
import com.limegroup.gnutella.statistics.Statistic;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ReadHeadersIOState
extends ReadState {
    private static final Log LOG = LogFactory.getLog(ReadHeadersIOState.class);
    protected final HeaderSupport support;
    private final Statistic stat;
    private final int maxHeaderSize;
    private final int maxHeaders;
    protected boolean doneConnect;
    protected StringBuffer currentHeader = new StringBuffer(1024);
    protected String connectLine;
    private long amountRead;

    public ReadHeadersIOState(HeaderSupport support, Statistic stat, int maxHeaders, int maxHeaderSize) {
        this.support = support;
        this.stat = stat;
        this.maxHeaders = maxHeaders;
        this.maxHeaderSize = maxHeaderSize;
    }

    protected boolean processRead(ReadableByteChannel rc, ByteBuffer buffer) throws IOException {
        boolean allDone = false;
        while (!allDone) {
            int read = 0;
            while (buffer.hasRemaining() && (read = rc.read(buffer)) > 0) {
                if (this.stat != null) {
                    this.stat.addData(read);
                }
                this.amountRead += (long)read;
            }
            if (buffer.position() == 0) {
                if (read != -1) break;
                throw new IOException("EOF");
            }
            buffer.flip();
            if (!this.doneConnect && BufferUtils.readLine(buffer, this.currentHeader)) {
                this.connectLine = this.currentHeader.toString();
                LOG.debug("Read connect line: " + this.connectLine);
                this.currentHeader.delete(0, this.currentHeader.length());
                this.processConnectLine();
                this.doneConnect = true;
            }
            if (this.doneConnect) {
                while (BufferUtils.readLine(buffer, this.currentHeader)) {
                    LOG.debug("Read header: " + this.currentHeader);
                    if (!this.support.processReadHeader(this.currentHeader.toString())) {
                        allDone = true;
                        break;
                    }
                    this.currentHeader.delete(0, this.currentHeader.length());
                    if (this.support.getHeadersReadSize() <= this.maxHeaders) continue;
                    throw new IOException("too many headers");
                }
            }
            buffer.compact();
            if (this.currentHeader.length() <= this.maxHeaderSize) continue;
            throw new IOException("header too big");
        }
        if (allDone) {
            this.processHeaders();
            return false;
        }
        return true;
    }

    public long getAmountProcessed() {
        return this.amountRead;
    }

    protected abstract void processConnectLine() throws IOException;

    protected abstract void processHeaders() throws IOException;
}

